/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class NumberToFloatTransform
extends Transform {
    private Class<?> sourceType;
    private boolean isNarrowing;
    private boolean isLossy;

    public NumberToFloatTransform(DataTypeManagerService dataTypeManager, Class<?> sourceType, boolean isNarrowing, boolean isLossy) {
        super(dataTypeManager);
        this.sourceType = sourceType;
        this.isNarrowing = isNarrowing;
        this.isLossy = isLossy;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        if (this.isNarrowing) {
            this.checkValueRange(value, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE));
        }
        return Float.valueOf(((Number)value).floatValue());
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.FLOAT.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing || this.isLossy;
    }
}

