/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class NumberToLongTransform
extends Transform {
    private Class<?> sourceType;
    private boolean isNarrowing;
    private boolean isLossy;

    public NumberToLongTransform(DataTypeManagerService dataTypeManager, Class<?> sourceType, boolean isNarrowing, boolean isLossy) {
        super(dataTypeManager);
        this.sourceType = sourceType;
        this.isNarrowing = isNarrowing;
        this.isLossy = isLossy;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        if (this.isNarrowing) {
            this.checkValueRange(value, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        return ((Number)value).longValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.LONG.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing || this.isLossy;
    }
}

