/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class NumberToShortTransform
extends Transform {
    private Class<?> sourceType;
    private boolean isNarrowing;

    public NumberToShortTransform(DataTypeManagerService dataTypeManager, Class<?> sourceType, boolean isNarrowing) {
        super(dataTypeManager);
        this.sourceType = sourceType;
        this.isNarrowing = isNarrowing;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        if (this.isNarrowing) {
            this.checkValueRange(value, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
        }
        return ((Number)value).shortValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.SHORT.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing;
    }
}

