/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class ObjectToAnyTransform
extends Transform {
    private Class targetClass;

    public ObjectToAnyTransform(DataTypeManagerService dataTypeManager, Class targetClass) {
        super(dataTypeManager);
        this.targetClass = targetClass;
    }

    public Class getSourceType() {
        return DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass();
    }

    public Class getTargetType() {
        return this.targetClass;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        if (this.targetClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        DataTypeManagerService.DefaultDataTypes valueDataType = this.dataTypeManager.getDataType(value.getClass());
        DataTypeManagerService.DefaultDataTypes targetDataType = this.dataTypeManager.getDataType(this.getTargetType());
        Transform transform = this.dataTypeManager.getTransform(valueDataType, targetDataType);
        boolean valid = true;
        if (transform instanceof ObjectToAnyTransform) {
            Object v1 = this.dataTypeManager.convertToRuntimeType(value, true);
            if (v1 != value) {
                try {
                    return this.transformDirect(v1);
                }
                catch (Exception e) {
                    throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID10076, this.getSourceType(), this.targetClass, value));
                }
            }
            valid = false;
        }
        if (transform == null || !valid) {
            Object[] params = new Object[]{this.getSourceType(), this.targetClass, value};
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID10076, params));
        }
        try {
            return transform.transform(value);
        }
        catch (Exception e) {
            Object[] params = new Object[]{this.getSourceType(), this.targetClass, value};
            throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID10076, params));
        }
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

