/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class StringToBooleanTransform
extends Transform {
    public StringToBooleanTransform(DataTypeManagerService dataTypeManager) {
        super(dataTypeManager);
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        String str = ((String)value).trim();
        if ("0".equals(str) || "false".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        if ("unknown".equals(str)) {
            return null;
        }
        return Boolean.TRUE;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

