/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Transform;
import org.teiid.core.types.XMLType;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class StringToSQLXMLTransform
extends Transform {
    public StringToSQLXMLTransform(DataTypeManagerService dataTypeManager) {
        super(dataTypeManager);
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        String xml = (String)value;
        StringReader reader = new StringReader(xml);
        XMLType.Type type = StringToSQLXMLTransform.isXml(reader);
        XMLType result = new XMLType(new SQLXMLImpl(xml));
        result.setType(type);
        return result;
    }

    public static XMLType.Type isXml(Reader reader) throws Exception {
        XMLType.Type type = XMLType.Type.ELEMENT;
        XMLInputFactory inputFactory = XMLType.getXmlInputFactory();
        try {
            try {
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(reader);
                int event = xmlReader.getEventType();
                if (event == 7 && xmlReader.getLocation().getColumnNumber() != 1) {
                    type = XMLType.Type.DOCUMENT;
                }
                while (xmlReader.hasNext()) {
                    xmlReader.next();
                }
            }
            catch (Exception e) {
                throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID10070, new Object[0]));
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return type;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.XML.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

