/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.sql.Time;
import java.util.regex.Pattern;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class StringToTimeTransform
extends Transform {
    private static boolean validate = true;
    private static Pattern pattern = Pattern.compile("\\d{2}:\\d{2}:\\d{2}");

    static {
        try {
            Time.valueOf("26:10:10");
        }
        catch (Exception exception) {
            validate = false;
        }
    }

    public StringToTimeTransform(DataTypeManagerService dataTypeManager) {
        super(dataTypeManager);
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        value = ((String)value).trim();
        Time result = null;
        try {
            result = Time.valueOf((String)value);
        }
        catch (Exception e) {
            if (!validate && pattern.matcher((String)value).matches()) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID10060, value, this.getTargetType().getSimpleName()));
            }
            throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID10068, value));
        }
        if (validate && !result.toString().equals(value)) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID10060, value, this.getTargetType().getSimpleName()));
        }
        return result;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.TIME.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

