/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.sql.Timestamp;
import java.util.regex.Pattern;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class StringToTimestampTransform
extends Transform {
    private static boolean validate = true;
    private static Pattern pattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}(\\.\\d{1,9})?");

    static {
        try {
            Timestamp.valueOf("2000-14-01 00:00:00");
        }
        catch (Exception exception) {
            validate = false;
        }
    }

    public StringToTimestampTransform(DataTypeManagerService dataTypeManager) {
        super(dataTypeManager);
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        value = ((String)value).trim();
        Timestamp result = null;
        try {
            result = Timestamp.valueOf((String)value);
        }
        catch (Exception e) {
            if (!validate && pattern.matcher((String)value).matches()) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID10060, value, this.getTargetType().getSimpleName()));
            }
            throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID10059, value));
        }
        if (!((String)value).startsWith(result.toString().substring(0, 19))) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID10060, value, this.getTargetType().getSimpleName()));
        }
        return result;
    }

    @Override
    public Class<?> getSourceType() {
        return String.class;
    }

    @Override
    public Class<?> getTargetType() {
        return Timestamp.class;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

