/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public final class ApplicationInfo
implements Serializable {
    private static final long serialVersionUID = 5497221915458216010L;
    public static final String APPLICATION_PRODUCT_INFORMATION = "Product Information";
    public static final String APPLICATION_BUILD_NUMBER_PROPERTY = "Build";
    private static final ApplicationInfo INSTANCE = new ApplicationInfo();
    private static final String LINE_SEPARATOR = "\n";
    private static final String COPYRIGHT = "copyright";
    private static final String URL = "url";
    private Properties props = new Properties();
    private ITeiidServerVersion teiidVersion = TeiidServerVersion.Version.TEIID_DEFAULT.get();

    private ApplicationInfo() {
        this.props.setProperty(COPYRIGHT, "Copyright (C) 2008-2009 Red Hat, Inc");
        this.props.setProperty(URL, "http://www.jboss.org/teiid");
    }

    public void setTeiidVersion(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
    }

    public String getReleaseNumber() {
        return this.teiidVersion.toString();
    }

    public int getMajorReleaseVersion() {
        String version = this.teiidVersion.getMajor();
        return Integer.parseInt(version);
    }

    public int getMinorReleaseVersion() {
        String version = this.teiidVersion.getMinor();
        return Integer.parseInt(version);
    }

    public String getUrl() {
        return this.props.getProperty(URL);
    }

    public String getCopyright() {
        return this.props.getProperty(COPYRIGHT);
    }

    public static ApplicationInfo getInstance() {
        return INSTANCE;
    }

    private static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public String getClasspathInfo() {
        String classPath = ApplicationInfo.getClassPath();
        StringBuffer sb = new StringBuffer();
        sb.append("\nDate: " + DateFormat.getDateInstance().format(new Date()));
        sb.append(LINE_SEPARATOR);
        HashMap<String, Boolean> pathResults = new HashMap<String, Boolean>();
        ArrayList<String> reversetList = new ArrayList<String>();
        String separator = System.getProperty("path.separator");
        StringTokenizer path = new StringTokenizer(classPath, separator);
        while (path.hasMoreTokens()) {
            String pathElement = path.nextToken();
            File pathFile = new File(pathElement);
            if (pathFile.exists()) {
                pathResults.put(pathElement, Boolean.TRUE);
            } else {
                pathResults.put(pathElement, Boolean.FALSE);
            }
            reversetList.add(pathElement);
        }
        sb.append("Classpath Information");
        sb.append(LINE_SEPARATOR);
        sb.append("CLASSPATH: ");
        sb.append(classPath);
        sb.append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        Iterator iter = reversetList.iterator();
        sb.append("---- Classpath Entries ----");
        sb.append(LINE_SEPARATOR);
        while (iter.hasNext()) {
            String epath = (String)iter.next();
            Boolean doesExist = (Boolean)pathResults.get(epath);
            sb.append(epath);
            if (!doesExist.booleanValue()) {
                sb.append(" (MISSING)");
            }
            sb.append(LINE_SEPARATOR);
        }
        sb.append(LINE_SEPARATOR);
        sb.append("Note the (MISSING) at the end to designate that the classpath entry is missing");
        try {
            Enumeration<URL> readmes = ClassLoader.getSystemResources("patch_readme.txt");
            sb.append(LINE_SEPARATOR);
            sb.append(LINE_SEPARATOR);
            sb.append("---- Patch Readme Entries----");
            sb.append(LINE_SEPARATOR);
            int cnt = 0;
            if (readmes != null) {
                while (readmes.hasMoreElements()) {
                    ++cnt;
                    URL url = readmes.nextElement();
                    sb.append("Patch " + url.getFile() + ":");
                    sb.append(LINE_SEPARATOR);
                    InputStream is = url.openStream();
                    byte[] data = ObjectConverterUtil.convertToByteArray(is);
                    sb.append(new String(data));
                    sb.append("-------------------------------------");
                    sb.append(LINE_SEPARATOR);
                    is.close();
                }
            }
            if (cnt == 0) {
                sb.append("no Patch Readme Entries found");
            }
        }
        catch (IOException iOException) {}
        return sb.toString();
    }
}

