/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class ReflectionHelper {
    private Class<?> targetClass;
    private Map<String, LinkedList<Method>> methodMap = null;

    public ReflectionHelper(Class<?> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.Misc.ReflectionHelper_errorConstructing, new Object[0]));
        }
        this.targetClass = targetClass;
    }

    public Method findBestMethodOnTarget(String methodName, Object[] arguments) throws NoSuchMethodException, SecurityException {
        this.createMethodMap();
        List methods = this.methodMap.get(methodName);
        if (methods != null && methods.size() == 1) {
            return (Method)methods.get(0);
        }
        if (arguments == null) {
            return this.findBestMethodWithSignature(methodName, Collections.EMPTY_LIST);
        }
        int size = arguments.length;
        ArrayList argumentClasses = new ArrayList(size);
        int i = 0;
        while (i != size) {
            if (arguments[i] != null) {
                Class<?> clazz = arguments[i].getClass();
                argumentClasses.add(clazz);
            } else {
                argumentClasses.add(null);
            }
            ++i;
        }
        return this.findBestMethodWithSignature(methodName, argumentClasses);
    }

    public Method findBestMethodWithSignature(String methodName, Object[] argumentsClasses) throws NoSuchMethodException, SecurityException {
        List<Object> argumentClassesList = Arrays.asList(argumentsClasses);
        return this.findBestMethodWithSignature(methodName, argumentClassesList);
    }

    /*
     * Unable to fully structure code
     */
    public Method findBestMethodWithSignature(String methodName, List<Class<?>> argumentsClasses) throws NoSuchMethodException, SecurityException {
        result = null;
        classArgs = new Class[argumentsClasses.size()];
        try {
            argumentsClasses.toArray(classArgs);
            result = this.targetClass.getMethod(methodName, classArgs);
            return result;
        }
        catch (NoSuchMethodException v0) {
            argumentsClassList = ReflectionHelper.convertArgumentClassesToPrimitives(argumentsClasses);
            argumentsClassList.toArray(classArgs);
            try {
                result = this.targetClass.getMethod(methodName, classArgs);
                return result;
            }
            catch (NoSuchMethodException v1) {
                this.createMethodMap();
                methodsWithSameName = this.methodMap.get(methodName);
                if (methodsWithSameName == null) {
                    throw new NoSuchMethodException(methodName);
                }
                ** for (method : methodsWithSameName)
            }
        }
lbl-1000:
        // 1 sources

        {
            args = method.getParameterTypes();
            allMatch = ReflectionHelper.argsMatch(argumentsClasses, argumentsClassList, args);
            if (!allMatch) continue;
            if (result != null) {
                throw new NoSuchMethodException(String.valueOf(methodName) + " Args: " + argumentsClasses + " has multiple possible signatures.");
            }
            result = method;
            continue;
        }
lbl28:
        // 1 sources

        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException(String.valueOf(methodName) + " Args: " + argumentsClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMethodMap() {
        if (this.methodMap == null) {
            ReflectionHelper reflectionHelper = this;
            synchronized (reflectionHelper) {
                if (this.methodMap != null) {
                    return;
                }
                HashMap<String, LinkedList<Method>> newMethodMap = new HashMap<String, LinkedList<Method>>();
                Method[] methods = this.targetClass.getMethods();
                int i = 0;
                while (i != methods.length) {
                    Method method = methods[i];
                    LinkedList<Method> methodsWithSameName = newMethodMap.get(method.getName());
                    if (methodsWithSameName == null) {
                        methodsWithSameName = new LinkedList();
                        newMethodMap.put(method.getName(), methodsWithSameName);
                    }
                    methodsWithSameName.addFirst(method);
                    ++i;
                }
                this.methodMap = newMethodMap;
            }
        }
    }

    private static boolean argsMatch(List<Class<?>> argumentsClasses, List<Class<?>> argumentsClassList, Class[] args) {
        if (args.length != argumentsClasses.size()) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            Class<?> primitiveClazz = argumentsClassList.get(i);
            Class<?> objectClazz = argumentsClasses.get(i);
            if (objectClazz != null ? !args[i].equals(primitiveClazz) && !args[i].isAssignableFrom(objectClazz) : args[i].isPrimitive()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static List<Class<?>> convertArgumentClassesToPrimitives(List<Class<?>> arguments) {
        ArrayList result = new ArrayList(arguments.size());
        for (Class<Object> clazz : arguments) {
            if (clazz == Boolean.class) {
                clazz = Boolean.TYPE;
            } else if (clazz == Character.class) {
                clazz = Character.TYPE;
            } else if (clazz == Byte.class) {
                clazz = Byte.TYPE;
            } else if (clazz == Short.class) {
                clazz = Short.TYPE;
            } else if (clazz == Integer.class) {
                clazz = Integer.TYPE;
            } else if (clazz == Long.class) {
                clazz = Long.TYPE;
            } else if (clazz == Float.class) {
                clazz = Float.TYPE;
            } else if (clazz == Double.class) {
                clazz = Double.TYPE;
            } else if (clazz == Void.class) {
                clazz = Void.TYPE;
            }
            result.add(clazz);
        }
        return result;
    }

    private static final Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> cls = null;
        cls = classLoader == null ? Class.forName(className.trim()) : Class.forName(className.trim(), true, classLoader);
        return cls;
    }

    public static final Object create(String className, Collection<?> ctorObjs, ClassLoader classLoader) throws TeiidClientException {
        try {
            int size = ctorObjs == null ? 0 : ctorObjs.size();
            Class[] names = new Class[size];
            Object[] objArray = new Object[size];
            int i = 0;
            if (size > 0) {
                for (Object obj : ctorObjs) {
                    if (obj != null) {
                        names[i] = obj.getClass();
                        objArray[i] = obj;
                    }
                    ++i;
                }
            }
            return ReflectionHelper.create(className, objArray, names, classLoader);
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
    }

    public static final Object create(String className, Object[] ctorObjs, Class<?>[] argTypes, ClassLoader classLoader) throws TeiidClientException {
        Class<?> cls;
        try {
            cls = ReflectionHelper.loadClass(className, classLoader);
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
        Constructor<?> ctor = null;
        try {
            ctor = cls.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (ctor == null && argTypes != null && argTypes.length > 0) {
            List<Class<?>> argumentsClasses = Arrays.asList(argTypes);
            List<Class<?>> argumentsClassList = ReflectionHelper.convertArgumentClassesToPrimitives(argumentsClasses);
            Constructor<?>[] constructorArray = cls.getDeclaredConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> possible = constructorArray[n2];
                if (ReflectionHelper.argsMatch(argumentsClasses, argumentsClassList, possible.getParameterTypes())) {
                    ctor = possible;
                    break;
                }
                ++n2;
            }
        }
        if (ctor == null) {
            throw new TeiidClientException(String.valueOf(className) + Arrays.toString(argTypes));
        }
        try {
            return ctor.newInstance(ctorObjs);
        }
        catch (InvocationTargetException e) {
            throw new TeiidClientException(e.getTargetException());
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
    }
}

