/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.runtime.client.Messages;

final class DataTypeTransformer {
    private DataTypeTransformer() {
    }

    private static DataTypeManagerService getDataTypeManager(ITeiidServerVersion teiidVersion) {
        DataTypeManagerService dataTypeManager = DataTypeManagerService.getInstance(teiidVersion);
        return dataTypeManager;
    }

    static final BigDecimal getBigDecimal(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, BigDecimal.class);
    }

    static final <T> T transform(ITeiidServerVersion teiidVersion, Object value, Class<T> targetType) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, targetType, DataTypeTransformer.getRuntimeType(teiidVersion, targetType));
    }

    static final <T> T transform(ITeiidServerVersion teiidVersion, Object value, Class<T> targetType, Class<?> runtimeType) throws SQLException {
        if (value == null || targetType.isAssignableFrom(value.getClass())) {
            return targetType.cast(value);
        }
        if (targetType == byte[].class) {
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                long length = blob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new SQLException(Messages.getString(Messages.JDBC.DataTypeTransformer_blob_too_big, new Object[0]));
                }
                return targetType.cast(blob.getBytes(1L, (int)length));
            }
            if (value instanceof String) {
                return targetType.cast(((String)value).getBytes());
            }
            if (value instanceof BinaryType) {
                return targetType.cast(((BinaryType)value).getBytesDirect());
            }
        } else if (targetType == String.class) {
            if (value instanceof SQLXML) {
                return targetType.cast(((SQLXML)value).getString());
            }
            if (value instanceof Clob) {
                Clob c = (Clob)value;
                long length = c.length();
                if (length == 0L) {
                    return targetType.cast("");
                }
                return targetType.cast(c.getSubString(1L, length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length));
            }
        }
        try {
            DataTypeManagerService dataTypeManager = DataTypeTransformer.getDataTypeManager(teiidVersion);
            return (T)dataTypeManager.transformValue(dataTypeManager.convertToRuntimeType(value, true), runtimeType);
        }
        catch (Exception e) {
            String valueStr = value.toString();
            if (valueStr.length() > 20) {
                valueStr = String.valueOf(valueStr.substring(0, 20)) + "...";
            }
            String msg = Messages.getString(Messages.JDBC.DataTypeTransformer_Err_converting, valueStr, targetType.getSimpleName());
            throw new SQLException(msg, e);
        }
    }

    static final <T> Class<?> getRuntimeType(ITeiidServerVersion teiidVersion, Class<T> type) {
        Class<Object> runtimeType = type;
        if (!DataTypeTransformer.getDataTypeManager(teiidVersion).getAllDataTypeClasses().contains(type)) {
            runtimeType = type == Clob.class ? DataTypeManagerService.DefaultDataTypes.CLOB.getTypeClass() : (type == Blob.class ? DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass() : (type == SQLXML.class ? DataTypeManagerService.DefaultDataTypes.XML.getTypeClass() : (type == byte[].class ? DataTypeManagerService.DefaultDataTypes.VARBINARY.getTypeClass() : DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass())));
        }
        return runtimeType;
    }

    static final boolean getBoolean(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        if (value == null) {
            return false;
        }
        return DataTypeTransformer.transform(teiidVersion, value, Boolean.class);
    }

    static final byte getByte(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(teiidVersion, value, Byte.class);
    }

    static final byte[] getBytes(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, byte[].class);
    }

    static final Character getCharacter(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, Character.class);
    }

    static final Date getDate(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, Date.class);
    }

    static final double getDouble(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        if (value == null) {
            return 0.0;
        }
        return DataTypeTransformer.transform(teiidVersion, value, Double.class);
    }

    static final float getFloat(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        if (value == null) {
            return 0.0f;
        }
        return DataTypeTransformer.transform(teiidVersion, value, Float.class).floatValue();
    }

    static final int getInteger(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(teiidVersion, value, Integer.class);
    }

    static final long getLong(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        if (value == null) {
            return 0L;
        }
        return DataTypeTransformer.transform(teiidVersion, value, Long.class);
    }

    static final short getShort(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(teiidVersion, value, Short.class);
    }

    static final Time getTime(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, Time.class);
    }

    static final Timestamp getTimestamp(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, Timestamp.class);
    }

    static final String getString(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, String.class);
    }

    static final Blob getBlob(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, Blob.class);
    }

    static final Clob getClob(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, Clob.class);
    }

    static final SQLXML getSQLXML(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, value, SQLXML.class);
    }

    static final Reader getCharacterStream(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return ((Clob)value).getCharacterStream();
        }
        if (value instanceof SQLXML) {
            return ((SQLXML)value).getCharacterStream();
        }
        return new StringReader(DataTypeTransformer.getString(teiidVersion, value));
    }

    static final InputStream getAsciiStream(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return ((Clob)value).getAsciiStream();
        }
        if (value instanceof SQLXML) {
            return new ReaderInputStream(((SQLXML)value).getCharacterStream(), Charset.forName("ASCII"));
        }
        return new ByteArrayInputStream(DataTypeTransformer.getString(teiidVersion, value).getBytes(Charset.forName("ASCII")));
    }

    static final NClob getNClob(ITeiidServerVersion teiidVersion, Object value) throws SQLException {
        final Clob clob = DataTypeTransformer.getClob(teiidVersion, value);
        if (clob == null) {
            return null;
        }
        if (clob instanceof NClob) {
            return (NClob)clob;
        }
        return (NClob)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{NClob.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke((Object)clob, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }

    static final Array getArray(ITeiidServerVersion teiidVersion, Object obj) throws SQLException {
        return DataTypeTransformer.transform(teiidVersion, obj, Array.class, Object[].class);
    }
}

