/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.teiid.client.metadata.MetadataResult;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.core.util.StringUtil;
import org.teiid.jdbc.MetadataProvider;
import org.teiid.jdbc.StatementImpl;
import org.teiid.runtime.client.Messages;

public class DeferredMetadataProvider
extends MetadataProvider {
    private StatementImpl statement;
    private long requestID;
    private boolean loaded;

    public DeferredMetadataProvider(String[] columnNames, String[] columnTypes, StatementImpl statement, long requestID) {
        super(DeferredMetadataProvider.loadPartialMetadata(columnNames, columnTypes));
        this.statement = statement;
        this.requestID = requestID;
    }

    static Map<Integer, String>[] loadPartialMetadata(String[] columnNames, String[] columnTypes) {
        if (columnNames == null || columnTypes == null || columnNames.length != columnTypes.length) {
            Object[] params = new Object[]{StringUtil.toString(columnNames), StringUtil.toString(columnTypes)};
            throw new IllegalArgumentException(Messages.getString(Messages.JDBC.DeferredMetadataProvider_Invalid_data, params));
        }
        Map[] columnMetadata = new Map[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            columnMetadata[i] = new HashMap();
            columnMetadata[i].put(ResultsMetadataConstants.ELEMENT_LABEL, columnNames[i]);
            columnMetadata[i].put(ResultsMetadataConstants.DATA_TYPE, columnTypes[i]);
            ++i;
        }
        return columnMetadata;
    }

    private void loadFullMetadata() throws SQLException {
        MetadataResult results;
        try {
            results = this.statement.getDQP().getMetadata(this.requestID);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        this.metadata = results.getColumnMetadata();
    }

    @Override
    public Object getValue(int columnIndex, Integer metadataPropertyKey) throws SQLException {
        if (!this.loaded && metadataPropertyKey != ResultsMetadataConstants.ELEMENT_LABEL && metadataPropertyKey != ResultsMetadataConstants.DATA_TYPE) {
            this.loadFullMetadata();
            this.loaded = true;
        }
        return super.getValue(columnIndex, metadataPropertyKey);
    }
}

