/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import org.teiid.client.SourceWarning;
import org.teiid.jdbc.PartialResultsWarning;
import org.teiid.runtime.client.Messages;

class WarningUtil {
    private WarningUtil() {
    }

    static SQLWarning createWarning(Throwable ex) {
        String sourceName = null;
        String modelName = null;
        if (ex instanceof SourceWarning) {
            SourceWarning exception = (SourceWarning)ex;
            if (exception.isPartialResultsError()) {
                PartialResultsWarning warning = new PartialResultsWarning(Messages.getString(Messages.JDBC.WarningUtil_Failures_occurred, new Object[0]));
                warning.addConnectorFailure(exception.getConnectorBindingName(), new SQLException(exception));
                return warning;
            }
            ex = exception.getCause();
            sourceName = exception.getConnectorBindingName();
            modelName = exception.getModelName();
        }
        return new SQLWarning(sourceName, modelName, ex);
    }

    static SQLWarning convertWarnings(List<Throwable> exceptions) {
        SQLWarning root;
        if (exceptions == null || exceptions.size() == 0) {
            return null;
        }
        SQLWarning current = root = WarningUtil.createWarning(exceptions.get(0));
        int i = 1;
        while (i < exceptions.size()) {
            SQLWarning newWarning = WarningUtil.createWarning(exceptions.get(i));
            current.setNextWarning(newWarning);
            current = newWarning;
            ++i;
        }
        return root;
    }
}

