/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.metadata.BaseColumn;

public class FunctionParameter
extends BaseColumn {
    private static final long serialVersionUID = -4696050948395485266L;
    public static final String OUTPUT_PARAMETER_NAME = "result";
    private boolean isVarArg;

    public FunctionParameter(ITeiidServerVersion version) {
        super(version);
    }

    public FunctionParameter(ITeiidServerVersion version, String name, String type) {
        this(version, name, type, null);
    }

    public FunctionParameter(ITeiidServerVersion version, String name, DataTypeManagerService.DefaultDataTypes type, String description) {
        this(version, name, type.getId(), description, false);
    }

    public FunctionParameter(ITeiidServerVersion version, String name, String type, String description) {
        this(version, name, type, description, false);
    }

    public FunctionParameter(ITeiidServerVersion version, String name, DataTypeManagerService.DefaultDataTypes type, String description, boolean vararg) {
        this(version, name, type.getId(), description, vararg);
    }

    public FunctionParameter(ITeiidServerVersion version, String name, String type, String description, boolean vararg) {
        this(version);
        this.setName(name);
        this.setType(type);
        this.setDescription(description);
        this.isVarArg = vararg;
    }

    public String getDescription() {
        return this.getAnnotation();
    }

    public void setDescription(String description) {
        this.setAnnotation(description);
    }

    public String getType() {
        return this.getRuntimeType();
    }

    public void setType(String type) {
        this.setRuntimeType(type);
    }

    @Override
    public int hashCode() {
        if (this.getRuntimeType() == null) {
            return 0;
        }
        return this.getRuntimeType().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FunctionParameter)) {
            return false;
        }
        FunctionParameter other = (FunctionParameter)obj;
        if (other.getType() == null) {
            return this.getType() == null;
        }
        return other.getType().equals(this.getType()) && this.isVarArg == other.isVarArg;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getRuntimeType()) + (this.isVarArg ? "... " : " ") + this.getName();
    }

    public void setVarArg(boolean isVarArg) {
        this.isVarArg = isVarArg;
    }

    public boolean isVarArg() {
        return this.isVarArg;
    }
}

