/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Sequencable;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.StringToSQLXMLTransform;
import org.teiid.core.util.StringUtil;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.annotation.Updated;
import org.teiid.designer.query.sql.lang.IMatchCriteria;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.JSONFunctionMethods;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.processor.relational.XMLTableNode;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.CollectionValueIterator;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.IsDistinctCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NamespaceItem;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.proc.ExceptionExpression;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.JSONObject;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.XMLCast;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLExists;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.query.util.VariableContext;
import org.teiid.query.xquery.saxon.SaxonXQueryExpression;
import org.teiid.query.xquery.saxon.XQueryEvaluator;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;
import org.teiid.runtime.client.query.SyntaxFactory;

public class Evaluator {
    private static final char[] REGEX_RESERVED = new char[]{'$', '(', ')', '*', '+', '.', '?', '[', '\\', ']', '^', '{', '|', '}'};
    private static final MatchCriteria.PatternTranslator LIKE_TO_REGEX = new MatchCriteria.PatternTranslator(new char[]{'%', '_'}, new String[]{".*", "."}, REGEX_RESERVED, '\\', 32);
    private static final char[] SIMILAR_REGEX_RESERVED = new char[]{'$', '.', '\\', '^'};
    private static final MatchCriteria.PatternTranslator SIMILAR_TO_REGEX = new MatchCriteria.PatternTranslator(new char[]{'%', '(', ')', '*', '?', '+', '[', ']', '_', '{', '|', '}'}, new String[]{"([a]|[^a])*", "(", ")", "*", "?", "+", "[", "]", "([a]|[^a])", "{", "|", "}"}, SIMILAR_REGEX_RESERVED, '\\', 0);
    private final CommandContext context;
    private static ValueExtractor<NameValuePair<Object>> defaultExtractor = new ValueExtractor<NameValuePair<Object>>(){

        @Override
        public Object getValue(NameValuePair<Object> t) {
            return t.value;
        }
    };
    private static /* synthetic */ int[] $SWITCH_TABLE$org$teiid$query$sql$lang$SubqueryCompareCriteria$PredicateQuantifier;

    public Evaluator(ITeiidServerVersion teiidVersion) {
        this.context = new CommandContext(teiidVersion);
    }

    public ITeiidServerVersion getTeiidVersion() {
        return this.context.getTeiidVersion();
    }

    public static boolean assess(Criteria criteria) throws Exception {
        return new Evaluator(criteria.getTeiidVersion()).evaluate(criteria);
    }

    public static Object assess(Expression expression) throws Exception {
        return new Evaluator(expression.getTeiidVersion()).evaluate(expression);
    }

    public boolean evaluate(Criteria criteria) throws Exception {
        return Boolean.TRUE.equals(this.evaluateTVL(criteria));
    }

    private Boolean evaluateTVL(Criteria criteria) throws Exception {
        return this.internalEvaluateTVL(criteria);
    }

    private Boolean internalEvaluateTVL(Criteria criteria) throws Exception {
        if (criteria instanceof CompoundCriteria) {
            return this.evaluate((CompoundCriteria)criteria);
        }
        if (criteria instanceof NotCriteria) {
            return this.evaluate((NotCriteria)criteria);
        }
        if (criteria instanceof CompareCriteria) {
            return this.evaluate((CompareCriteria)criteria);
        }
        if (criteria instanceof MatchCriteria) {
            return this.evaluate((MatchCriteria)criteria);
        }
        if (criteria instanceof AbstractSetCriteria) {
            return this.evaluate((AbstractSetCriteria)criteria);
        }
        if (criteria instanceof IsNullCriteria) {
            return this.evaluate((IsNullCriteria)criteria);
        }
        if (criteria instanceof SubqueryCompareCriteria) {
            return this.evaluate((SubqueryCompareCriteria)criteria);
        }
        if (criteria instanceof ExistsCriteria) {
            return this.evaluate((ExistsCriteria)criteria);
        }
        if (criteria instanceof ExpressionCriteria) {
            return (Boolean)this.evaluate(((ExpressionCriteria)criteria).getExpression());
        }
        if (criteria instanceof XMLExists) {
            return (Boolean)this.evaluateXMLQuery(((XMLExists)criteria).getXmlQuery(), true);
        }
        if (criteria instanceof IsDistinctCriteria) {
            IsDistinctCriteria idc = (IsDistinctCriteria)criteria;
            TempMetadataID left = (TempMetadataID)idc.getLeftRowValue().getMetadataID();
            TempMetadataID right = (TempMetadataID)idc.getRightRowValue().getMetadataID();
            VariableContext vc = this.context.getVariableContext();
            List<TempMetadataID> cols = left.getElements();
            List<TempMetadataID> colsOther = right.getElements();
            if (cols.size() != colsOther.size()) {
                return !idc.isNegated();
            }
            SyntaxFactory factory = new SyntaxFactory(criteria.getTeiidParser());
            int i = 0;
            while (i < cols.size()) {
                IElementSymbol symbol1 = factory.createElementSymbol(cols.get(i).getName());
                symbol1.setGroupSymbol((IGroupSymbol)idc.getLeftRowValue());
                Object l = vc.getValue(symbol1);
                IElementSymbol symbol2 = factory.createElementSymbol(colsOther.get(i).getName());
                symbol1.setGroupSymbol((IGroupSymbol)idc.getRightRowValue());
                Object r = vc.getValue(symbol2);
                if (l == null) {
                    if (r != null) {
                        if (idc.isNegated()) {
                            return false;
                        }
                        return true;
                    }
                } else if (r == null) {
                    if (idc.isNegated()) {
                        return false;
                    }
                    return true;
                }
                try {
                    Boolean b = Evaluator.compare(1, l, r);
                    if (b != null && !b.booleanValue()) {
                        if (idc.isNegated()) {
                            return false;
                        }
                        return true;
                    }
                }
                catch (Exception exception) {
                    if (idc.isNegated()) {
                        return false;
                    }
                    return true;
                }
                ++i;
            }
            if (idc.isNegated()) {
                return true;
            }
            return false;
        }
        throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30311, criteria));
    }

    private Boolean evaluate(CompoundCriteria criteria) throws Exception {
        List<Criteria> subCrits = criteria.getCriteria();
        boolean and = criteria.getOperator() == CompoundCriteria.AND;
        Boolean result = and ? Boolean.TRUE : Boolean.FALSE;
        int i = 0;
        while (i < subCrits.size()) {
            Criteria subCrit = subCrits.get(i);
            Boolean value = this.internalEvaluateTVL(subCrit);
            if (value == null) {
                result = null;
            } else if (!value.booleanValue()) {
                if (and) {
                    return Boolean.FALSE;
                }
            } else if (!and) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return result;
    }

    private Boolean evaluate(NotCriteria criteria) throws Exception {
        Criteria subCrit = criteria.getCriteria();
        Boolean result = this.internalEvaluateTVL(subCrit);
        if (result == null) {
            return null;
        }
        if (result.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean evaluate(CompareCriteria criteria) throws Exception {
        Object leftValue = null;
        try {
            leftValue = this.evaluate((Expression)criteria.getLeftExpression());
        }
        catch (Exception exception) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30312, "left", criteria));
        }
        if (leftValue == null) {
            return null;
        }
        Object rightValue = null;
        try {
            rightValue = this.evaluate(criteria.getRightExpression());
        }
        catch (Exception exception) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30312, "right", criteria));
        }
        if (rightValue == null) {
            return null;
        }
        return Evaluator.compare(criteria.getOperator(), leftValue, rightValue);
    }

    private Boolean evaluate(MatchCriteria criteria) throws Exception {
        boolean result = false;
        Object value = null;
        try {
            value = this.evaluate(criteria.getLeftExpression());
        }
        catch (Exception exception) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30312, "left", criteria));
        }
        if (value == null) {
            return null;
        }
        CharSequence leftValue = null;
        if (value instanceof CharSequence) {
            leftValue = (CharSequence)value;
        } else {
            try {
                leftValue = ((Sequencable)value).getCharSequence();
            }
            catch (SQLException err) {
                throw new TeiidClientException(err, err.getMessage());
            }
        }
        String rightValue = null;
        try {
            rightValue = (String)this.evaluate(criteria.getRightExpression());
        }
        catch (Exception exception) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30312, "right", criteria));
        }
        if (rightValue == null) {
            return null;
        }
        result = this.match(rightValue, criteria.getEscapeChar(), leftValue, criteria.getMode());
        return result ^ criteria.isNegated();
    }

    private boolean match(String pattern, char escape, CharSequence search, IMatchCriteria.MatchMode mode) throws Exception {
        Pattern patternRegex = null;
        switch (mode) {
            case LIKE: {
                patternRegex = LIKE_TO_REGEX.translate(pattern, escape);
                break;
            }
            case SIMILAR: {
                patternRegex = SIMILAR_TO_REGEX.translate(pattern, escape);
                break;
            }
            case REGEX: {
                patternRegex = MatchCriteria.getPattern(pattern, pattern, 0);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Matcher matcher = patternRegex.matcher(search);
        return matcher.find();
    }

    /*
     * Unable to fully structure code
     */
    private Boolean evaluate(AbstractSetCriteria criteria) throws Exception {
        block18: {
            block17: {
                teiidParser = criteria.getTeiidParser();
                leftValue = null;
                try {
                    leftValue = this.evaluate(criteria.getExpression());
                }
                catch (Exception v0) {
                    throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30323, new Object[]{criteria}));
                }
                result = Boolean.FALSE;
                valueIter = null;
                if (!(criteria instanceof SetCriteria)) break block17;
                set = (SetCriteria)criteria;
                if (leftValue == null) {
                    if (!set.getValues().isEmpty()) {
                        return null;
                    }
                    return criteria.isNegated();
                }
                if (set.isAllConstants()) {
                    c = (Constant)teiidParser.createASTNode(TeiidNodeFactory.ASTNodes.CONSTANT);
                    c.setValue(leftValue);
                    c.setType(criteria.getExpression().getType());
                    exists = set.getValues().contains(c);
                    if (!exists) {
                        if (set.getValues().contains(Constant.getNullConstant(teiidParser))) {
                            return null;
                        }
                        return criteria.isNegated();
                    }
                    return criteria.isNegated() == false;
                }
                valueIter = new CollectionValueIterator(((SetCriteria)criteria).getValues());
                ** GOTO lbl53
            }
            if (!(criteria instanceof SubquerySetCriteria)) break block18;
            try {
                valueIter = this.evaluateSubquery((SubquerySetCriteria)criteria);
                if (true) ** GOTO lbl53
            }
            catch (Exception e) {
                throw new TeiidClientException(e);
            }
        }
        throw new AssertionError((Object)"unknown set criteria type");
        do {
            if (leftValue == null) {
                return null;
            }
            possibleValue = valueIter.next();
            value = null;
            if (possibleValue instanceof Expression) {
                try {
                    value = this.evaluate((Expression)possibleValue);
                }
                catch (Exception v1) {
                    throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30323, new Object[]{possibleValue}));
                }
            } else {
                value = possibleValue;
            }
            if (value != null) {
                if (Constant.COMPARATOR.compare(leftValue, value) != 0) continue;
                return criteria.isNegated() == false;
            }
            result = null;
lbl53:
            // 4 sources

        } while (valueIter.hasNext());
        if (result == null) {
            return null;
        }
        return criteria.isNegated();
    }

    private boolean evaluate(IsNullCriteria criteria) throws Exception {
        Object value = null;
        try {
            value = this.evaluate(criteria.getExpression());
        }
        catch (Exception exception) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30323, criteria));
        }
        return value == null ^ criteria.isNegated();
    }

    /*
     * Unable to fully structure code
     */
    private Boolean evaluate(SubqueryCompareCriteria criteria) throws Exception {
        leftValue = null;
        try {
            leftValue = this.evaluate(criteria.getLeftExpression());
        }
        catch (Exception v0) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30323, new Object[]{criteria}));
        }
        result = Boolean.FALSE;
        if (criteria.getPredicateQuantifier() == SubqueryCompareCriteria.PredicateQuantifier.ALL) {
            result = Boolean.TRUE;
        }
        try {
            valueIter = this.evaluateSubquery(criteria);
            if (true) ** GOTO lbl44
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
        block12: do {
            value = valueIter.next();
            if (leftValue == null) {
                return null;
            }
            if (value != null) {
                comp = Evaluator.compare(criteria.getOperator(), leftValue, value);
                switch (Evaluator.$SWITCH_TABLE$org$teiid$query$sql$lang$SubqueryCompareCriteria$PredicateQuantifier()[criteria.getPredicateQuantifier().ordinal()]) {
                    case 3: {
                        if (!Boolean.FALSE.equals(comp)) continue block12;
                        return Boolean.FALSE;
                    }
                    case 1: {
                        if (!Boolean.TRUE.equals(comp)) continue block12;
                        return Boolean.TRUE;
                    }
                    default: {
                        throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30326, new Object[]{criteria.getPredicateQuantifier()}));
                    }
                }
            }
            if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_12_4)) {
                result = null;
                continue;
            }
            switch (Evaluator.$SWITCH_TABLE$org$teiid$query$sql$lang$SubqueryCompareCriteria$PredicateQuantifier()[criteria.getPredicateQuantifier().ordinal()]) {
                case 3: {
                    if (!Boolean.TRUE.equals(result)) continue block12;
                    result = null;
                    break;
                }
                case 1: {
                    if (!Boolean.FALSE.equals(result)) continue block12;
                    result = null;
                    break;
                }
                default: {
                    throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30326, new Object[]{criteria.getPredicateQuantifier()}));
                }
            }
lbl44:
            // 8 sources

        } while (valueIter.hasNext());
        return result;
    }

    @Updated(version={TeiidServerVersion.Version.TEIID_8_12_4})
    public static Boolean compare(int operator, Object leftValue, Object value) throws AssertionError {
        int compare = 0;
        if (leftValue instanceof ArrayImpl) {
            ArrayImpl av = (ArrayImpl)leftValue;
            try {
                compare = av.compareTo((ArrayImpl)value, true, Constant.COMPARATOR);
            }
            catch (ArrayImpl.NullException nullException) {
                return null;
            }
        } else {
            compare = Constant.COMPARATOR.compare(leftValue, value);
        }
        Boolean result = null;
        switch (operator) {
            case 1: {
                result = compare == 0;
                break;
            }
            case 2: {
                result = compare != 0;
                break;
            }
            case 3: {
                result = compare < 0;
                break;
            }
            case 5: {
                result = compare <= 0;
                break;
            }
            case 4: {
                result = compare > 0;
                break;
            }
            case 6: {
                result = compare >= 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return result;
    }

    private boolean evaluate(ExistsCriteria criteria) throws Exception {
        ValueIterator valueIter;
        try {
            valueIter = this.evaluateSubquery(criteria);
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
        if (valueIter.hasNext()) {
            return !criteria.isNegated();
        }
        return criteria.isNegated();
    }

    public Object evaluate(Expression expression) throws Exception {
        try {
            return this.internalEvaluate(expression);
        }
        catch (Exception e) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30328, expression, e.getMessage()));
        }
    }

    protected Object internalEvaluate(Expression expression) throws Exception {
        if (expression instanceof AggregateSymbol || expression instanceof AliasSymbol || expression instanceof ElementSymbol || expression instanceof WindowFunction) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30328, expression, Messages.getString(Messages.Misc.Evaluator_noValue, new Object[0])));
        }
        if (expression instanceof ExpressionSymbol) {
            ExpressionSymbol exprSyb = (ExpressionSymbol)expression;
            Expression expr = exprSyb.getExpression();
            return this.internalEvaluate(expr);
        }
        if (expression instanceof Constant) {
            return ((Constant)expression).getValue();
        }
        if (expression instanceof Function) {
            return this.evaluate((Function)expression);
        }
        if (expression instanceof CaseExpression) {
            return this.evaluate((CaseExpression)expression);
        }
        if (expression instanceof SearchedCaseExpression) {
            return this.evaluate((SearchedCaseExpression)expression);
        }
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            if (ref.isPositional() && ref.getExpression() == null) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30328, expression, Messages.getString(Messages.Misc.Evaluator_noValue, new Object[0])));
            }
            Object result = this.internalEvaluate(ref.getExpression());
            if (ref.getConstraint() != null) {
                try {
                    ref.getConstraint().validate(result);
                }
                catch (Exception e) {
                    throw new TeiidClientException(e);
                }
            }
            return result;
        }
        if (expression instanceof Criteria) {
            return this.evaluate((Criteria)expression);
        }
        if (expression instanceof ScalarSubquery) {
            return this.evaluate((ScalarSubquery)expression);
        }
        if (expression instanceof Criteria) {
            return this.evaluate((Criteria)expression);
        }
        if (expression instanceof TextLine) {
            return this.evaluateTextLine((TextLine)expression);
        }
        if (expression instanceof XMLElement) {
            return this.evaluateXMLElement((XMLElement)expression);
        }
        if (expression instanceof XMLForest) {
            return this.evaluateXMLForest((XMLForest)expression);
        }
        if (expression instanceof JSONObject) {
            return this.evaluateJSONObject((JSONObject)expression, null);
        }
        if (expression instanceof XMLSerialize) {
            return this.evaluateXMLSerialize((XMLSerialize)expression);
        }
        if (expression instanceof XMLQuery) {
            return this.evaluateXMLQuery((XMLQuery)expression, false);
        }
        if (expression instanceof QueryString) {
            return this.evaluateQueryString((QueryString)expression);
        }
        if (expression instanceof XMLParse) {
            return this.evaluateXMLParse((XMLParse)expression);
        }
        if (expression instanceof Array) {
            Array array = (Array)expression;
            List<Expression> exprs = array.getExpressions();
            Object[] result = (Object[])java.lang.reflect.Array.newInstance(array.getComponentType(), exprs.size());
            int i = 0;
            while (i < exprs.size()) {
                Object[] eval = this.internalEvaluate(exprs.get(i));
                if (eval instanceof ArrayImpl) {
                    eval = ((ArrayImpl)eval).getValues();
                }
                result[i] = eval;
                ++i;
            }
            return new ArrayImpl(expression.getTeiidVersion(), result);
        }
        if (expression instanceof ExceptionExpression) {
            return this.evaluate((ExceptionExpression)expression);
        }
        if (expression instanceof XMLCast) {
            return this.evaluate((XMLCast)expression);
        }
        throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30329, expression.getClass().getName()));
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    private Object evaluate(XMLCast expression) throws Exception {
        Object val = this.internalEvaluate(expression.getExpression());
        if (val == null) {
            TeiidNodeFactory factory = new TeiidNodeFactory();
            Constant constant = (Constant)factory.create(expression.getTeiidParser(), TeiidNodeFactory.ASTNodes.CONSTANT);
            constant.setValue(null);
            constant.setType(expression.getType());
            return constant;
        }
        Configuration config = new Configuration();
        XMLType value = (XMLType)val;
        XMLType.Type t = value.getType();
        try {
            StringValue i = null;
            switch (t) {
                case CONTENT: 
                case COMMENT: 
                case PI: {
                    throw new TeiidClientException();
                }
                case TEXT: {
                    i = new StringValue((CharSequence)value.getString());
                    break;
                }
                case UNKNOWN: 
                case DOCUMENT: 
                case ELEMENT: {
                    StreamSource ss = value.getSource(StreamSource.class);
                    try {
                        i = config.buildDocument((Source)ss);
                        break;
                    }
                    finally {
                        if (ss.getInputStream() != null) {
                            ss.getInputStream().close();
                        }
                        if (ss.getReader() != null) {
                            ss.getReader().close();
                        }
                    }
                }
                default: {
                    throw new AssertionError((Object)("Unknown xml value type " + (Object)((Object)t)));
                }
            }
            return XMLTableNode.getValue(expression.getType(), (Item)i, config, this.context);
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
    }

    private Object evaluate(ExceptionExpression ee) throws Exception {
        String msg = (String)this.internalEvaluate(ee.getMessage());
        ee.getDefaultSQLState();
        if (ee.getSqlState() != null) {
            String cfr_ignored_0 = (String)this.internalEvaluate(ee.getSqlState());
        }
        Integer errorCode = null;
        if (ee.getErrorCode() != null) {
            errorCode = (Integer)this.internalEvaluate(ee.getErrorCode());
        }
        Exception parent = null;
        if (ee.getParent() != null) {
            parent = (Exception)this.internalEvaluate(ee.getParent());
        }
        msg = errorCode != null ? errorCode + " : " + msg : msg;
        TeiidClientException result = new TeiidClientException(parent, msg);
        return result;
    }

    private Object evaluateXMLParse(XMLParse xp) throws Exception {
        Object value = this.internalEvaluate(xp.getExpression());
        if (value == null) {
            return null;
        }
        XMLType.Type type = XMLType.Type.DOCUMENT;
        SQLXMLImpl result = null;
        try {
            Object string;
            if (value instanceof String) {
                string = (String)value;
                result = new SQLXMLImpl((String)string);
                result.setCharset(Streamable.CHARSET);
                if (!xp.isWellFormed()) {
                    StringReader r = new StringReader((String)string);
                    type = this.validate(xp, r);
                }
            } else if (value instanceof BinaryType && this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_11)) {
                string = (BinaryType)value;
                result = new SQLXMLImpl(((BinaryType)string).getBytesDirect());
                result.setCharset(Streamable.CHARSET);
                if (!xp.isWellFormed()) {
                    Reader r = result.getCharacterStream();
                    type = this.validate(xp, r);
                }
            } else {
                InputStreamFactory isf = null;
                Streamable s = (Streamable)value;
                isf = Evaluator.getInputStreamFactory(s);
                result = new SQLXMLImpl(isf);
                if (!xp.isWellFormed()) {
                    Reader r = result.getCharacterStream();
                    type = this.validate(xp, r);
                }
            }
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
        if (!xp.isDocument()) {
            type = XMLType.Type.CONTENT;
        }
        XMLType xml = new XMLType(result);
        xml.setType(type);
        return xml;
    }

    public static InputStreamFactory getInputStreamFactory(Streamable<?> s) {
        if (s.getReference() instanceof Streamable) {
            return Evaluator.getInputStreamFactory((Streamable)s.getReference());
        }
        if (s.getReference() instanceof BaseLob) {
            BaseLob bl = (BaseLob)s.getReference();
            try {
                InputStreamFactory isf = bl.getStreamFactory();
                if (isf != null) {
                    return isf;
                }
            }
            catch (SQLException sQLException) {}
        }
        if (s instanceof ClobType) {
            return new InputStreamFactory.ClobInputStreamFactory((Clob)s.getReference());
        }
        if (s instanceof BlobType) {
            return new InputStreamFactory.BlobInputStreamFactory((Blob)s.getReference());
        }
        return new InputStreamFactory.SQLXMLInputStreamFactory((SQLXML)s.getReference());
    }

    private XMLType.Type validate(XMLParse xp, Reader r) throws Exception {
        if (!xp.isDocument()) {
            LinkedList<Reader> readers = new LinkedList<Reader>();
            readers.add(new StringReader("<r>"));
            readers.add(r);
            readers.add(new StringReader("</r>"));
            r = new SequenceReader(readers);
        }
        return StringToSQLXMLTransform.isXml(r);
    }

    private String httpURLEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private Object evaluateQueryString(QueryString queryString) throws Exception {
        NameValuePair<Object>[] pairs = this.getNameValuePairs(queryString.getArgs(), false, true);
        String path = (String)this.internalEvaluate(queryString.getPath());
        if (path == null) {
            path = "";
        }
        boolean appendedAny = false;
        StringBuilder result = new StringBuilder();
        NameValuePair<Object>[] nameValuePairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            NameValuePair<Object> nameValuePair = nameValuePairArray[n2];
            if (nameValuePair.value != null) {
                if (appendedAny) {
                    result.append('&');
                }
                appendedAny = true;
                result.append(this.httpURLEncode(nameValuePair.name)).append('=').append(this.httpURLEncode((String)nameValuePair.value));
            }
            ++n2;
        }
        if (!appendedAny) {
            return path;
        }
        result.insert(0, '?');
        result.insert(0, path);
        return result.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object evaluateXMLQuery(XMLQuery xmlQuery, boolean exists) throws Exception {
        block23: {
            emptyOnEmpty = xmlQuery.getEmptyOnEmpty() == null || xmlQuery.getEmptyOnEmpty() != false;
            result = null;
            try {
                block22: {
                    rp = null;
                    teiidVersion = xmlQuery.getTeiidVersion();
                    if (xmlQuery.getXQueryExpression().isStreaming()) {
                        rp = teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_10) != false ? new XMLQueryRowProcessor() : new XMLQueryRowProcessor(exists);
                    }
                    try {
                        result = this.evaluateXQuery(xmlQuery.getXQueryExpression(), xmlQuery.getPassing(), rp);
                        if (!teiidVersion.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_10)) break block22;
                        if (result == null) {
                            return null;
                        }
                        if (!exists) break block22;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof XPathException == false) throw e;
                        throw (XPathException)e.getCause();
                    }
                    if (result.iter.next() == null) {
                        var10_8 = false;
                        return var10_8;
                    }
                    var10_9 = true;
                    return var10_9;
                }
                if (rp != null) {
                    if (!exists) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            type = rp.type;
                            if (type == null) {
                                if (!emptyOnEmpty) {
                                    return null;
                                }
                                type = XMLType.Type.CONTENT;
                            }
                            val = rp.concat.close(this.context);
                            val.setType(rp.type);
                            var10_11 = val;
                            return var10_11;
                        }
                    }
                    break block23;
                }
                var10_12 = xmlQuery.getXQueryExpression().createXMLType(result.iter, emptyOnEmpty, this.context);
                return var10_12;
            }
            catch (Exception e) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30333, new Object[]{e.getMessage()}));
            }
        }
        ** while (!teiidVersion.isGreaterThanOrEqualTo((TeiidServerVersion.Version)TeiidServerVersion.Version.TEIID_8_10))
lbl43:
        // 1 sources

        return rp.hasItem;
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    private Object evaluateXMLSerialize(XMLSerialize xs) throws Exception {
        XMLType value = (XMLType)this.internalEvaluate(xs.getExpression());
        if (value == null) {
            return null;
        }
        try {
            if (!xs.getDocument().booleanValue()) {
                return XMLSystemFunctions.serialize(xs, value);
            }
            if (value.getType() == XMLType.Type.UNKNOWN) {
                XMLType.Type type = StringToSQLXMLTransform.isXml(value.getCharacterStream());
                value.setType(type);
            }
            if (value.getType() == XMLType.Type.DOCUMENT || value.getType() == XMLType.Type.ELEMENT) {
                return XMLSystemFunctions.serialize(xs, value);
            }
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
        throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30336, new Object[0]));
    }

    private <T> String[] evaluate(List<T> values, ValueExtractor<T> valueExtractor, TextLine textLine) throws Exception {
        Character delimeter = textLine.getDelimiter();
        if (delimeter == null) {
            delimeter = Character.valueOf(',');
        }
        String delim = String.valueOf(delimeter.charValue());
        Character quote = textLine.getQuote();
        String quoteStr = null;
        quoteStr = quote == null ? "\"" : String.valueOf(quote);
        String doubleQuote = String.valueOf(quoteStr) + quoteStr;
        ArrayList<String> result = new ArrayList<String>();
        DataTypeManagerService dataTypeManager = DataTypeManagerService.getInstance(textLine.getTeiidVersion());
        Iterator<T> iterator = values.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            String text = (String)dataTypeManager.transformValue(valueExtractor.getValue(t), DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass());
            if (text == null) continue;
            result.add(quoteStr);
            result.add(StringUtil.replaceAll(text, quoteStr, doubleQuote));
            result.add(quoteStr);
            if (!iterator.hasNext()) continue;
            result.add(delim);
        }
        result.add(textLine.getLineEnding());
        return result.toArray(new String[result.size()]);
    }

    private Object evaluateTextLine(TextLine function) throws Exception {
        List<DerivedColumn> args = function.getExpressions();
        NameValuePair<Object>[] nameValuePairs = this.getNameValuePairs(args, true, true);
        try {
            return new ArrayImpl(function.getTeiidVersion(), this.evaluate(Arrays.asList(nameValuePairs), defaultExtractor, function));
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
    }

    private Object evaluateXMLForest(XMLForest function) throws Exception {
        List<DerivedColumn> args = function.getArgs();
        NameValuePair[] nameValuePairs = this.getNameValuePairs(args, true, true);
        try {
            return XMLSystemFunctions.xmlForest(this.context, this.namespaces(function.getNamespaces()), nameValuePairs);
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
    }

    private Object evaluateJSONObject(JSONObject function, JSONFunctionMethods.JSONBuilder builder) throws Exception {
        List<DerivedColumn> args = function.getArgs();
        NameValuePair<Object>[] nameValuePairs = this.getNameValuePairs(args, false, false);
        boolean returnValue = false;
        try {
            if (builder == null) {
                returnValue = true;
                for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(function)) {
                    this.evaluateSubquery(container);
                }
                builder = new JSONFunctionMethods.JSONBuilder(function.getTeiidVersion());
            }
            builder.start(false);
            NameValuePair<Object>[] nameValuePairArray = nameValuePairs;
            int n = nameValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                NameValuePair<Object> nameValuePair = nameValuePairArray[n2];
                this.addValue(builder, nameValuePair.name, nameValuePair.value);
                ++n2;
            }
            builder.end(false);
            if (returnValue) {
                ClobType result = builder.close(this.context);
                builder = null;
                ClobType clobType = result;
                return clobType;
            }
            return null;
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
        finally {
            if (returnValue && builder != null) {
                builder.remove();
            }
        }
    }

    private void addValue(JSONFunctionMethods.JSONBuilder builder, String name, Object value) throws Exception {
        Function f;
        if (value instanceof JSONObject) {
            builder.startValue(name);
            this.evaluateJSONObject((JSONObject)value, builder);
            return;
        }
        if (value instanceof Function && IFunctionLibrary.FunctionName.JSONARRAY.equalsIgnoreCase((f = (Function)value).getName())) {
            builder.startValue(name);
            Evaluator.jsonArray(this.context, f, f.getArgs(), builder, this);
            return;
        }
        builder.addValue(name, this.internalEvaluate((Expression)value));
    }

    public static ClobType jsonArray(CommandContext context, Function f, Object[] vals, JSONFunctionMethods.JSONBuilder builder, Evaluator eval) throws Exception {
        boolean returnValue = false;
        try {
            if (builder == null) {
                returnValue = true;
                if (eval != null) {
                    for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(f)) {
                        eval.evaluateSubquery(container);
                    }
                }
                builder = new JSONFunctionMethods.JSONBuilder(f.getTeiidVersion());
            }
            builder.start(true);
            Object[] objectArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (eval != null) {
                    eval.addValue(builder, null, object);
                } else {
                    builder.addValue(object);
                }
                ++n2;
            }
            builder.end(true);
            if (returnValue) {
                ClobType result = builder.close(context);
                builder = null;
                ClobType clobType = result;
                return clobType;
            }
            return null;
        }
        finally {
            if (returnValue && builder != null) {
                builder.remove();
            }
        }
    }

    private Object evaluateXMLElement(XMLElement function) throws Exception {
        List<Expression> content = function.getContent();
        ArrayList<Object> values = new ArrayList<Object>(content.size());
        for (Expression exp : content) {
            values.add(this.internalEvaluate(exp));
        }
        try {
            NameValuePair<Object>[] attributes = null;
            if (function.getAttributes() != null) {
                attributes = this.getNameValuePairs(function.getAttributes().getArgs(), true, true);
            }
            return XMLSystemFunctions.xmlElement(function.getName(), this.namespaces(function.getNamespaces()), attributes, values, this.context);
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
    }

    private SaxonXQueryExpression.Result evaluateXQuery(SaxonXQueryExpression xquery, List<DerivedColumn> cols, SaxonXQueryExpression.RowProcessor processor) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Object contextItem = null;
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_10)) {
            contextItem = this.evaluateParameters(cols, parameters);
        } else {
            this.evaluateParameters(cols, parameters);
            if (parameters.containsKey(null) && (contextItem = parameters.remove(null)) == null) {
                return null;
            }
        }
        return XQueryEvaluator.evaluateXQuery(xquery, contextItem, parameters, processor);
    }

    public Object evaluateParameters(List<DerivedColumn> cols, Map<String, Object> parameters) throws Exception {
        Object contextItem = null;
        for (DerivedColumn passing : cols) {
            Object value = this.evaluateParameter(passing);
            if (passing.getAlias() == null) {
                if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_10)) {
                    contextItem = value;
                    continue;
                }
                parameters.put(null, value);
                continue;
            }
            parameters.put(passing.getAlias(), value);
        }
        return contextItem;
    }

    private Object evaluateParameter(DerivedColumn passing) throws Exception {
        if (passing.getExpression() instanceof Function) {
            Function f = (Function)passing.getExpression();
            if (f.getName().equalsIgnoreCase("jsontoxml")) {
                String rootName = (String)this.evaluate(f.getArg(0));
                Object lob = this.evaluate(f.getArg(1));
                if (rootName == null || lob == null) {
                    return null;
                }
                try {
                    if (lob instanceof Blob) {
                        return XMLSystemFunctions.jsonToXml(this.context, rootName, (Blob)lob, true);
                    }
                    return XMLSystemFunctions.jsonToXml(this.context, rootName, (Clob)lob, true);
                }
                catch (Exception e) {
                    throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30384, f.getFunctionDescriptor().getName()));
                }
            }
        } else if (passing.getExpression() instanceof XMLParse) {
            XMLParse xmlParse = (XMLParse)passing.getExpression();
            xmlParse.setWellFormed(true);
        }
        Object value = this.evaluate(passing.getExpression());
        return value;
    }

    private NameValuePair<Object>[] getNameValuePairs(List<DerivedColumn> args, boolean xmlNames, boolean eval) throws Exception {
        NameValuePair[] nameValuePairs = new NameValuePair[args.size()];
        int i = 0;
        while (i < args.size()) {
            DerivedColumn symbol = args.get(i);
            String name = symbol.getAlias();
            Expression ex = symbol.getExpression();
            if (name == null && ex instanceof ElementSymbol) {
                name = ((ElementSymbol)ex).getShortName();
            }
            if (name != null) {
                if (xmlNames) {
                    name = XMLSystemFunctions.escapeName(name, true);
                }
            } else if (!xmlNames) {
                name = "expr" + (i + 1);
            }
            nameValuePairs[i] = new NameValuePair<Expression>(name, (Expression)(eval ? this.internalEvaluate(ex) : ex));
            ++i;
        }
        return nameValuePairs;
    }

    private NameValuePair<String>[] namespaces(XMLNamespaces namespaces) {
        if (namespaces == null) {
            return null;
        }
        List<NamespaceItem> args = namespaces.getNamespaceItems();
        NameValuePair[] nameValuePairs = new NameValuePair[args.size()];
        int i = 0;
        while (i < args.size()) {
            NamespaceItem item = args.get(i);
            nameValuePairs[i] = new NameValuePair<String>(item.getPrefix(), item.getUri());
            ++i;
        }
        return nameValuePairs;
    }

    private Object evaluate(CaseExpression expr) throws Exception {
        Object exprVal = this.internalEvaluate(expr.getExpression());
        int i = 0;
        while (i < expr.getWhenCount()) {
            Object intEvObj = this.internalEvaluate(expr.getWhenExpression(i));
            if (intEvObj != null && exprVal != null && intEvObj.equals(exprVal)) {
                return this.internalEvaluate(expr.getThenExpression(i));
            }
            ++i;
        }
        if (expr.getElseExpression() != null) {
            return this.internalEvaluate(expr.getElseExpression());
        }
        return null;
    }

    private Object evaluate(SearchedCaseExpression expr) throws Exception {
        int i = 0;
        while (i < expr.getWhenCount()) {
            if (this.evaluate(expr.getWhenCriteria(i))) {
                return this.internalEvaluate(expr.getThenExpression(i));
            }
            ++i;
        }
        if (expr.getElseExpression() != null) {
            return this.internalEvaluate(expr.getElseExpression());
        }
        return null;
    }

    private Object evaluate(Function function) throws Exception {
        FunctionDescriptor fd = function.getFunctionDescriptor();
        Expression[] args = function.getArgs();
        Object[] values = null;
        int start = 0;
        if (fd.requiresContext()) {
            values = new Object[args.length + 1];
            values[0] = this.context;
            start = 1;
        } else {
            values = new Object[args.length];
        }
        int i = 0;
        while (i < args.length) {
            values[i + start] = this.internalEvaluate(args[i]);
            ++i;
        }
        if (fd.getPushdown() == FunctionMethod.PushDown.MUST_PUSHDOWN) {
            try {
                return this.evaluatePushdown(function, values);
            }
            catch (Exception e) {
                throw new TeiidClientException(e);
            }
        }
        if (fd.getProcedure() != null && this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_11)) {
            try {
                return this.evaluateProcedure(function, values);
            }
            catch (Exception e) {
                throw new TeiidClientException(e);
            }
        }
        if (IFunctionLibrary.FunctionName.LOOKUP.equalsIgnoreCase(function.getName())) {
            String codeTableName = (String)values[0];
            String returnElementName = (String)values[1];
            String keyElementName = (String)values[2];
            if (codeTableName != null && returnElementName != null && keyElementName != null) {
                return String.valueOf(codeTableName) + "." + returnElementName + "." + keyElementName;
            }
            throw new TeiidClientException();
        }
        return fd.invokeFunction(values, this.context, null);
    }

    protected Object evaluatePushdown(Function function, Object[] values) throws Exception {
        throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30341, function.getFunctionDescriptor().getFullName()));
    }

    private Object evaluate(ScalarSubquery scalarSubquery) throws Exception {
        ValueIterator valueIter;
        Object result = null;
        try {
            valueIter = this.evaluateSubquery(scalarSubquery);
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
        if (valueIter.hasNext()) {
            result = valueIter.next();
            if (valueIter.hasNext()) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30345, scalarSubquery.getCommand()));
            }
        }
        return result;
    }

    protected ValueIterator evaluateSubquery(SubqueryContainer<?> container) throws Exception {
        throw new UnsupportedOperationException("Subquery evaluation not possible with a base Evaluator");
    }

    protected Object evaluateProcedure(Function function, Object[] values) throws Exception {
        throw new UnsupportedOperationException("Procedure evaluation not possible with a base Evaluator");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$teiid$query$sql$lang$SubqueryCompareCriteria$PredicateQuantifier() {
        if ($SWITCH_TABLE$org$teiid$query$sql$lang$SubqueryCompareCriteria$PredicateQuantifier != null) {
            return $SWITCH_TABLE$org$teiid$query$sql$lang$SubqueryCompareCriteria$PredicateQuantifier;
        }
        int[] nArray = new int[SubqueryCompareCriteria.PredicateQuantifier.values().length];
        try {
            nArray[SubqueryCompareCriteria.PredicateQuantifier.ALL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SubqueryCompareCriteria.PredicateQuantifier.ANY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SubqueryCompareCriteria.PredicateQuantifier.SOME.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$teiid$query$sql$lang$SubqueryCompareCriteria$PredicateQuantifier = nArray;
        return nArray;
    }

    public static class NameValuePair<T> {
        public String name;
        public T value;

        public NameValuePair(String name, T value) {
            this.name = name;
            this.value = value;
        }
    }

    private final class SequenceReader
    extends Reader {
        private LinkedList<Reader> readers;
        private Reader current = null;

        public SequenceReader(LinkedList<Reader> readers) {
            this.readers = readers;
        }

        @Override
        public void close() {
            for (Reader reader : this.readers) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int nextRead;
            if (this.current == null && !this.readers.isEmpty()) {
                this.current = this.readers.removeFirst();
            }
            if (this.current == null) {
                return -1;
            }
            int read = this.current.read(cbuf, off, len);
            if (read == -1) {
                this.current.close();
                this.current = null;
                read = 0;
            }
            if (read < len && (nextRead = this.read(cbuf, off + read, len - read)) > 0) {
                read += nextRead;
            }
            return read;
        }
    }

    public static interface ValueExtractor<T> {
        public Object getValue(T var1);
    }

    private final class XMLQueryRowProcessor
    implements SaxonXQueryExpression.RowProcessor {
        XMLSystemFunctions.XmlConcat concat;
        XMLType.Type type;
        private Result result;
        @Since(value=TeiidServerVersion.Version.TEIID_8_10)
        boolean hasItem;

        private XMLQueryRowProcessor() throws Exception {
            this(false);
        }

        private XMLQueryRowProcessor(boolean exists) throws Exception {
            if (!exists) {
                this.concat = new XMLSystemFunctions.XmlConcat();
                this.result = new StreamResult(this.concat.getWriter());
            }
        }

        @Override
        public void processRow(NodeInfo row) {
            if (this.concat == null) {
                this.hasItem = true;
                return;
            }
            this.type = this.type == null ? SaxonXQueryExpression.getType(row) : XMLType.Type.CONTENT;
            try {
                QueryResult.serialize((NodeInfo)row, (Result)this.result, (Properties)SaxonXQueryExpression.DEFAULT_OUTPUT_PROPERTIES);
            }
            catch (XPathException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

