/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.teiid.core.util.LRUCache;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.query.function.FunctionMethods;
import org.teiid.runtime.client.Messages;

public final class TeiidScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private static Reference<Map<Class<?>, Map<String, Method>>> properties;
    private static Pattern splitter;

    static {
        splitter = Pattern.compile("\\.");
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        final String[] parts = splitter.split(script);
        final int[] indexes = new int[parts.length];
        int i = 1;
        while (i < parts.length) {
            String string = parts[i];
            int j = 0;
            while (j < string.length()) {
                if (!Character.isJavaIdentifierPart(string.charAt(j))) {
                    throw new ScriptException(Messages.gs(Messages.TEIID.TEIID30431, string, Character.valueOf(string.charAt(j))));
                }
                ++j;
            }
            try {
                indexes[i] = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                indexes[i] = -1;
            }
            ++i;
        }
        return new CompiledScript(){

            @Override
            public ScriptEngine getEngine() {
                return TeiidScriptEngine.this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object eval(ScriptContext sc) throws ScriptException {
                if (sc == null) {
                    throw new NullPointerException();
                }
                Object obj = null;
                if (parts.length > 0) {
                    obj = sc.getAttribute(parts[0]);
                }
                int i = 1;
                while (i < parts.length) {
                    if (obj == null) {
                        return null;
                    }
                    String part = parts[i];
                    Map<String, Method> methodMap = TeiidScriptEngine.this.getMethodMap(obj.getClass());
                    Method m = methodMap.get(part);
                    if (m == null) {
                        int index = indexes[i];
                        if (index <= 0) throw new ScriptException(Messages.gs(Messages.TEIID.TEIID31111, part, obj.getClass()));
                        if (obj instanceof List) {
                            try {
                                obj = ((List)obj).get(index - 1);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                obj = null;
                            }
                        } else {
                            try {
                                obj = FunctionMethods.array_get(obj, index);
                            }
                            catch (Exception e) {
                                throw new ScriptException(e);
                            }
                        }
                    } else {
                        try {
                            obj = m.invoke(obj, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new ScriptException(e);
                        }
                        catch (InvocationTargetException e) {
                            if (!(e.getCause() instanceof Exception)) throw new ScriptException(e);
                            throw new ScriptException((Exception)e.getCause());
                        }
                    }
                    ++i;
                }
                return obj;
            }
        };
    }

    public Map<String, Method> getMethodMap(Class<?> clazz) throws ScriptException {
        Map<Class<Object>, Map<String, Method>> clazzMaps = null;
        Map<String, Method> methodMap = null;
        if (properties != null && (clazzMaps = properties.get()) != null && (methodMap = clazzMaps.get(clazz)) != null) {
            return methodMap;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            methodMap = new LinkedHashMap<String, Method>();
            if (pds != null) {
                int j = 0;
                while (j < pds.length) {
                    PropertyDescriptor pd = pds[j];
                    if (pd.getReadMethod() != null && !(pd instanceof IndexedPropertyDescriptor)) {
                        String name = pd.getName();
                        Method m = pd.getReadMethod();
                        methodMap.put(name, m);
                    }
                    ++j;
                }
            }
            MethodDescriptor[] mds = info.getMethodDescriptors();
            if (pds != null) {
                int j = 0;
                while (j < mds.length) {
                    MethodDescriptor md = mds[j];
                    if (md.getMethod() != null && md.getMethod().getParameterTypes().length <= 0 && md.getMethod().getReturnType() != Void.class && md.getMethod().getReturnType() != Void.TYPE) {
                        String name = md.getName();
                        Method m = md.getMethod();
                        methodMap.put(name, m);
                    }
                    ++j;
                }
            }
            if (clazzMaps == null) {
                clazzMaps = Collections.synchronizedMap(new LRUCache(100));
                properties = new SoftReference(clazzMaps);
            }
            clazzMaps.put(clazz, methodMap);
        }
        catch (IntrospectionException e) {
            throw new ScriptException(e);
        }
        return methodMap;
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            return this.compile(ObjectConverterUtil.convertToString(script));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eval(Reader reader, ScriptContext sc) throws ScriptException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eval(String script, ScriptContext sc) throws ScriptException {
        throw new UnsupportedOperationException();
    }
}

