/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.sql.Blob;
import org.teiid.CommandContext;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.annotation.Updated;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.GeometryTransformUtils;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.function.TeiidFunction;

@Since(value=TeiidServerVersion.Version.TEIID_8_10)
public class GeometryFunctionMethods {
    @TeiidFunction(name="st_astext", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    @Updated(version={TeiidServerVersion.Version.TEIID_8_11})
    public static ClobType asText(GeometryType geometry) throws Exception {
        return GeometryUtils.geometryToClob(geometry, false);
    }

    @TeiidFunction(name="st_asewkt", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    @Updated(version={TeiidServerVersion.Version.TEIID_8_11})
    public static ClobType asEwkt(GeometryType geometry) throws Exception {
        return GeometryUtils.geometryToClob(geometry, true);
    }

    @TeiidFunction(name="st_asbinary", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static BlobType asBlob(GeometryType geometry) {
        Blob b = (Blob)geometry.getReference();
        return new BlobType(b);
    }

    @TeiidFunction(name="st_asgeojson", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static ClobType asGeoJson(GeometryType geometry) throws Exception {
        return GeometryUtils.geometryToGeoJson(geometry);
    }

    @TeiidFunction(name="st_asgml", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static ClobType asGml(org.teiid.query.util.CommandContext context, GeometryType geometry) throws Exception {
        return GeometryUtils.geometryToGml(context, geometry, true);
    }

    @TeiidFunction(name="st_askml", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static ClobType asKml(org.teiid.query.util.CommandContext context, GeometryType geometry) throws Exception {
        return GeometryUtils.geometryToGml(context, geometry, false);
    }

    @TeiidFunction(name="st_geomfromtext", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromText(ClobType wkt) throws Exception {
        return GeometryUtils.geometryFromClob(wkt);
    }

    @TeiidFunction(name="st_geomfromtext", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType geomFromText(ClobType wkt, int srid) throws Exception {
        return GeometryUtils.geometryFromClob(wkt, srid, false);
    }

    @TeiidFunction(name="st_geomfromwkb", category="Geometry", nullOnNull=true, alias="ST_GEOMFROMBINARY")
    public static GeometryType geoFromBlob(BlobType wkb) throws Exception {
        return GeometryUtils.geometryFromBlob(wkb);
    }

    @TeiidFunction(name="st_geomfromwkb", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true, alias="ST_GEOMFROMBINARY")
    public static GeometryType geoFromBlob(BlobType wkb, int srid) throws Exception {
        return GeometryUtils.geometryFromBlob(wkb, srid);
    }

    @TeiidFunction(name="st_geomfromgeojson", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromGeoJson(ClobType clob) throws Exception {
        return GeometryUtils.geometryFromGeoJson(clob);
    }

    @TeiidFunction(name="st_geomfromgeojson", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static GeometryType geomFromGeoJson(ClobType clob, int srid) throws Exception {
        return GeometryUtils.geometryFromGeoJson(clob, srid);
    }

    @TeiidFunction(name="st_geomfromgml", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromGml(ClobType gml) throws Exception {
        return GeometryUtils.geometryFromGml(gml, null);
    }

    @TeiidFunction(name="st_geomfromgml", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static GeometryType geomFromGml(ClobType gml, int srid) throws Exception {
        return GeometryUtils.geometryFromGml(gml, (Integer)srid);
    }

    @TeiidFunction(name="st_intersects", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean intersects(GeometryType geom1, GeometryType geom2) throws Exception {
        return GeometryUtils.intersects(geom1, geom2);
    }

    @TeiidFunction(name="st_contains", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean contains(GeometryType geom1, GeometryType geom2) throws Exception {
        return GeometryUtils.contains(geom1, geom2);
    }

    @TeiidFunction(name="st_crosses", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean crosses(GeometryType geom1, GeometryType geom2) throws Exception {
        return GeometryUtils.crosses(geom1, geom2);
    }

    @TeiidFunction(name="st_disjoint", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean disjoint(GeometryType geom1, GeometryType geom2) throws Exception {
        return GeometryUtils.disjoint(geom1, geom2);
    }

    @TeiidFunction(name="st_distance", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Double distance(GeometryType geom1, GeometryType geom2) throws Exception {
        return GeometryUtils.distance(geom1, geom2);
    }

    @TeiidFunction(name="st_overlaps", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean overlaps(GeometryType geom1, GeometryType geom2) throws Exception {
        return GeometryUtils.overlaps(geom1, geom2);
    }

    @TeiidFunction(name="st_touches", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean touches(GeometryType geom1, GeometryType geom2) throws Exception {
        return GeometryUtils.touches(geom1, geom2);
    }

    @TeiidFunction(name="st_srid", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static int getSrid(GeometryType geom1) {
        return geom1.getSrid();
    }

    @TeiidFunction(name="st_setsrid", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType setSrid(GeometryType geom1, int srid) {
        GeometryType gt = new GeometryType();
        gt.setReference((Blob)geom1.getReference());
        gt.setSrid(srid);
        return gt;
    }

    @TeiidFunction(name="st_equals", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean equals(GeometryType geom1, GeometryType geom2) throws Exception {
        return GeometryUtils.equals(geom1, geom2);
    }

    @TeiidFunction(name="st_transform", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    @Since(value=TeiidServerVersion.Version.TEIID_8_11)
    public static GeometryType transform(org.teiid.query.util.CommandContext context, GeometryType geom, int srid) throws Exception {
        return GeometryTransformUtils.transform((CommandContext)context, geom, srid);
    }
}

