/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.CoordinateTransformFactory;
import org.osgeo.proj4j.ProjCoordinate;
import org.teiid.CommandContext;
import org.teiid.core.types.GeometryType;
import org.teiid.query.function.GeometryUtils;
import org.teiid.runtime.client.Messages;

public class GeometryTransformUtils {
    public static GeometryType transform(CommandContext ctx, GeometryType geom, int srid) throws Exception {
        Geometry jtsGeomSrc = GeometryUtils.getGeometry(geom);
        Geometry jtsGeomTgt = GeometryTransformUtils.transform(ctx, jtsGeomSrc, srid);
        return GeometryUtils.getGeometryType(jtsGeomTgt, srid);
    }

    static Geometry transform(CommandContext ctx, Geometry jtsGeomSrc, int srid) throws Exception {
        String srcParam = GeometryTransformUtils.lookupProj4Text(ctx, jtsGeomSrc.getSRID());
        String tgtParam = GeometryTransformUtils.lookupProj4Text(ctx, srid);
        Geometry jtsGeomTgt = GeometryTransformUtils.transform(jtsGeomSrc, srcParam, tgtParam);
        return jtsGeomTgt;
    }

    public static String lookupProj4Text(CommandContext ctx, int srid) throws Exception {
        throw new UnsupportedOperationException("Geometry lookup facilities disabled at this time");
    }

    public static Geometry transform(Geometry geom, String srcParams, String tgtParams) throws Exception {
        CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
        CRSFactory crsFactory = new CRSFactory();
        CoordinateReferenceSystem srcCrs = crsFactory.createFromParameters(null, srcParams);
        CoordinateReferenceSystem tgtCrs = crsFactory.createFromParameters(null, tgtParams);
        CoordinateTransform coordTransform = ctFactory.createTransform(srcCrs, tgtCrs);
        return GeometryTransformUtils.transformGeometry(coordTransform, geom);
    }

    protected static Geometry transformGeometry(CoordinateTransform ct, Geometry geom) throws Exception {
        if (geom instanceof Polygon) {
            return GeometryTransformUtils.transformPolygon(ct, (Polygon)geom);
        }
        if (geom instanceof Point) {
            return GeometryTransformUtils.transformPoint(ct, (Point)geom);
        }
        if (geom instanceof LinearRing) {
            return GeometryTransformUtils.transformLinearRing(ct, (LinearRing)geom);
        }
        if (geom instanceof LineString) {
            return GeometryTransformUtils.transformLineString(ct, (LineString)geom);
        }
        if (geom instanceof MultiPolygon) {
            return GeometryTransformUtils.transformMultiPolygon(ct, (MultiPolygon)geom);
        }
        if (geom instanceof MultiPoint) {
            return GeometryTransformUtils.transformMultiPoint(ct, (MultiPoint)geom);
        }
        if (geom instanceof MultiLineString) {
            return GeometryTransformUtils.transformMultiLineString(ct, (MultiLineString)geom);
        }
        if (geom instanceof GeometryCollection) {
            return GeometryTransformUtils.transformGeometryCollection(ct, (GeometryCollection)geom);
        }
        throw new Exception(Messages.gs(Messages.TEIID.TEIID31164, geom.getGeometryType()));
    }

    protected static Coordinate[] convert(ProjCoordinate[] projCoords) {
        Coordinate[] jtsCoords = new Coordinate[projCoords.length];
        int i = 0;
        while (i < projCoords.length) {
            jtsCoords[i] = new Coordinate(projCoords[i].x, projCoords[i].y);
            ++i;
        }
        return jtsCoords;
    }

    protected static ProjCoordinate[] convert(Coordinate[] jtsCoords) {
        ProjCoordinate[] projCoords = new ProjCoordinate[jtsCoords.length];
        int i = 0;
        while (i < jtsCoords.length) {
            projCoords[i] = new ProjCoordinate(jtsCoords[i].x, jtsCoords[i].y);
            ++i;
        }
        return projCoords;
    }

    protected static Coordinate[] transformCoordinates(CoordinateTransform ct, Coordinate[] in) {
        return GeometryTransformUtils.convert(GeometryTransformUtils.transformCoordinates(ct, GeometryTransformUtils.convert(in)));
    }

    protected static ProjCoordinate[] transformCoordinates(CoordinateTransform ct, ProjCoordinate[] in) {
        ProjCoordinate[] out = new ProjCoordinate[in.length];
        int i = 0;
        while (i < in.length) {
            out[i] = ct.transform(in[i], new ProjCoordinate());
            ++i;
        }
        return out;
    }

    protected static Polygon transformPolygon(CoordinateTransform ct, Polygon polygon) {
        return polygon.getFactory().createPolygon(GeometryTransformUtils.transformCoordinates(ct, polygon.getCoordinates()));
    }

    protected static Geometry transformPoint(CoordinateTransform ct, Point point) {
        return point.getFactory().createPoint(GeometryTransformUtils.transformCoordinates(ct, point.getCoordinates())[0]);
    }

    protected static Geometry transformLinearRing(CoordinateTransform ct, LinearRing linearRing) {
        return linearRing.getFactory().createLinearRing(GeometryTransformUtils.transformCoordinates(ct, linearRing.getCoordinates()));
    }

    protected static Geometry transformLineString(CoordinateTransform ct, LineString lineString) {
        return lineString.getFactory().createLineString(GeometryTransformUtils.transformCoordinates(ct, lineString.getCoordinates()));
    }

    protected static Geometry transformMultiPolygon(CoordinateTransform ct, MultiPolygon multiPolygon) {
        Polygon[] polygon = new Polygon[multiPolygon.getNumGeometries()];
        int i = 0;
        while (i < polygon.length) {
            polygon[i] = multiPolygon.getFactory().createPolygon(GeometryTransformUtils.transformCoordinates(ct, multiPolygon.getGeometryN(i).getCoordinates()));
            ++i;
        }
        return multiPolygon.getFactory().createMultiPolygon(polygon);
    }

    protected static Geometry transformMultiPoint(CoordinateTransform ct, MultiPoint multiPoint) {
        return multiPoint.getFactory().createMultiPoint(GeometryTransformUtils.transformCoordinates(ct, multiPoint.getCoordinates()));
    }

    protected static Geometry transformMultiLineString(CoordinateTransform ct, MultiLineString multiLineString) {
        LineString[] lineString = new LineString[multiLineString.getNumGeometries()];
        int i = 0;
        while (i < lineString.length) {
            lineString[i] = multiLineString.getFactory().createLineString(GeometryTransformUtils.transformCoordinates(ct, multiLineString.getGeometryN(i).getCoordinates()));
            ++i;
        }
        return multiLineString.getFactory().createMultiLineString(lineString);
    }

    protected static Geometry transformGeometryCollection(CoordinateTransform ct, GeometryCollection geometryCollection) throws Exception {
        Geometry[] geometry = new Geometry[geometryCollection.getNumGeometries()];
        int i = 0;
        while (i < geometry.length) {
            geometry[i] = GeometryTransformUtils.transformGeometry(ct, geometryCollection.getGeometryN(i));
            ++i;
        }
        return geometryCollection.getFactory().createGeometryCollection(geometry);
    }
}

