/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Stack;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.json.simple.ContentHandler;
import org.teiid.json.simple.JSONParser;
import org.teiid.json.simple.ParseException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.util.CommandContext;
import org.teiid.runtime.client.TeiidClientException;

@Since(value=TeiidServerVersion.Version.TEIID_8_0)
public class JSONFunctionMethods {
    private static final ContentHandler validatingContentHandler = new ContentHandler(){

        @Override
        public boolean startObjectEntry(String key) throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean startObject() throws ParseException, IOException {
            return true;
        }

        @Override
        public void startJSON() throws ParseException, IOException {
        }

        @Override
        public boolean startArray() throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean primitive(Object value) throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean endObjectEntry() throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean endObject() throws ParseException, IOException {
            return true;
        }

        @Override
        public void endJSON() throws ParseException, IOException {
        }

        @Override
        public boolean endArray() throws ParseException, IOException {
            return true;
        }
    };

    @TeiidFunction(category="JSON")
    public static ClobType jsonParse(ClobType val, boolean wellformed) throws SQLException, IOException, ParseException {
        Reader r = null;
        if (val.getType() == ClobType.Type.JSON) {
            return val;
        }
        if (!wellformed) {
            r = val.getCharacterStream();
        }
        try {
            if (!wellformed) {
                JSONParser parser = new JSONParser();
                parser.parse(r, validatingContentHandler);
            }
            ClobType ct = new ClobType((Clob)val.getReference());
            ct.setType(ClobType.Type.JSON);
            ClobType clobType = ct;
            return clobType;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    @TeiidFunction(category="JSON")
    public static ClobType jsonParse(BlobType val, boolean wellformed) throws SQLException, IOException, ParseException {
        try (InputStreamReader r = XMLSystemFunctions.getJsonReader(val);){
            if (!wellformed) {
                JSONParser parser = new JSONParser();
                parser.parse(r, validatingContentHandler);
            }
            ClobImpl clobImpl = new ClobImpl();
            clobImpl.setStreamFactory(new InputStreamFactory.BlobInputStreamFactory((Blob)val.getReference()));
            clobImpl.setEncoding(r.getEncoding());
            ClobType ct = new ClobType(clobImpl);
            ct.setType(ClobType.Type.JSON);
            ClobType clobType = ct;
            return clobType;
        }
    }

    @TeiidFunction(category="JSON")
    public static ClobType jsonArray(CommandContext context, Object ... vals) throws Exception {
        if (vals == null) {
            return null;
        }
        return Evaluator.jsonArray(context, null, vals, null, null);
    }

    public static class JSONBuilder {
        private final ITeiidServerVersion teiidVersion;
        private Writer writer;
        private FileStoreInputStreamFactory fsisf;
        private FileStore fs;
        private Stack<Integer> position = new Stack();

        public JSONBuilder(ITeiidServerVersion teiidVersion) {
            this.teiidVersion = teiidVersion;
            MemoryStorageManager manager = new MemoryStorageManager();
            String fileStoreName = "json";
            if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_11)) {
                fileStoreName = "xml";
            }
            this.fs = manager.createFileStore(fileStoreName);
            this.fsisf = new FileStoreInputStreamFactory(this.fs, "UTF-8");
            this.writer = this.fsisf.getWriter();
        }

        public void start(boolean array) throws TeiidClientException {
            this.position.push(0);
            try {
                if (array) {
                    this.writer.append('[');
                } else {
                    this.writer.append('{');
                }
            }
            catch (IOException e) {
                this.remove();
                throw new TeiidClientException(e);
            }
        }

        public void addValue(Object object) throws TeiidClientException {
            this.addValue(null, object);
        }

        public void addValue(String key, Object object) throws TeiidClientException {
            block12: {
                try {
                    this.startValue(key);
                    if (object == null) {
                        this.writer.append("null");
                        break block12;
                    }
                    if (object instanceof ClobType) {
                        ClobType clob = (ClobType)object;
                        if (clob.getType() == ClobType.Type.JSON) {
                            try (Reader r = clob.getCharacterStream();){
                                ObjectConverterUtil.write(this.writer, r, -1, false);
                                break block12;
                            }
                        }
                        this.writer.append('\"');
                        JSONParser.escape(clob.getCharSequence(), this.writer);
                        this.writer.append('\"');
                        break block12;
                    }
                    if (object instanceof Boolean) {
                        this.writer.append(object.toString());
                    } else if (object instanceof Number) {
                        this.writer.write(object.toString());
                    } else {
                        this.writer.append('\"');
                        String text = (String)DataTypeManagerService.getInstance(this.teiidVersion).transformValue(object, DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass());
                        JSONParser.escape(text, this.writer);
                        this.writer.append('\"');
                    }
                }
                catch (Exception e) {
                    this.remove();
                    throw new TeiidClientException(e);
                }
            }
        }

        public void startValue(String key) throws TeiidClientException {
            try {
                if (this.position.peek() != 0) {
                    this.writer.append(',');
                }
                this.position.add(this.position.pop() + 1);
                if (key != null) {
                    this.writer.append('\"');
                    JSONParser.escape(key, this.writer);
                    this.writer.append('\"');
                    this.writer.append(":");
                }
            }
            catch (IOException e) {
                this.remove();
                throw new TeiidClientException(e);
            }
        }

        public Writer getWriter() {
            return this.writer;
        }

        public ClobType close(CommandContext cc) throws TeiidClientException {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                this.remove();
                throw new TeiidClientException(e);
            }
            if (this.fsisf.getStorageMode() == InputStreamFactory.StorageMode.MEMORY) {
                byte[] bytes = this.fsisf.getMemoryBytes();
                this.fsisf.free();
                ClobType result = new ClobType(new ClobImpl(new String(bytes, Streamable.CHARSET)));
                result.setType(ClobType.Type.JSON);
                return result;
            }
            ClobType result = new ClobType(new ClobImpl(this.fsisf, -1L));
            if (cc != null) {
                cc.addCreatedLob(this.fsisf);
            }
            result.setType(ClobType.Type.JSON);
            return result;
        }

        public void remove() {
            this.fs.remove();
        }

        public void end(boolean array) throws TeiidClientException {
            this.position.pop();
            try {
                if (array) {
                    this.writer.append(']');
                } else {
                    this.writer.append('}');
                }
            }
            catch (IOException e) {
                this.remove();
                throw new TeiidClientException(e);
            }
        }
    }
}

