/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.Collection;
import java.util.Map;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.function.source.SystemSource;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.client.Messages;

public class SystemFunctionManager {
    private FunctionTree systemFunctionTree;
    private boolean allowEnvFunction = true;
    private final ClassLoader classLoader;
    private final ITeiidServerVersion teiidVersion;
    private Map<String, Datatype> types;

    public SystemFunctionManager(ITeiidServerVersion teiidVersion, ClassLoader classLoader) {
        this.teiidVersion = teiidVersion;
        this.classLoader = classLoader;
    }

    public SystemFunctionManager(ITeiidServerVersion teiidVersion, ClassLoader classLoader, Map<String, Datatype> typeMap) {
        this(teiidVersion, classLoader);
        this.types = typeMap;
    }

    public ITeiidServerVersion getTeiidVersion() {
        return this.teiidVersion;
    }

    public FunctionTree getSystemFunctions() {
        if (this.systemFunctionTree == null) {
            SystemSource systemSource = new SystemSource(this.getTeiidVersion(), this.allowEnvFunction, this.classLoader);
            ValidatorReport report = new ValidatorReport("Function Validation");
            Collection<FunctionMethod> functionMethods = systemSource.getFunctionMethods();
            FunctionMetadataValidator.validateFunctionMethods(this.teiidVersion, functionMethods, report, this.types);
            if (report.hasItems()) {
                System.err.println(Messages.getString(Messages.ERR.ERR_015_001_0005, report));
            }
            this.systemFunctionTree = new FunctionTree(this.teiidVersion, "SYS", systemSource, true);
        }
        return this.systemFunctionTree;
    }

    public FunctionLibrary getSystemFunctionLibrary() {
        return new FunctionLibrary(this.getTeiidVersion(), this.getSystemFunctions(), new FunctionTree[0]);
    }

    public boolean isAllowEnvFunction() {
        return this.allowEnvFunction;
    }

    public void setAllowEnvFunction(boolean allowEnvFunction) {
        this.allowEnvFunction = allowEnvFunction;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

