/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.source;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.AnnotationUtils;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.MetadataFactory;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.GeometryFunctionMethods;
import org.teiid.query.function.JSONFunctionMethods;
import org.teiid.query.function.SystemFunctionMethods;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.function.UDFSource;
import org.teiid.query.function.metadata.FunctionCategoryConstants;
import org.teiid.query.function.source.SecuritySystemFunctions;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.runtime.client.Messages;

public class SystemSource
extends UDFSource
implements FunctionCategoryConstants {
    private static final String FUNCTION_CLASS = FunctionMethods.class.getName();
    private static final String XML_FUNCTION_CLASS = XMLSystemFunctions.class.getName();
    private static final String SECURITY_FUNCTION_CLASS = SecuritySystemFunctions.class.getName();
    private final ITeiidServerVersion teiidVersion;
    private final DataTypeManagerService dataTypeManager;

    public SystemSource(ITeiidServerVersion teiidVersion, boolean allowEnvFunction, ClassLoader classLoader) {
        super(new ArrayList<FunctionMethod>(), classLoader);
        this.teiidVersion = teiidVersion;
        this.dataTypeManager = DataTypeManagerService.getInstance(teiidVersion);
        this.addArithmeticFunction("+", Messages.getString(Messages.SystemSource.add_description, new Object[0]), "plus", Messages.getString(Messages.SystemSource.add_result_description, new Object[0]));
        this.addArithmeticFunction("-", Messages.getString(Messages.SystemSource.subtract_description, new Object[0]), "minus", Messages.getString(Messages.SystemSource.subtract_result_description, new Object[0]));
        this.addArithmeticFunction("*", Messages.getString(Messages.SystemSource.multiply_description, new Object[0]), "multiply", Messages.getString(Messages.SystemSource.multiply_result_description, new Object[0]));
        this.addArithmeticFunction("/", Messages.getString(Messages.SystemSource.divide_description, new Object[0]), "divide", Messages.getString(Messages.SystemSource.divide_result_description, new Object[0]));
        this.addArithmeticFunction("mod", Messages.getString(Messages.SystemSource.mod_description, new Object[0]), "mod", Messages.getString(Messages.SystemSource.mod_result_description, new Object[0]));
        this.addAbsFunction();
        this.addRandFunction();
        this.addPowerFunction();
        this.addRoundFunction();
        this.addSignFunction();
        this.addSqrtFunction();
        this.addDoubleFunction("acos", Messages.getString(Messages.SystemSource.acos_description, new Object[0]));
        this.addDoubleFunction("asin", Messages.getString(Messages.SystemSource.asin_description, new Object[0]));
        this.addDoubleFunction("atan", Messages.getString(Messages.SystemSource.atan_description, new Object[0]));
        this.addAtan2Function("atan2", Messages.getString(Messages.SystemSource.atan2_description, new Object[0]));
        this.addDoubleFunction("cos", Messages.getString(Messages.SystemSource.cos_description, new Object[0]));
        this.addDoubleFunction("cot", Messages.getString(Messages.SystemSource.cot_description, new Object[0]));
        this.addDoubleFunction("degrees", Messages.getString(Messages.SystemSource.degrees_description, new Object[0]));
        this.addPiFunction("pi", Messages.getString(Messages.SystemSource.pi_description, new Object[0]));
        this.addDoubleFunction("radians", Messages.getString(Messages.SystemSource.radians_description, new Object[0]));
        this.addDoubleFunction("sin", Messages.getString(Messages.SystemSource.sin_description, new Object[0]));
        this.addDoubleFunction("tan", Messages.getString(Messages.SystemSource.tan_description, new Object[0]));
        this.addDoubleFunction("log", Messages.getString(Messages.SystemSource.log_description, new Object[0]));
        this.addDoubleFunction("log10", Messages.getString(Messages.SystemSource.log10_description, new Object[0]));
        this.addDoubleFunction("ceiling", Messages.getString(Messages.SystemSource.ceiling_description, new Object[0]));
        this.addDoubleFunction("exp", Messages.getString(Messages.SystemSource.exp_description, new Object[0]));
        this.addDoubleFunction("floor", Messages.getString(Messages.SystemSource.floor_description, new Object[0]));
        this.addBitFunction("bitand", Messages.getString(Messages.SystemSource.bitand_description, new Object[0]), "bitand", 2, Messages.getString(Messages.SystemSource.bitand_result_description, new Object[0]));
        this.addBitFunction("bitor", Messages.getString(Messages.SystemSource.bitor_description, new Object[0]), "bitor", 2, Messages.getString(Messages.SystemSource.bitor_result_description, new Object[0]));
        this.addBitFunction("bitxor", Messages.getString(Messages.SystemSource.bitxor_description, new Object[0]), "bitxor", 2, Messages.getString(Messages.SystemSource.bitxor_result_description, new Object[0]));
        this.addBitFunction("bitnot", Messages.getString(Messages.SystemSource.bitnot_description, new Object[0]), "bitnot", 1, Messages.getString(Messages.SystemSource.bitnot_result_description, new Object[0]));
        this.addConstantDateFunction("curdate", Messages.getString(Messages.SystemSource.curdate_description, new Object[0]), "currentDate", DataTypeManagerService.DefaultDataTypes.DATE);
        this.addConstantDateFunction("curtime", Messages.getString(Messages.SystemSource.curtime_description, new Object[0]), "currentTime", DataTypeManagerService.DefaultDataTypes.TIME);
        this.addConstantDateFunction("now", Messages.getString(Messages.SystemSource.now_description, new Object[0]), "currentTimestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP);
        this.addDateFunction("dayname", "dayName", Messages.getString(Messages.SystemSource.dayname_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.dayname_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.STRING);
        this.addDateFunction("dayofmonth", "dayOfMonth", Messages.getString(Messages.SystemSource.dayofmonth_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.dayofmonth_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("dayofweek", "dayOfWeek", Messages.getString(Messages.SystemSource.dayofweek_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.dayofweek_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("dayofyear", "dayOfYear", Messages.getString(Messages.SystemSource.dayofyear_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.dayofyear_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("month", "month", Messages.getString(Messages.SystemSource.month_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.month_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("monthname", "monthName", Messages.getString(Messages.SystemSource.monthname_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.monthname_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.STRING);
        this.addDateFunction("week", "week", Messages.getString(Messages.SystemSource.week_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.week_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("year", "year", Messages.getString(Messages.SystemSource.year_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.year_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTimeFunction("hour", "hour", Messages.getString(Messages.SystemSource.hour_result_t_description, new Object[0]), Messages.getString(Messages.SystemSource.hour_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTimeFunction("minute", "minute", Messages.getString(Messages.SystemSource.minute_result_t_description, new Object[0]), Messages.getString(Messages.SystemSource.minute_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTimeFunction("second", "second", Messages.getString(Messages.SystemSource.second_result_t_description, new Object[0]), Messages.getString(Messages.SystemSource.second_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addQuarterFunction("quarter", "quarter", Messages.getString(Messages.SystemSource.quarter_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.quarter_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTimestampAddFunction();
        this.addTimestampDiffFunction();
        this.addTimeZoneFunctions();
        this.addTimestampCreateFunction();
        this.addUnixTimeFunctions();
        this.addStringFunction("length", Messages.getString(Messages.SystemSource.length_result, new Object[0]), "length", DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addStringFunction("ucase", Messages.getString(Messages.SystemSource.ucase_result, new Object[0]), "upperCase", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("lcase", Messages.getString(Messages.SystemSource.lcase_result, new Object[0]), "lowerCase", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("lower", Messages.getString(Messages.SystemSource.lower_result, new Object[0]), "lowerCase", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("upper", Messages.getString(Messages.SystemSource.upper_result, new Object[0]), "upperCase", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("ltrim", Messages.getString(Messages.SystemSource.left_result, new Object[0]), "leftTrim", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("rtrim", Messages.getString(Messages.SystemSource.right_result, new Object[0]), "rightTrim", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addConcatFunction();
        this.addSubstringFunction();
        this.addLeftRightFunctions();
        this.addLocateFunction();
        this.addReplaceFunction();
        this.addAsciiFunction();
        this.addCharFunction();
        this.addInitCapFunction();
        this.addLpadFunction();
        this.addRpadFunction();
        this.addTranslateFunction();
        this.addRepeatFunction();
        this.addSpaceFunction();
        this.addInsertFunction();
        this.addEndsWithFunction();
        this.addClobFunction("ucase", Messages.getString(Messages.SystemSource.ucaseclob_result, new Object[0]), "upperCase", DataTypeManagerService.DefaultDataTypes.CLOB);
        this.addClobFunction("lcase", Messages.getString(Messages.SystemSource.lcaseclob_result, new Object[0]), "lowerCase", DataTypeManagerService.DefaultDataTypes.CLOB);
        this.addClobFunction("lower", Messages.getString(Messages.SystemSource.lowerclob_result, new Object[0]), "lowerCase", DataTypeManagerService.DefaultDataTypes.CLOB);
        this.addClobFunction("upper", Messages.getString(Messages.SystemSource.upperclob_result, new Object[0]), "upperCase", DataTypeManagerService.DefaultDataTypes.CLOB);
        this.addToCharsFunction();
        this.addToBytesFunction();
        this.addConversionFunctions();
        this.addContextFunctions();
        this.addRowLimitFunctions();
        this.addRowLimitExceptionFunctions();
        this.addDecodeFunctions();
        this.addLookupFunctions();
        this.addUserFunction();
        this.addCurrentDatabaseFunction();
        if (allowEnvFunction) {
            this.addEnvFunction();
        }
        this.addSessionIdFunction();
        this.addCommandPayloadFunctions();
        this.addIfNullFunctions();
        this.addFormatTimestampFunction();
        this.addFormatNumberFunctions();
        this.addParseTimestampFunction();
        this.addParseNumberFunctions();
        this.addXpathValueFunction();
        this.addXslTransformFunction();
        this.addXmlConcat();
        this.addXmlComment();
        this.addXmlPi();
        this.addJsonToXml();
        this.addSecurityFunctions();
        for (String type : this.dataTypeManager.getAllDataTypeNames()) {
            if (!this.dataTypeManager.isNonComparable(type)) {
                this.addTypedNullIfFunction(type);
            }
            this.addTypedCoalesceFunction(type);
        }
        this.addUnescape();
        this.addUuidFunction();
        this.addArrayGet();
        this.addArrayLength();
        this.addTrimFunction();
        this.addFunctions(JSONFunctionMethods.class);
        this.addFunctions(SystemFunctionMethods.class);
        this.addFunctions(FunctionMethods.class);
        this.addFunctions(GeometryFunctionMethods.class);
        if (teiidVersion.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_10)) {
            this.addFunctions(XMLSystemFunctions.class);
        }
    }

    private Class<?> convertPrimitiveToObject(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        } else if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        }
        return clazz;
    }

    private void addFunctions(Class<?> clazz) {
        if (!AnnotationUtils.isApplicable(clazz, (ITeiidServerVersion)this.teiidVersion)) {
            return;
        }
        Method[] methods = clazz.getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method arg0, Method arg1) {
                return arg0.toGenericString().compareTo(arg1.toGenericString());
            }
        });
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            TeiidFunction f = method.getAnnotation(TeiidFunction.class);
            if (f != null) {
                String name = f.name();
                if (name.isEmpty()) {
                    name = method.getName();
                }
                this.addFunction(method, f, name);
                if (!f.alias().isEmpty()) {
                    this.addFunction(method, f, f.alias());
                }
            }
            ++n2;
        }
    }

    private FunctionMethod addFunction(Method method, TeiidFunction f, String name) {
        FunctionMethod func = MetadataFactory.createFunctionFromMethod(this.teiidVersion, name, method);
        Messages.SystemSource descKey = Messages.SystemSource.safeValueOf(String.valueOf(name.toLowerCase()) + "_description");
        Messages.SystemSource resultKey = Messages.SystemSource.safeValueOf(String.valueOf(name.toLowerCase()) + "_result");
        func.setDescription(Messages.getString(descKey, new Object[0]));
        func.setCategory(f.category());
        int i = 0;
        while (i < func.getInputParameterCount()) {
            Messages.SystemSource paramKey = Messages.SystemSource.safeValueOf(String.valueOf(name.toLowerCase()) + "_param" + (i + 1));
            func.getInputParameters().get(i).setDescription(Messages.getString(paramKey, new Object[0]));
            ++i;
        }
        func.getOutputParameter().setDescription(Messages.getString(resultKey, new Object[0]));
        if (f.nullOnNull()) {
            func.setNullOnNull(true);
        }
        func.setDeterminism(f.determinism());
        func.setPushdown(f.pushdown());
        this.functions.add(func);
        return func;
    }

    private void addTrimFunction() {
        this.functions.add(new FunctionMethod("trim", Messages.getString(Messages.SystemSource.trim_description, new Object[0]), "String", FUNCTION_CLASS, "trim", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "spec", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.trim_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "trimChar", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.trim_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.trim_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.trim_result, new Object[0]))));
    }

    private void addArrayLength() {
        this.functions.add(new FunctionMethod("array_length", Messages.getString(Messages.SystemSource.array_length_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CAN_PUSHDOWN, FUNCTION_CLASS, "array_length", Arrays.asList(new FunctionParameter(this.teiidVersion, "array", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.array_param1, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.array_length_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addArrayGet() {
        this.functions.add(new FunctionMethod("array_get", Messages.getString(Messages.SystemSource.array_get_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CAN_PUSHDOWN, FUNCTION_CLASS, "array_get", Arrays.asList(new FunctionParameter(this.teiidVersion, "array", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.array_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "index", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.array_get_param2, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.array_get_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addUnescape() {
        this.functions.add(new FunctionMethod("unescape", Messages.getString(Messages.SystemSource.unescape_description, new Object[0]), "String", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "unescape", Arrays.asList(new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.unescape_param1, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.unescape_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addSecurityFunctions() {
        this.functions.add(new FunctionMethod("hasRole", Messages.getString(Messages.SystemSource.hasrole_description, new Object[0]), "Security", FunctionMethod.PushDown.CANNOT_PUSHDOWN, SECURITY_FUNCTION_CLASS, "hasRole", Arrays.asList(new FunctionParameter(this.teiidVersion, "roleType", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.hasrole_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "roleName", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.hasrole_param2, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.BOOLEAN, Messages.getString(Messages.SystemSource.hasrole_result, new Object[0])), true, FunctionMethod.Determinism.USER_DETERMINISTIC));
        this.functions.add(new FunctionMethod("hasRole", Messages.getString(Messages.SystemSource.hasrole_description, new Object[0]), "Security", FunctionMethod.PushDown.CANNOT_PUSHDOWN, SECURITY_FUNCTION_CLASS, "hasRole", Arrays.asList(new FunctionParameter(this.teiidVersion, "roleName", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.hasrole_param2, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.BOOLEAN, Messages.getString(Messages.SystemSource.hasrole_result, new Object[0])), true, FunctionMethod.Determinism.USER_DETERMINISTIC));
    }

    private void addFormatNumberFunctions() {
        this.addFormatNumberFunction("formatinteger", Messages.getString(Messages.SystemSource.formatinteger_description, new Object[0]), "format", "integer", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.formatinteger_result_description, new Object[0]));
        this.addFormatNumberFunction("formatlong", Messages.getString(Messages.SystemSource.formatlong_description, new Object[0]), "format", "long", DataTypeManagerService.DefaultDataTypes.LONG, Messages.getString(Messages.SystemSource.formatlong_result_description, new Object[0]));
        this.addFormatNumberFunction("formatdouble", Messages.getString(Messages.SystemSource.formatdouble_description, new Object[0]), "format", "double", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.formatdouble_result_description, new Object[0]));
        this.addFormatNumberFunction("formatfloat", Messages.getString(Messages.SystemSource.formatfloat_description, new Object[0]), "format", "float", DataTypeManagerService.DefaultDataTypes.FLOAT, Messages.getString(Messages.SystemSource.formatfloat_result_description, new Object[0]));
        this.addFormatNumberFunction("formatbiginteger", Messages.getString(Messages.SystemSource.formatbiginteger_description, new Object[0]), "format", "biginteger", DataTypeManagerService.DefaultDataTypes.BIG_INTEGER, Messages.getString(Messages.SystemSource.formatbiginteger_result_description, new Object[0]));
        this.addFormatNumberFunction("formatbigdecimal", Messages.getString(Messages.SystemSource.formatbigdecimal_description, new Object[0]), "format", "bigdecimal", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.formatbigdecimal_result_description, new Object[0]));
    }

    private void addParseNumberFunctions() {
        this.addParseNumberFunction("parseinteger", Messages.getString(Messages.SystemSource.parseinteger_description, new Object[0]), "parseInteger", "integer", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.parseinteger_result_description, new Object[0]));
        this.addParseNumberFunction("parselong", Messages.getString(Messages.SystemSource.parselong_description, new Object[0]), "parseLong", "long", DataTypeManagerService.DefaultDataTypes.LONG, Messages.getString(Messages.SystemSource.parselong_result_description, new Object[0]));
        this.addParseNumberFunction("parsedouble", Messages.getString(Messages.SystemSource.parsedouble_description, new Object[0]), "parseDouble", "double", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.parsedouble_result_description, new Object[0]));
        this.addParseNumberFunction("parsefloat", Messages.getString(Messages.SystemSource.parsefloat_description, new Object[0]), "parseFloat", "float", DataTypeManagerService.DefaultDataTypes.FLOAT, Messages.getString(Messages.SystemSource.parsefloat_result_description, new Object[0]));
        this.addParseNumberFunction("parsebiginteger", Messages.getString(Messages.SystemSource.parsebiginteger_description, new Object[0]), "parseBigInteger", "biginteger", DataTypeManagerService.DefaultDataTypes.BIG_INTEGER, Messages.getString(Messages.SystemSource.parsebiginteger_result_description, new Object[0]));
        this.addParseNumberFunction("parsebigdecimal", Messages.getString(Messages.SystemSource.parsebigdecimal_description, new Object[0]), "parseBigDecimal", "bigdecimal", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.parsebigdecimal_result_description, new Object[0]));
    }

    private void addArithmeticFunction(String functionName, String description, String methodName, String resultsDescription) {
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.LONG);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.FLOAT);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.BIG_INTEGER);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedArithmeticFunction(String functionName, String description, String methodName, String resultsDescription, DataTypeManagerService.DefaultDataTypes type) {
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, type.getId());
    }

    private void addTypedArithmeticFunction(String functionName, String description, String methodName, String resultsDescription, String type) {
        this.functions.add(new FunctionMethod(functionName, description, "Numeric", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "op1", type, Messages.getString(Messages.SystemSource.arith_left_op, new Object[0])), new FunctionParameter(this.teiidVersion, "op2", type, Messages.getString(Messages.SystemSource.arith_right_op, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", type, resultsDescription)));
    }

    private void addAbsFunction() {
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.LONG);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.FLOAT);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes type) {
        this.addTypedAbsFunction(type.getId());
    }

    private void addTypedAbsFunction(String type) {
        this.functions.add(new FunctionMethod("abs", Messages.getString(Messages.SystemSource.abs_description, new Object[0]), "Numeric", FUNCTION_CLASS, "abs", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "number", type, Messages.getString(Messages.SystemSource.abs_arg, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", type, Messages.getString(Messages.SystemSource.abs_result_description, new Object[0]))));
    }

    private void addRandFunction() {
        FunctionMethod rand = new FunctionMethod("rand", Messages.getString(Messages.SystemSource.rand_description, new Object[0]), "Numeric", FUNCTION_CLASS, "rand", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "seed", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.rand_arg, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.rand_result_description, new Object[0])));
        rand.setNullOnNull(false);
        rand.setDeterminism(FunctionMethod.Determinism.NONDETERMINISTIC);
        this.functions.add(rand);
        rand = new FunctionMethod("rand", Messages.getString(Messages.SystemSource.rand_description, new Object[0]), "Numeric", FUNCTION_CLASS, "rand", new FunctionParameter[0], new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.rand_result_description, new Object[0])));
        rand.setDeterminism(FunctionMethod.Determinism.NONDETERMINISTIC);
        this.functions.add(rand);
    }

    private void addUuidFunction() {
        FunctionMethod rand = new FunctionMethod("uuid", Messages.getString(Messages.SystemSource.uuid_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "uuid", new FunctionParameter[0], new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.uuid_result_description, new Object[0])));
        rand.setDeterminism(FunctionMethod.Determinism.NONDETERMINISTIC);
        this.functions.add(rand);
    }

    private void addDoubleFunction(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "number", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.double_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "number", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.double_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
    }

    private void addAtan2Function(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "number1", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.atan_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "number2", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.atan_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "number1", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.atan_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "number2", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.atan_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
    }

    private void addPiFunction(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[0], new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
    }

    private void addPowerFunction() {
        this.addTypedPowerFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE, DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedPowerFunction(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER, DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedPowerFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, DataTypeManagerService.DefaultDataTypes.INTEGER);
    }

    private void addTypedPowerFunction(DataTypeManagerService.DefaultDataTypes baseType, DataTypeManagerService.DefaultDataTypes powerType) {
        this.addTypedPowerFunction(baseType.getId(), powerType.getId());
    }

    private void addTypedPowerFunction(String baseType, String powerType) {
        this.functions.add(new FunctionMethod("power", Messages.getString(Messages.SystemSource.power_description, new Object[0]), "Numeric", FUNCTION_CLASS, "power", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "base", baseType, Messages.getString(Messages.SystemSource.power_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "power", powerType, Messages.getString(Messages.SystemSource.power_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", baseType, Messages.getString(Messages.SystemSource.power_result_description, new Object[0]))));
    }

    private void addRoundFunction() {
        this.addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes.FLOAT);
        this.addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes roundType) {
        this.addTypedRoundFunction(roundType.getId());
    }

    private void addTypedRoundFunction(String roundType) {
        this.functions.add(new FunctionMethod("round", Messages.getString(Messages.SystemSource.round_description, new Object[0]), "Numeric", FUNCTION_CLASS, "round", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "number", roundType, Messages.getString(Messages.SystemSource.round_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "places", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.round_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", roundType, Messages.getString(Messages.SystemSource.round_result_description, new Object[0]))));
    }

    private void addSignFunction() {
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.LONG);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.FLOAT);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedSignFunction(DataTypeManagerService.DefaultDataTypes type) {
        this.addTypedSignFunction(type.getId());
    }

    private void addTypedSignFunction(String type) {
        this.functions.add(new FunctionMethod("sign", Messages.getString(Messages.SystemSource.sign_description, new Object[0]), "Numeric", FUNCTION_CLASS, "sign", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "number", type, Messages.getString(Messages.SystemSource.sign_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.sign_result_description, new Object[0]))));
    }

    private void addSqrtFunction() {
        this.addTypedSqrtFunction(DataTypeManagerService.DefaultDataTypes.LONG);
        this.addTypedSqrtFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedSqrtFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedSqrtFunction(DataTypeManagerService.DefaultDataTypes type) {
        this.addTypedSqrtFunction(type.getId());
    }

    private void addTypedSqrtFunction(String type) {
        this.functions.add(new FunctionMethod("sqrt", Messages.getString(Messages.SystemSource.sqrt_description, new Object[0]), "Numeric", FUNCTION_CLASS, "sqrt", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "number", type, Messages.getString(Messages.SystemSource.sqrt_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.sqrt_result_description, new Object[0]))));
    }

    private void addConstantDateFunction(String name, String description, String methodName, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addConstantDateFunction(name, description, methodName, returnType.getId());
    }

    private void addConstantDateFunction(String name, String description, String methodName, String returnType) {
        FunctionMethod method = new FunctionMethod(name, description, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[0], new FunctionParameter(this.teiidVersion, "result", returnType, description));
        method.setDeterminism(FunctionMethod.Determinism.COMMAND_DETERMINISTIC);
        this.functions.add(method);
    }

    private void addDateFunction(String name, String methodName, String dateDesc, String timestampDesc, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addDateFunction(name, methodName, dateDesc, timestampDesc, returnType.getId());
    }

    private void addDateFunction(String name, String methodName, String dateDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, dateDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "date", DataTypeManagerService.DefaultDataTypes.DATE, dateDesc)}, new FunctionParameter(this.teiidVersion, "result", returnType, dateDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, timestampDesc)}, new FunctionParameter(this.teiidVersion, "result", returnType, timestampDesc)));
    }

    private void addQuarterFunction(String name, String methodName, String dateDesc, String timestampDesc, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addQuarterFunction(name, methodName, dateDesc, timestampDesc, returnType.getId());
    }

    private void addQuarterFunction(String name, String methodName, String dateDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, dateDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "date", DataTypeManagerService.DefaultDataTypes.DATE, dateDesc)}, new FunctionParameter(this.teiidVersion, "result", returnType, dateDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, timestampDesc)}, new FunctionParameter(this.teiidVersion, "result", returnType, timestampDesc)));
    }

    private void addTimestampAddFunction() {
        this.functions.add(SystemSource.createSyntheticMethod("timestampadd", Messages.getString(Messages.SystemSource.timestampadd_d_description, new Object[0]), "Datetime", null, null, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "interval", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.timestampadd_d_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.timestampadd_d_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.timestampadd_d_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.timestampadd_d_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod("timestampadd", Messages.getString(Messages.SystemSource.timestampadd_t_description, new Object[0]), "Datetime", null, null, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "interval", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.timestampadd_t_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.timestampadd_t_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.timestampadd_t_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.timestampadd_t_result_description, new Object[0]))));
        this.functions.add(new FunctionMethod("timestampadd", Messages.getString(Messages.SystemSource.timestampadd_ts_description, new Object[0]), "Datetime", FUNCTION_CLASS, "timestampAdd", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "interval", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.timestampadd_ts_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.timestampadd_ts_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.timestampadd_ts_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.timestampadd_ts_result, new Object[0]))));
    }

    private void addTimestampDiffFunction() {
        this.functions.add(new FunctionMethod("timestampdiff", Messages.getString(Messages.SystemSource.timestampdiff_ts_description, new Object[0]), "Datetime", FUNCTION_CLASS, "timestampDiff", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "interval", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.timestampdiff_ts_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "timestamp1", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.timestampdiff_ts_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "timestamp2", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.timestampdiff_ts_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.LONG, Messages.getString(Messages.SystemSource.timestampdiff_ts_result_description, new Object[0]))));
    }

    private void addTimestampCreateFunction() {
        this.functions.add(new FunctionMethod("timestampcreate", Messages.getString(Messages.SystemSource.timestampcreate_description, new Object[0]), "Datetime", FUNCTION_CLASS, "timestampCreate", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "date", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.timestampcreate_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "time", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.timestampcreate_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.timestampcreate_result_description, new Object[0]))));
    }

    private void addTimeFunction(String name, String methodName, String timeDesc, String timestampDesc, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addTimeFunction(name, methodName, timeDesc, timestampDesc, returnType.getId());
    }

    private void addTimeFunction(String name, String methodName, String timeDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, timeDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "time", DataTypeManagerService.DefaultDataTypes.TIME, timeDesc)}, new FunctionParameter(this.teiidVersion, "result", returnType, timeDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, timestampDesc)}, new FunctionParameter(this.teiidVersion, "result", returnType, timestampDesc)));
    }

    private void addStringFunction(String name, String description, String methodName, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addStringFunction(name, description, methodName, returnType.getId());
    }

    private void addStringFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "String", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.stringfunc_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", returnType, description)));
    }

    private void addClobFunction(String name, String description, String methodName, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addClobFunction(name, description, methodName, returnType.getId());
    }

    private void addClobFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "String", FunctionMethod.PushDown.MUST_PUSHDOWN, FUNCTION_CLASS, methodName, Arrays.asList(new FunctionParameter(this.teiidVersion, "clob", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.clobfunc_arg1, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", returnType, description), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addConcatFunction() {
        this.functions.add(new FunctionMethod("concat", Messages.getString(Messages.SystemSource.concat_description, new Object[0]), "String", FUNCTION_CLASS, "concat", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string1", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.concat_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "string2", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.concat_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.concat_result_description, new Object[0]))));
        this.functions.add(new FunctionMethod("||", Messages.getString(Messages.SystemSource.concatop_description, new Object[0]), "String", FUNCTION_CLASS, "concat", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string1", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.concatop_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "string2", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.concatop_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.concatop_result_description, new Object[0]))));
        FunctionMethod concat2 = new FunctionMethod("concat2", Messages.getString(Messages.SystemSource.concat_description, new Object[0]), "String", FUNCTION_CLASS, "concat2", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string1", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.concat_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "string2", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.concat_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.concat_result_description, new Object[0])));
        concat2.setNullOnNull(false);
        this.functions.add(concat2);
    }

    private void addSubstringFunction() {
        this.functions.add(new FunctionMethod("substring", Messages.getString(Messages.SystemSource.substring_description, new Object[0]), "String", FUNCTION_CLASS, "substring", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.substring_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "index", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.substring_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.substring_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.substring_result, new Object[0]))));
        this.functions.add(new FunctionMethod("substring", Messages.getString(Messages.SystemSource.susbstring2_description, new Object[0]), "String", FUNCTION_CLASS, "substring", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.substring2_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "index", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.substring2_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.substring2_result, new Object[0]))));
    }

    private void addLeftRightFunctions() {
        this.functions.add(new FunctionMethod("left", Messages.getString(Messages.SystemSource.left_description, new Object[0]), "String", FUNCTION_CLASS, "left", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.left_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.left_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.left2_result, new Object[0]))));
        this.functions.add(new FunctionMethod("right", Messages.getString(Messages.SystemSource.right_description, new Object[0]), "String", FUNCTION_CLASS, "right", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.right_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.right_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.right2_result, new Object[0]))));
    }

    private void addLocateFunction() {
        FunctionMethod func = new FunctionMethod("locate", Messages.getString(Messages.SystemSource.locate_description, new Object[0]), "String", FUNCTION_CLASS, "locate", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "substring", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.locate_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.locate_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "index", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.locate_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.locate_result, new Object[0])));
        func.setNullOnNull(false);
        this.functions.add(func);
        this.functions.add(new FunctionMethod("locate", Messages.getString(Messages.SystemSource.locate2_description, new Object[0]), "String", FUNCTION_CLASS, "locate", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "substring", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.locate2_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.locate2_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.locate2_result, new Object[0]))));
    }

    private void addReplaceFunction() {
        this.functions.add(new FunctionMethod("replace", Messages.getString(Messages.SystemSource.replace_description, new Object[0]), "String", FUNCTION_CLASS, "replace", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.replace_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "substring", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.replace_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "replacement", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.replace_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.replace_result, new Object[0]))));
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private void addEndsWithFunction() {
        if (this.teiidVersion.getMinimumVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0)) {
            return;
        }
        FunctionParameter param1 = null;
        param1 = this.teiidVersion.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_12_4) ? new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.BOOLEAN, Messages.getString(Messages.SystemSource.endswith_result, new Object[0])) : new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.endswith_result, new Object[0]));
        FunctionMethod f = new FunctionMethod("endswith", Messages.getString(Messages.SystemSource.endswith_description, new Object[0]), "String", FUNCTION_CLASS, "endsWith", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "substring", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.endswith_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.endswith_arg2, new Object[0]))}, param1);
        this.functions.add(f);
    }

    private void addRepeatFunction() {
        this.functions.add(new FunctionMethod("repeat", Messages.getString(Messages.SystemSource.repeat_description, new Object[0]), "String", FUNCTION_CLASS, "repeat", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.repeat_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.repeat_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.repeat_result, new Object[0]))));
    }

    private void addSpaceFunction() {
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.SPACE.text(), Messages.getString(Messages.SystemSource.space_description, new Object[0]), "String", null, null, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.space_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.space_result, new Object[0]))));
    }

    private void addInsertFunction() {
        this.functions.add(new FunctionMethod("insert", Messages.getString(Messages.SystemSource.insert_description, new Object[0]), "String", FUNCTION_CLASS, "insert", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "str1", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.insert_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "start", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.insert_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.insert_arg3, new Object[0])), new FunctionParameter(this.teiidVersion, "str2", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.insert_arg4, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.insert_result, new Object[0]))));
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private void addToCharsFunction() {
        if (this.teiidVersion.getMinimumVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0)) {
            return;
        }
        this.functions.add(new FunctionMethod("to_chars", Messages.getString(Messages.SystemSource.encode_description, new Object[0]), "Conversion", FUNCTION_CLASS, "toChars", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "value", DataTypeManagerService.DefaultDataTypes.BLOB, Messages.getString(Messages.SystemSource.encode_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "encoding", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.encode_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.encode_result, new Object[0]))));
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private void addToBytesFunction() {
        if (this.teiidVersion.getMinimumVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0)) {
            return;
        }
        this.functions.add(new FunctionMethod("to_bytes", Messages.getString(Messages.SystemSource.decode_description, new Object[0]), "Conversion", FUNCTION_CLASS, "toBytes", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "value", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.decode_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "encoding", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.decode_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.BLOB, Messages.getString(Messages.SystemSource.decode_result, new Object[0]))));
    }

    private void addAsciiFunction() {
        this.functions.add(new FunctionMethod("ascii", Messages.getString(Messages.SystemSource.ascii_description, new Object[0]), "String", FUNCTION_CLASS, "ascii", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.ascii_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.ascii_result, new Object[0]))));
        this.functions.add(new FunctionMethod("ascii", Messages.getString(Messages.SystemSource.ascii2_description, new Object[0]), "String", FUNCTION_CLASS, "ascii", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "char", DataTypeManagerService.DefaultDataTypes.CHAR, Messages.getString(Messages.SystemSource.ascii2_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.ascii2_result, new Object[0]))));
    }

    private void addCharFunction() {
        this.functions.add(new FunctionMethod("char", Messages.getString(Messages.SystemSource.char_description, new Object[0]), "String", FUNCTION_CLASS, "chr", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "code", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.char_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.CHAR, Messages.getString(Messages.SystemSource.char_result, new Object[0]))));
        this.functions.add(new FunctionMethod("chr", Messages.getString(Messages.SystemSource.chr_description, new Object[0]), "String", FUNCTION_CLASS, "chr", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "code", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.chr_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.CHAR, Messages.getString(Messages.SystemSource.chr_result, new Object[0]))));
    }

    private void addInitCapFunction() {
        this.functions.add(new FunctionMethod("initcap", Messages.getString(Messages.SystemSource.initcap_description, new Object[0]), "String", FUNCTION_CLASS, "initCap", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.initcap_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.initcap_result, new Object[0]))));
    }

    private void addLpadFunction() {
        this.functions.add(new FunctionMethod("lpad", Messages.getString(Messages.SystemSource.lpad_description, new Object[0]), "String", FUNCTION_CLASS, "lpad", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.lpad_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.lpad_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.lpad_result, new Object[0]))));
        this.functions.add(new FunctionMethod("lpad", Messages.getString(Messages.SystemSource.lpad3_description, new Object[0]), "String", FUNCTION_CLASS, "lpad", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.lpad3_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.lpad3_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "char", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.lpad3_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.lpad3_result, new Object[0]))));
    }

    private void addRpadFunction() {
        this.functions.add(new FunctionMethod("rpad", Messages.getString(Messages.SystemSource.rpad1_description, new Object[0]), "String", FUNCTION_CLASS, "rpad", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.rpad1_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.rpad1_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.rpad1_result, new Object[0]))));
        this.functions.add(new FunctionMethod("rpad", Messages.getString(Messages.SystemSource.rpad3_description, new Object[0]), "String", FUNCTION_CLASS, "rpad", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.rpad3_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.rpad3_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "char", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.rpad3_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.rpad3_result, new Object[0]))));
    }

    private void addTranslateFunction() {
        this.functions.add(new FunctionMethod("translate", Messages.getString(Messages.SystemSource.translate_description, new Object[0]), "String", FUNCTION_CLASS, "translate", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.translate_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "source", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.translate_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "destination", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.translate_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.translate_result, new Object[0]))));
    }

    private void addConversionFunctions() {
        for (String type : this.dataTypeManager.getAllDataTypeNames()) {
            this.addTypedConversionFunction("convert", type);
            this.addTypedConversionFunction("cast", type);
        }
    }

    private void addTypedConversionFunction(String name, String sourceType) {
        this.functions.add(new FunctionMethod(name, Messages.getString(Messages.SystemSource.convert_description, sourceType), "Conversion", FUNCTION_CLASS, "convert", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "value", sourceType, Messages.getString(Messages.SystemSource.convert_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "target", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.convert_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.convert_result, new Object[0]))));
    }

    private void addContextFunctions() {
        for (String contextType : this.dataTypeManager.getAllDataTypeNames()) {
            for (String exprType : this.dataTypeManager.getAllDataTypeNames()) {
                this.addTypedContextFunction(contextType, exprType);
            }
        }
    }

    private void addTypedContextFunction(String contextType, String exprType) {
        this.functions.add(new FunctionMethod("context", Messages.getString(Messages.SystemSource.context_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "context", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "context", contextType, Messages.getString(Messages.SystemSource.context_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "element", exprType, Messages.getString(Messages.SystemSource.context_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", exprType, Messages.getString(Messages.SystemSource.context_result, new Object[0]))));
    }

    private void addRowLimitFunctions() {
        for (String exprType : this.dataTypeManager.getAllDataTypeNames()) {
            this.functions.add(new FunctionMethod("rowlimit", Messages.getString(Messages.SystemSource.rowlimit_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "rowlimit", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "element", exprType, Messages.getString(Messages.SystemSource.rowlimit_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.rowlimit_result, new Object[0]))));
        }
    }

    private void addRowLimitExceptionFunctions() {
        for (String exprType : this.dataTypeManager.getAllDataTypeNames()) {
            this.functions.add(new FunctionMethod("rowlimitexception", Messages.getString(Messages.SystemSource.rowlimitexception_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "rowlimitexception", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "element", exprType, Messages.getString(Messages.SystemSource.rowlimit_arg1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.rowlimit_result, new Object[0]))));
        }
    }

    private void addDecodeFunctions() {
        this.addDecodeFunction("decodeInteger", DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDecodeFunction("decodeString", DataTypeManagerService.DefaultDataTypes.STRING);
    }

    private void addDecodeFunction(String functionName, DataTypeManagerService.DefaultDataTypes resultType) {
        this.addDecodeFunction(functionName, resultType.getId());
    }

    private void addDecodeFunction(String functionName, String resultType) {
        this.functions.add(SystemSource.createSyntheticMethod(functionName, Messages.getString(Messages.SystemSource.decode1_description, new Object[0]), "Miscellaneous", null, null, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "input", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.decode1_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "decodeString", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.decode1_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", resultType, Messages.getString(Messages.SystemSource.decode1_result, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(functionName, Messages.getString(Messages.SystemSource.decode2_description, new Object[0]), "Miscellaneous", null, null, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "input", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.decode2_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "decodeString", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.decode2_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "delimiter", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.decode2_arg3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", resultType, Messages.getString(Messages.SystemSource.decode2_result, new Object[0]))));
    }

    private void addLookupFunctions() {
        for (String keyValueType : this.dataTypeManager.getAllDataTypeNames()) {
            this.functions.add(new FunctionMethod("lookup", Messages.getString(Messages.SystemSource.lookup_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "lookup", Arrays.asList(new FunctionParameter(this.teiidVersion, "codetable", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.lookup_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "returnelement", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.lookup_arg2, new Object[0])), new FunctionParameter(this.teiidVersion, "keyelement", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.lookup_arg3, new Object[0])), new FunctionParameter(this.teiidVersion, "keyvalue", keyValueType, Messages.getString(Messages.SystemSource.lookup_arg4, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.lookup_result, new Object[0])), false, FunctionMethod.Determinism.VDB_DETERMINISTIC));
        }
    }

    private void addUserFunction() {
        this.functions.add(new FunctionMethod("user", Messages.getString(Messages.SystemSource.user_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "user", null, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.user_result, new Object[0])), true, FunctionMethod.Determinism.USER_DETERMINISTIC));
    }

    private void addCurrentDatabaseFunction() {
        this.functions.add(new FunctionMethod("current_database", Messages.getString(Messages.SystemSource.current_database_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "current_database", null, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.current_database_result, new Object[0])), true, FunctionMethod.Determinism.VDB_DETERMINISTIC));
    }

    private void addEnvFunction() {
        this.functions.add(new FunctionMethod("env", Messages.getString(Messages.SystemSource.env_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "env", Arrays.asList(new FunctionParameter(this.teiidVersion, "variablename", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.env_varname, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.env_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addSessionIdFunction() {
        this.functions.add(new FunctionMethod(IFunctionLibrary.FunctionName.SESSION_ID.text(), Messages.getString(Messages.SystemSource.session_id_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "session_id", null, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.session_id_result, new Object[0])), true, FunctionMethod.Determinism.SESSION_DETERMINISTIC));
    }

    private void addCommandPayloadFunctions() {
        this.functions.add(new FunctionMethod("commandpayload", Messages.getString(Messages.SystemSource.commandpayload_desc0, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "commandPayload", null, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.commandpayload_result, new Object[0])), true, FunctionMethod.Determinism.COMMAND_DETERMINISTIC));
        this.functions.add(new FunctionMethod("commandpayload", Messages.getString(Messages.SystemSource.commandpayload_desc1, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "commandPayload", Arrays.asList(new FunctionParameter(this.teiidVersion, "property", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.commandpayload_property, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.commandpayload_result, new Object[0])), true, FunctionMethod.Determinism.COMMAND_DETERMINISTIC));
    }

    private void addIfNullFunctions() {
        for (String type : this.dataTypeManager.getAllDataTypeNames()) {
            this.addNvlFunction(type);
            this.addIfNullFunction(type);
        }
    }

    private void addNvlFunction(String valueType) {
        FunctionMethod nvl = new FunctionMethod("nvl", Messages.getString(Messages.SystemSource.nvl_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "ifnull", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "value", valueType, Messages.getString(Messages.SystemSource.nvl_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "valueIfNull", valueType, Messages.getString(Messages.SystemSource.nvl_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", valueType, Messages.getString(Messages.SystemSource.nvl_result, new Object[0])));
        nvl.setNullOnNull(false);
        this.functions.add(nvl);
    }

    private void addIfNullFunction(String valueType) {
        FunctionMethod nvl = new FunctionMethod("ifnull", Messages.getString(Messages.SystemSource.ifnull_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "ifnull", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "value", valueType, Messages.getString(Messages.SystemSource.ifnull_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "valueIfNull", valueType, Messages.getString(Messages.SystemSource.ifnull_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", valueType, Messages.getString(Messages.SystemSource.ifnull_result, new Object[0])));
        nvl.setNullOnNull(false);
        this.functions.add(nvl);
    }

    private void addFormatTimestampFunction() {
        this.functions.add(new FunctionMethod("formattimestamp", Messages.getString(Messages.SystemSource.formattimestamp_description, new Object[0]), "Conversion", FUNCTION_CLASS, "format", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.formattimestamp_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.formattimestamp_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.formattimestamp_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.FORMATDATE.text(), Messages.getString(Messages.SystemSource.formatdate_description, new Object[0]), "Conversion", null, null, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "date", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.formatdate_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.formatdate_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.formatdate_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.FORMATTIME.text(), Messages.getString(Messages.SystemSource.formattime_description, new Object[0]), "Conversion", null, null, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "time", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.formattime_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.formattime_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.formattime_result_description, new Object[0]))));
    }

    private void addParseTimestampFunction() {
        this.functions.add(new FunctionMethod("parsetimestamp", Messages.getString(Messages.SystemSource.parsetimestamp_description, new Object[0]), "Conversion", FUNCTION_CLASS, "parseTimestamp", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.parsetimestamp_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.parsetimestamp_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.parsetimestamp_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.PARSETIME.text(), Messages.getString(Messages.SystemSource.parsetime_description, new Object[0]), "Conversion", null, null, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "time", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.parsetime_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.parsetime_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.parsetime_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.PARSEDATE.text(), Messages.getString(Messages.SystemSource.parsedate_description, new Object[0]), "Conversion", null, null, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "date", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.parsedate_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.parsedate_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.parsedate_result_description, new Object[0]))));
    }

    private void addFormatNumberFunction(String functionName, String description, String methodName, String inputParam, DataTypeManagerService.DefaultDataTypes dataType, String resultDesc) {
        this.addFormatNumberFunction(functionName, description, methodName, inputParam, dataType.getId(), resultDesc);
    }

    private void addFormatNumberFunction(String functionName, String description, String methodName, String inputParam, String dataType, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, inputParam, dataType, Messages.getString(Messages.SystemSource.formatnumber_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.formatnumber_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, resultDesc)));
    }

    private void addParseNumberFunction(String functionName, String description, String methodName, String inputParam, DataTypeManagerService.DefaultDataTypes dataType, String resultDesc) {
        this.addParseNumberFunction(functionName, description, methodName, inputParam, dataType.getId(), resultDesc);
    }

    private void addParseNumberFunction(String functionName, String description, String methodName, String inputParam, String dataType, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(this.teiidVersion, inputParam, DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.parsenumber_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.parsenumber_arg2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", dataType, resultDesc)));
    }

    private void addBitFunction(String functionName, String description, String methodName, int parameters, String resultDescription) {
        FunctionParameter[] paramArray = null;
        if (parameters == 1) {
            paramArray = new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "integer", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.bitfunc_arg1, new Object[0]))};
        } else if (parameters == 2) {
            paramArray = new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "integer1", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.bitfunc2_arg1, new Object[0])), new FunctionParameter(this.teiidVersion, "integer2", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.bitfunc2_arg2, new Object[0]))};
        }
        this.functions.add(new FunctionMethod(functionName, description, "Numeric", FUNCTION_CLASS, methodName, paramArray, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.INTEGER, resultDescription)));
    }

    private void addXpathValueFunction() {
        this.functions.add(new FunctionMethod("xpathvalue", Messages.getString(Messages.SystemSource.xpathvalue_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "document", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "xpath", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpathvalue_result, new Object[0]))));
        this.functions.add(new FunctionMethod("xpathvalue", Messages.getString(Messages.SystemSource.xpathvalue_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "document", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.xpath_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "xpath", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpathvalue_result, new Object[0]))));
        this.functions.add(new FunctionMethod("xpathvalue", Messages.getString(Messages.SystemSource.xpathvalue_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "document", DataTypeManagerService.DefaultDataTypes.BLOB, Messages.getString(Messages.SystemSource.xpath_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "xpath", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpathvalue_result, new Object[0]))));
        this.functions.add(new FunctionMethod("xpathvalue", Messages.getString(Messages.SystemSource.xpathvalue_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "document", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xpath_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "xpath", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpathvalue_result, new Object[0]))));
    }

    private void addXslTransformFunction() {
        for (DataTypeManagerService.DefaultDataTypes type1 : Arrays.asList(DataTypeManagerService.DefaultDataTypes.STRING, DataTypeManagerService.DefaultDataTypes.XML, DataTypeManagerService.DefaultDataTypes.CLOB)) {
            for (DataTypeManagerService.DefaultDataTypes type2 : Arrays.asList(DataTypeManagerService.DefaultDataTypes.STRING, DataTypeManagerService.DefaultDataTypes.XML, DataTypeManagerService.DefaultDataTypes.CLOB)) {
                this.functions.add(new FunctionMethod("xsltransform", Messages.getString(Messages.SystemSource.xsltransform_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xslTransform", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "document", type1, Messages.getString(Messages.SystemSource.xsltransform_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "xsl", type2, Messages.getString(Messages.SystemSource.xsltransform_param2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.xsltransform_result, new Object[0]))));
            }
        }
    }

    private void addXmlComment() {
        this.functions.add(new FunctionMethod("xmlcomment", Messages.getString(Messages.SystemSource.xmlcomment_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xmlComment", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "value", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xmlcomment_param1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlcomment_result, new Object[0]))));
    }

    private void addXmlPi() {
        this.functions.add(new FunctionMethod("xmlpi", Messages.getString(Messages.SystemSource.xmlpi_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xmlPi", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "name", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xmlpi_param1, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlpi_result, new Object[0]))));
        this.functions.add(new FunctionMethod("xmlpi", Messages.getString(Messages.SystemSource.xmlpi_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xmlPi", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "name", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xmlpi_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "value", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xmlpi_param2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlpi_result, new Object[0]))));
    }

    private void addJsonToXml() {
        this.functions.add(new FunctionMethod("jsontoxml", Messages.getString(Messages.SystemSource.jsontoxml_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "jsonToXml", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "rootElementName", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.jsontoxml_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "json", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.jsontoxml_param2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.jsontoxml_result, new Object[0]))));
        this.functions.add(new FunctionMethod("jsontoxml", Messages.getString(Messages.SystemSource.jsontoxml_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "jsonToXml", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "rootElementName", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.jsontoxml_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "json", DataTypeManagerService.DefaultDataTypes.BLOB, Messages.getString(Messages.SystemSource.jsontoxml_param2, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.jsontoxml_result, new Object[0]))));
    }

    private void addXmlConcat() {
        this.functions.add(new FunctionMethod("xmlconcat", Messages.getString(Messages.SystemSource.xmlconcat_description, new Object[0]), "XML", FunctionMethod.PushDown.CAN_PUSHDOWN, XML_FUNCTION_CLASS, "xmlConcat", Arrays.asList(new FunctionParameter(this.teiidVersion, "param1", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlconcat_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "param2", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlconcat_param2, new Object[0]), true)), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlconcat_result, new Object[0])), false, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addTimeZoneFunctions() {
        this.functions.add(new FunctionMethod("modifytimezone", Messages.getString(Messages.SystemSource.modifytimezone_description, new Object[0]), "Datetime", FUNCTION_CLASS, "modifyTimeZone", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.modifytimezone_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "startTimeZone", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.modifytimezone_param2, new Object[0])), new FunctionParameter(this.teiidVersion, "endTimeZone", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.modifytimezone_param3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.modifytimezone_result, new Object[0]))));
        this.functions.add(new FunctionMethod("modifytimezone", Messages.getString(Messages.SystemSource.modifytimezone_description, new Object[0]), "Datetime", FUNCTION_CLASS, "modifyTimeZone", new FunctionParameter[]{new FunctionParameter(this.teiidVersion, "timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.modifytimezone_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "endTimeZone", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.modifytimezone_param3, new Object[0]))}, new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.modifytimezone_result, new Object[0]))));
    }

    private void addUnixTimeFunctions() {
        this.functions.add(new FunctionMethod(IFunctionLibrary.FunctionName.FROM_UNIXTIME.text(), Messages.getString(Messages.SystemSource.from_unixtime_description, new Object[0]), "Datetime", FunctionMethod.PushDown.SYNTHETIC, null, null, Arrays.asList(new FunctionParameter(this.teiidVersion, "unix_timestamp", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.from_unixtime_param1, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.from_unixtime_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addTypedNullIfFunction(String type) {
        this.functions.add(new FunctionMethod(IFunctionLibrary.FunctionName.NULLIF.text(), Messages.getString(Messages.SystemSource.nullif_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.SYNTHETIC, null, null, Arrays.asList(new FunctionParameter(this.teiidVersion, "op1", type, Messages.getString(Messages.SystemSource.nullif_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "op2", type, Messages.getString(Messages.SystemSource.nullif_param1, new Object[0]))), new FunctionParameter(this.teiidVersion, "result", type, Messages.getString(Messages.SystemSource.nullif_result, new Object[0])), false, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addTypedCoalesceFunction(String type) {
        this.functions.add(new FunctionMethod(IFunctionLibrary.FunctionName.COALESCE.text(), Messages.getString(Messages.SystemSource.coalesce_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CAN_PUSHDOWN, FUNCTION_CLASS, "coalesce", Arrays.asList(new FunctionParameter(this.teiidVersion, "op1", type, Messages.getString(Messages.SystemSource.coalesce_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "op2", type, Messages.getString(Messages.SystemSource.coalesce_param1, new Object[0])), new FunctionParameter(this.teiidVersion, "op3", type, Messages.getString(Messages.SystemSource.coalesce_param1, new Object[0]), true)), new FunctionParameter(this.teiidVersion, "result", type, Messages.getString(Messages.SystemSource.coalesce_result, new Object[0])), false, FunctionMethod.Determinism.DETERMINISTIC));
    }

    public Collection<FunctionMethod> getFunctionMethods() {
        return this.functions;
    }

    public static FunctionMethod createSyntheticMethod(String name, String description, String category, String invocationClass, String invocationMethod, FunctionParameter[] inputParams, FunctionParameter outputParam) {
        return new FunctionMethod(name, description, category, FunctionMethod.PushDown.SYNTHETIC, invocationClass, invocationMethod, inputParams != null ? Arrays.asList(inputParams) : null, outputParam, false, FunctionMethod.Determinism.NONDETERMINISTIC);
    }
}

