/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.xml.IMappingBaseNode;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.parser.TeiidParser;
import org.teiid.runtime.client.Messages;

public abstract class MappingBaseNode
extends MappingNode
implements IMappingBaseNode<MappingNode> {
    String recursionId;

    protected MappingBaseNode(TeiidParser teiidParser) {
        super(teiidParser);
    }

    public void addChildNode(MappingNode childNode) {
        if (childNode instanceof MappingAllNode) {
            this.addAllNode((MappingAllNode)childNode);
        } else if (childNode instanceof MappingChoiceNode) {
            this.addChoiceNode((MappingChoiceNode)childNode);
        } else if (childNode instanceof MappingCriteriaNode) {
            this.addCriteriaNode((MappingCriteriaNode)childNode);
        } else if (childNode instanceof MappingElement) {
            this.addChildElement((MappingElement)childNode);
        } else if (childNode instanceof MappingSequenceNode) {
            this.addSequenceNode((MappingSequenceNode)childNode);
        } else if (childNode instanceof MappingSourceNode) {
            this.addSourceNode((MappingSourceNode)childNode);
        } else {
            throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID30457, childNode));
        }
    }

    public void setMinOccurrs(int cardinality) {
        this.setProperty(MappingNodeConstants.Properties.CARDINALITY_MIN_BOUND, new Integer(cardinality));
    }

    public void setMaxOccurrs(int cardinality) {
        this.setProperty(MappingNodeConstants.Properties.CARDINALITY_MAX_BOUND, new Integer(cardinality));
    }

    public void setSource(String source) {
        if (source != null) {
            this.setProperty(MappingNodeConstants.Properties.RESULT_SET_NAME, source);
        } else {
            this.removeProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
        }
    }

    public String getSource() {
        return (String)this.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
    }

    public void addChildElement(MappingElement elem) {
        if (elem.isRecursive()) {
            MappingRecursiveElement recursiveElement = (MappingRecursiveElement)elem;
            MappingBaseNode recursiveRoot = this.getRecursiveRootNode(recursiveElement);
            String mappingClass = recursiveElement.getMappingClass();
            ITeiidServerVersion minVersion = this.getTeiidVersion().getMinimumVersion();
            if (minVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0)) {
                mappingClass = mappingClass.toUpperCase();
            }
            recursiveRoot.setRootRecursiveNode(true, mappingClass);
            this.addChild(elem);
        } else {
            this.addChild(elem);
        }
    }

    private MappingBaseNode getRecursiveRootNode(MappingRecursiveElement elem) {
        if (this.hasSource(elem.getMappingClass())) {
            return this;
        }
        MappingBaseNode parent = this.getParentNode();
        if (parent != null) {
            return parent.getRecursiveRootNode(elem);
        }
        throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID30457, elem));
    }

    private boolean hasSource(String source) {
        return source.equals(this.getSource());
    }

    public void addChoiceNode(MappingChoiceNode elem) {
        this.addChild(elem);
    }

    public void addSequenceNode(MappingSequenceNode elem) {
        this.addChild(elem);
    }

    public void addAllNode(MappingAllNode elem) {
        this.addChild(elem);
    }

    public void addSourceNode(MappingSourceNode elem) {
        this.addChild(elem);
    }

    public void addCriteriaNode(MappingCriteriaNode node) {
        this.addChild(node);
    }

    public MappingBaseNode getParentNode() {
        if (this.getParent() instanceof MappingBaseNode) {
            return (MappingBaseNode)this.getParent();
        }
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public String getCanonicalName() {
        return this.getFullyQualifiedName().toUpperCase();
    }

    public void removeChildNode(MappingBaseNode toRemove) {
        this.getChildren().remove(toRemove);
    }

    public int getMinOccurence() {
        Integer occur = (Integer)this.getProperty(MappingNodeConstants.Properties.CARDINALITY_MIN_BOUND);
        if (occur != null) {
            return occur;
        }
        return 1;
    }

    public int getMaxOccurence() {
        Integer occur = (Integer)this.getProperty(MappingNodeConstants.Properties.CARDINALITY_MAX_BOUND);
        if (occur != null) {
            return occur;
        }
        return 1;
    }

    void setRootRecursiveNode(boolean root, String recursionId) {
        this.setProperty(MappingNodeConstants.Properties.IS_RECURSIVE_ROOT, root);
        this.recursionId = recursionId;
    }

    public String getRecursionId() {
        return this.recursionId;
    }

    public boolean isRootRecursiveNode() {
        return Boolean.TRUE.equals(this.getProperty(MappingNodeConstants.Properties.IS_RECURSIVE_ROOT));
    }

    public MappingDocument getDocument() {
        if (this.isDocumentNode()) {
            return (MappingDocument)this;
        }
        return this.getParentNode().getDocument();
    }

    public boolean isDocumentNode() {
        return false;
    }

    public boolean isTagRoot() {
        return false;
    }

    public List<String> getStagingTables() {
        return (List)this.getProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES);
    }

    public void setStagingTables(List<String> tables) {
        if (tables != null) {
            this.setProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES, tables);
        } else {
            this.removeProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES);
        }
    }

    public void addStagingTable(String tablename) {
        if (tablename == null) {
            return;
        }
        List<String> tables = this.getStagingTables();
        if (tables == null || tables.isEmpty()) {
            tables = new ArrayList<String>();
        }
        tables.add(tablename);
        this.setProperty(MappingNodeConstants.Properties.TEMP_GROUP_NAMES, tables);
    }

    @Override
    public MappingNode clone() {
        MappingBaseNode clone = (MappingBaseNode)super.clone();
        List<String> staging = this.getStagingTables();
        if (this.getStagingTables() != null && staging != MappingNodeConstants.Defaults.DEFAULT_VALUES.get((Object)MappingNodeConstants.Properties.TEMP_GROUP_NAMES)) {
            clone.setStagingTables(new ArrayList<String>(staging));
        }
        return clone;
    }
}

