/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.teiid.core.util.ArgCheck;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.xml.IMappingDocument;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingOutputter;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.runtime.client.Messages;

public class MappingDocument
extends MappingBaseNode
implements IMappingDocument<MappingNode> {
    MappingBaseNode root;
    boolean formatted;
    String encoding;
    String name;

    public MappingDocument(TeiidParser teiidParser, boolean formatted) {
        this(teiidParser, "UTF-8", formatted);
    }

    public MappingDocument(TeiidParser teiidParser, String encoding, boolean formatted) {
        super(teiidParser);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.setDocumentEncoding(encoding);
        this.setFormatted(formatted);
    }

    @Override
    public void acceptVisitor(MappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.name;
    }

    @Override
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public String getCanonicalName() {
        return this.name.toUpperCase();
    }

    public MappingBaseNode getRootNode() {
        return this.root;
    }

    public MappingElement getTagRootElement() {
        if (this.root instanceof MappingSourceNode) {
            return (MappingElement)this.root.getNodeChildren().get(0);
        }
        return (MappingElement)this.root;
    }

    void setRoot(MappingBaseNode root) {
        if (root != null) {
            this.root = root;
            this.getChildren().clear();
            this.addChild(root);
        }
    }

    public String getDocumentEncoding() {
        return this.encoding;
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    @Override
    public boolean isDocumentNode() {
        return true;
    }

    public void setDocumentEncoding(String encoding) {
        this.encoding = encoding;
        this.setProperty(MappingNodeConstants.Properties.DOCUMENT_ENCODING, this.encoding);
    }

    public void setFormatted(boolean formatted) {
        this.formatted = formatted;
        this.setProperty(MappingNodeConstants.Properties.FORMATTED_DOCUMENT, this.formatted);
    }

    private void fixCardinality(MappingElement root) {
        root.setMaxOccurrs(1);
        root.setMinOccurrs(1);
    }

    @Override
    public void addAllNode(MappingAllNode elem) {
        throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID30452, new Object[0]));
    }

    @Override
    public void addChoiceNode(MappingChoiceNode elem) {
        throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID30452, new Object[0]));
    }

    @Override
    public void addSequenceNode(MappingSequenceNode elem) {
        throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID30452, new Object[0]));
    }

    @Override
    public void addChildElement(MappingElement elem) {
        ArgCheck.isNotNull(elem);
        this.fixCardinality(elem);
        this.setRoot(elem);
    }

    @Override
    public void addSourceNode(MappingSourceNode elem) {
        ArgCheck.isNotNull(elem);
        this.setRoot(elem);
    }

    @Override
    public MappingDocument clone() {
        MappingDocument clone = (MappingDocument)super.clone();
        clone.root = (MappingBaseNode)clone.getChildren().iterator().next();
        return clone;
    }

    public String getMappingString() throws Exception {
        String result = null;
        ByteArrayOutputStream moStream = null;
        try {
            moStream = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(moStream, true);
            MappingOutputter outputter = new MappingOutputter();
            outputter.write(this, pw);
            pw.flush();
            result = ((Object)moStream).toString();
        }
        finally {
            if (moStream != null) {
                ((OutputStream)moStream).close();
                moStream = null;
            }
        }
        return result;
    }
}

