/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.validator.IValidator;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.report.ActivityReport;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.query.SyntaxFactory;

public class MetadataValidator {
    public static final String MATVIEW_TTL = "{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL";
    private final ITeiidServerVersion teiidVersion;
    private final QueryParser queryParser;
    private Map<String, Datatype> typeMap;

    public MetadataValidator(ITeiidServerVersion teiidVersion, Map<String, Datatype> typeMap) {
        this.teiidVersion = teiidVersion;
        this.typeMap = typeMap;
        this.queryParser = new QueryParser(teiidVersion);
    }

    public MetadataValidator(ITeiidServerVersion teiidVersion) {
        this(teiidVersion, SystemMetadata.getInstance(teiidVersion).getRuntimeTypeMap());
    }

    private boolean isTeiidOrGreater(TeiidServerVersion.Version version) {
        return this.teiidVersion.isGreaterThanOrEqualTo(version.get());
    }

    private <T extends LanguageObject> T createASTNode(TeiidNodeFactory.ASTNodes nodeType) {
        return this.queryParser.getTeiidParser().createASTNode(nodeType);
    }

    public ValidatorReport validate(VDBMetaData vdb, MetadataStore store) {
        ValidatorReport report = new ValidatorReport();
        if (store != null && !store.getSchemaList().isEmpty()) {
            new SourceModelArtifacts().execute(vdb, store, report, this);
            new CrossSchemaResolver().execute(vdb, store, report, this);
            new ResolveQueryPlans().execute(vdb, store, report, this);
            new MinimalMetadata().execute(vdb, store, report, this);
        }
        return report;
    }

    public void log(ValidatorReport report, ModelMetaData model, String msg) {
        this.log(report, model, ModelMetaData.Message.Severity.ERROR, msg);
    }

    public void log(ValidatorReport report, ModelMetaData model, ModelMetaData.Message.Severity severity, String msg) {
        model.addRuntimeMessage(severity, msg);
        if (severity == ModelMetaData.Message.Severity.ERROR) {
            report.handleValidationError(msg);
        } else {
            report.handleValidationWarning(msg);
        }
    }

    private void validate(VDBMetaData vdb, ModelMetaData model, AbstractMetadataRecord record, ValidatorReport report, IQueryMetadataInterface metadata, MetadataFactory mf) {
        ActivityReport resolverReport = null;
        try {
            if (record instanceof Procedure) {
                Procedure p = (Procedure)record;
                Command command = this.queryParser.parseProcedure(p.getQueryPlan(), false);
                GroupSymbol gs = (GroupSymbol)this.createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
                gs.setName(p.getFullName());
                QueryResolver resolver = new QueryResolver(this.queryParser);
                resolver.resolveCommand(command, gs, 6, metadata, false);
                Validator validator = new Validator();
                resolverReport = validator.validate(command, metadata);
                MetadataValidator.determineDependencies(p, command);
            } else if (record instanceof Table) {
                QueryResolver resolver;
                boolean considerColumns_8124;
                Table t = (Table)record;
                GroupSymbol symbol = (GroupSymbol)this.createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
                symbol.setName(t.getFullName());
                ResolverUtil.resolveGroup(symbol, metadata);
                String selectTransformation = t.getSelectTransformation();
                boolean columnsIsEmpty = t.getColumns() == null || t.getColumns().isEmpty();
                boolean considerColumns_811 = this.isTeiidOrGreater(TeiidServerVersion.Version.TEIID_8_12_4) ? true : columnsIsEmpty;
                boolean bl = considerColumns_8124 = this.isTeiidOrGreater(TeiidServerVersion.Version.TEIID_8_12_4) ? columnsIsEmpty : true;
                if (t.isVirtual() && considerColumns_811) {
                    QueryCommand command = (QueryCommand)this.queryParser.parseCommand(selectTransformation);
                    resolver = new QueryResolver(this.queryParser);
                    resolver.resolveCommand(command, metadata);
                    Validator validator = new Validator();
                    resolverReport = validator.validate(command, metadata);
                    if (!resolverReport.hasItems() && considerColumns_8124) {
                        List symbols = command.getProjectedSymbols();
                        for (Object column : symbols) {
                            try {
                                this.addColumn(Symbol.getShortName((Expression)column), column.getType(), t, mf);
                            }
                            catch (Exception e) {
                                this.log(report, model, e.getMessage());
                            }
                        }
                    }
                    if (considerColumns_8124) {
                        MetadataValidator.determineDependencies(t, command);
                        if (t.getInsertPlan() != null && t.isInsertPlanEnabled()) {
                            this.validateUpdatePlan(model, report, metadata, t, t.getInsertPlan(), 2);
                        }
                        if (t.getUpdatePlan() != null && t.isUpdatePlanEnabled()) {
                            this.validateUpdatePlan(model, report, metadata, t, t.getUpdatePlan(), 3);
                        }
                        if (t.getDeletePlan() != null && t.isDeletePlanEnabled()) {
                            this.validateUpdatePlan(model, report, metadata, t, t.getDeletePlan(), 4);
                        }
                    }
                }
                boolean addCacheHint = false;
                if (t.isMaterialized() && t.getMaterializedTable() == null) {
                    List<KeyRecord> fbis = t.getFunctionBasedIndexes();
                    List<GroupSymbol> groups = Arrays.asList(symbol);
                    if (fbis != null && !fbis.isEmpty()) {
                        for (KeyRecord fbi : fbis) {
                            int j = 0;
                            while (j < fbi.getColumns().size()) {
                                Column c = fbi.getColumns().get(j);
                                if (c.getParent() == fbi) {
                                    String exprString = c.getNameInSource();
                                    try {
                                        Expression ex = this.queryParser.parseExpression(exprString);
                                        ResolverVisitor resolverVisitor = new ResolverVisitor(this.teiidVersion);
                                        resolverVisitor.resolveLanguageObject(ex, groups, metadata);
                                        if (!ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ex).isEmpty()) {
                                            this.log(report, model, Messages.gs(Messages.TEIID.TEIID31114, exprString, fbi.getFullName()));
                                        }
                                        EvaluatableVisitor ev = new EvaluatableVisitor(this.teiidVersion);
                                        PreOrPostOrderNavigator.doVisit(ex, ev, true);
                                        if (ev.getDeterminismLevel().compareTo(FunctionMethod.Determinism.VDB_DETERMINISTIC) < 0) {
                                            this.log(report, model, Messages.gs(Messages.TEIID.TEIID31115, exprString, fbi.getFullName()));
                                        }
                                    }
                                    catch (QueryResolverException e) {
                                        this.log(report, model, Messages.gs(Messages.TEIID.TEIID31116, exprString, fbi.getFullName(), e.getMessage()));
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                } else {
                    addCacheHint = true;
                }
                resolver = new QueryResolver(this.queryParser);
                QueryNode node = resolver.resolveView(symbol, new QueryNode(t.getSelectTransformation()), "SELECT", metadata);
                CacheHint cacheHint = node.getCommand().getCacheHint();
                Long ttl = -1L;
                if (cacheHint != null && cacheHint.getTtl() != null && addCacheHint && t.getProperty(MATVIEW_TTL, false) == null) {
                    ttl = cacheHint.getTtl();
                    t.setProperty(MATVIEW_TTL, String.valueOf(ttl));
                }
            }
            if (resolverReport != null && resolverReport.hasItems()) {
                for (ValidatorFailure v : ((ValidatorReport)resolverReport).getItems()) {
                    this.log(report, model, v.getStatus() == IValidator.IValidatorFailure.VFStatus.ERROR ? ModelMetaData.Message.Severity.ERROR : ModelMetaData.Message.Severity.WARNING, v.getMessage());
                }
            }
            this.processReport(model, record, report, (ValidatorReport)resolverReport);
        }
        catch (Exception e) {
            this.log(report, model, Messages.gs(Messages.TEIID.TEIID31080, record.getFullName(), e.getMessage()));
        }
    }

    public static void determineDependencies(AbstractMetadataRecord p, Command command) {
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroupsIgnoreInlineViewsAndEvaluatableSubqueries(command, true);
        LinkedHashSet<AbstractMetadataRecord> values = new LinkedHashSet<AbstractMetadataRecord>();
        for (GroupSymbol group : groups) {
            Object mid = group.getMetadataID();
            if (mid instanceof TempMetadataAdapter) {
                mid = ((TempMetadataID)mid).getOriginalMetadataID();
            }
            if (!(mid instanceof AbstractMetadataRecord)) continue;
            values.add((AbstractMetadataRecord)mid);
        }
        Collection<ElementSymbol> elems = ElementCollectorVisitor.getElements(command, true, true);
        for (ElementSymbol elem : elems) {
            Object mid = elem.getMetadataID();
            if (mid instanceof TempMetadataAdapter) {
                mid = ((TempMetadataID)mid).getOriginalMetadataID();
            }
            if (!(mid instanceof AbstractMetadataRecord)) continue;
            values.add((AbstractMetadataRecord)mid);
        }
        p.setIncomingObjects(new ArrayList<AbstractMetadataRecord>(values));
    }

    private void validateUpdatePlan(ModelMetaData model, ValidatorReport report, IQueryMetadataInterface metadata, Table t, String plan, int type) throws Exception {
        Command command = null;
        QueryResolver queryResolver = new QueryResolver(this.queryParser);
        if (this.isTeiidOrGreater(TeiidServerVersion.Version.TEIID_8_12_4)) {
            command = this.queryParser.parseProcedure(plan, true);
            SyntaxFactory factory = new SyntaxFactory(this.queryParser.getTeiidParser());
            IGroupSymbol groupSymbol = factory.createGroupSymbol(t.getFullName());
            queryResolver.resolveCommand(command, (GroupSymbol)groupSymbol, type, metadata, false);
        } else {
            command = this.queryParser.parseCommand(plan);
            queryResolver.resolveCommand(command, metadata);
        }
        ValidatorReport resolverReport = new Validator().validate(command, metadata);
        this.processReport(model, t, report, resolverReport);
    }

    private void processReport(ModelMetaData model, AbstractMetadataRecord record, ValidatorReport report, ValidatorReport resolverReport) {
        if (resolverReport != null && resolverReport.hasItems()) {
            for (ValidatorFailure v : resolverReport.getItems()) {
                this.log(report, model, v.getStatus() == IValidator.IValidatorFailure.VFStatus.ERROR ? ModelMetaData.Message.Severity.ERROR : ModelMetaData.Message.Severity.WARNING, v.getMessage());
            }
        }
    }

    private Column addColumn(String name, Class<?> type, Table table, MetadataFactory mf) throws Exception {
        if (type == null) {
            throw new Exception(Messages.gs(Messages.TEIID.TEIID31086, name, table.getFullName()));
        }
        Column column = mf.addColumn(name, DataTypeManagerService.getInstance(this.teiidVersion).getDataTypeName(type), table);
        column.setUpdatable(table.supportsUpdate());
        return column;
    }

    static class CrossSchemaResolver
    implements MetadataRule {
        CrossSchemaResolver() {
        }

        private boolean keyMatches(List<String> names, KeyRecord record) {
            if (names.size() != record.getColumns().size()) {
                return false;
            }
            TreeSet<String> keyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Column c : record.getColumns()) {
                keyNames.add(c.getName());
            }
            int i = 0;
            while (i < names.size()) {
                if (!keyNames.contains(names.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (t.isVirtual() && t.isMaterialized() && t.getMaterializedTable() != null) {
                        String matTableName = t.getMaterializedTable().getFullName();
                        int index = matTableName.indexOf(46);
                        if (index == -1) {
                            metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31088, matTableName, t.getFullName()));
                        } else {
                            String schemaName = matTableName.substring(0, index);
                            Schema matSchema = store.getSchema(schemaName);
                            if (matSchema == null) {
                                metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31089, schemaName, matTableName, t.getFullName()));
                            } else {
                                Table matTable = matSchema.getTable(matTableName.substring(index + 1));
                                if (matTable == null) {
                                    metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31090, matTableName.substring(index + 1), schemaName, t.getFullName()));
                                } else {
                                    t.setMaterializedTable(matTable);
                                }
                            }
                        }
                    }
                    for (KeyRecord record : t.getAllKeys()) {
                        if (record.getColumns() != null && !record.getColumns().isEmpty()) continue;
                        metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31149, t.getFullName(), record.getName()));
                    }
                    List<ForeignKey> fks = t.getForeignKeys();
                    if (fks == null || fks.isEmpty()) continue;
                    for (ForeignKey fk : fks) {
                        if (fk.getReferenceKey() != null && !metadataValidator.isTeiidOrGreater(TeiidServerVersion.Version.TEIID_8_9)) {
                            fk.setReferenceKey(fk.getReferenceKey());
                            continue;
                        }
                        String referenceTableName = fk.getReferenceTableName();
                        Table referenceTable = null;
                        if (fk.getReferenceKey() == null) {
                            if (referenceTableName == null) {
                                metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31091, t.getFullName()));
                                continue;
                            }
                            referenceTable = schema.getTable(referenceTableName);
                        } else {
                            referenceTableName = ((Table)fk.getReferenceKey().getParent()).getFullName();
                        }
                        String referenceSchemaName = schema.getName();
                        int index = referenceTableName.indexOf(46);
                        if (referenceTable == null) {
                            if (index != -1) {
                                referenceSchemaName = referenceTableName.substring(0, index);
                                Schema referenceSchema = store.getSchema(referenceSchemaName);
                                if (referenceSchema == null) {
                                    metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31093, referenceSchemaName, t.getFullName()));
                                    continue;
                                }
                                referenceTable = referenceSchema.getTable(referenceTableName.substring(index + 1));
                            }
                            if (referenceTable == null) {
                                metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31092, t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName));
                                continue;
                            }
                        }
                        KeyRecord uniqueKey = null;
                        List<String> referenceColumns = fk.getReferenceColumns();
                        if (fk.getReferenceKey() != null) {
                            List<Column> cols = fk.getReferenceKey().getColumns();
                            referenceColumns = new ArrayList<String>();
                            for (Column col : cols) {
                                referenceColumns.add(col.getName());
                            }
                        }
                        if (referenceColumns == null || referenceColumns.isEmpty()) {
                            if (referenceTable.getPrimaryKey() == null) {
                                metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31094, t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName));
                            } else {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                        } else {
                            for (KeyRecord record : referenceTable.getUniqueKeys()) {
                                if (!this.keyMatches(fk.getReferenceColumns(), record)) continue;
                                uniqueKey = record;
                                break;
                            }
                            if (uniqueKey == null && referenceTable.getPrimaryKey() != null && this.keyMatches(fk.getReferenceColumns(), referenceTable.getPrimaryKey())) {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                        }
                        if (uniqueKey == null) {
                            metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31095, t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName, fk.getReferenceColumns()));
                            continue;
                        }
                        fk.setReferenceKey(uniqueKey);
                    }
                }
            }
        }
    }

    static interface MetadataRule {
        public void execute(VDBMetaData var1, MetadataStore var2, ValidatorReport var3, MetadataValidator var4);
    }

    class MinimalMetadata
    implements MetadataRule {
        MinimalMetadata() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                if (schema.getTables().isEmpty() && schema.getProcedures().isEmpty() && schema.getFunctions().isEmpty()) {
                    metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31070, model.getName()));
                }
                for (Table t : schema.getTables().values()) {
                    if (t.getColumns() == null || t.getColumns().size() == 0) {
                        metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31071, t.getFullName()));
                    }
                    TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    this.validateConstraintNames(metadataValidator, report, model, t.getAllKeys(), names);
                    this.validateConstraintNames(metadataValidator, report, model, t.getFunctionBasedIndexes(), names);
                }
                if (schema.getFunctions().isEmpty()) continue;
                ActivityReport funcReport = new ActivityReport("Translator metadata load " + model.getName());
                FunctionMetadataValidator.validateFunctionMethods(MetadataValidator.this.teiidVersion, schema.getFunctions().values(), report);
                if (!report.hasItems()) continue;
                metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31073, funcReport));
            }
        }

        private void validateConstraintNames(MetadataValidator metadataValidator, ValidatorReport report, ModelMetaData model, Collection<KeyRecord> keys, Set<String> names) {
            for (KeyRecord record : keys) {
                if (record.getName() == null || names.add(record.getName())) continue;
                metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31152, record.getFullName()));
            }
        }
    }

    class ResolveQueryPlans
    implements MetadataRule {
        ResolveQueryPlans() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            IQueryMetadataInterface metadata = vdb.getAttachment(IQueryMetadataInterface.class);
            metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                MetadataFactory mf = new MetadataFactory(MetadataValidator.this.teiidVersion, vdb.getName(), vdb.getVersion(), metadataValidator.typeMap, model){

                    @Override
                    protected void setUUID(AbstractMetadataRecord record) {
                        if (this.count >= 0) {
                            this.count = Integer.MIN_VALUE;
                        }
                        super.setUUID(record);
                    }
                };
                mf.setBuiltinDataTypes(store.getDatatypes());
                for (AbstractMetadataRecord record : schema.getResolvingOrder()) {
                    if (record instanceof Table) {
                        Table t = (Table)record;
                        if (t.getTableType() == Table.Type.Document || t.getTableType() == Table.Type.XmlMappingClass || t.getTableType() == Table.Type.XmlStagingTable || !t.isVirtual() || t.getTableType() == Table.Type.TemporaryTable) continue;
                        if (t.getSelectTransformation() == null) {
                            metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31079, t.getFullName(), model.getName()));
                            continue;
                        }
                        metadataValidator.validate(vdb, model, t, report, metadata, mf);
                        continue;
                    }
                    if (!(record instanceof Procedure)) continue;
                    Procedure p = (Procedure)record;
                    boolean test = p.isVirtual();
                    if (MetadataValidator.this.teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_11)) {
                        boolean bl = test = test && !p.isFunction();
                    }
                    if (!test) continue;
                    if (p.getQueryPlan() == null) {
                        metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31081, p.getFullName(), model.getName()));
                        continue;
                    }
                    metadataValidator.validate(vdb, model, p, report, metadata, mf);
                }
            }
        }
    }

    class SourceModelArtifacts
    implements MetadataRule {
        SourceModelArtifacts() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (!t.isPhysical() || model.isSource()) continue;
                    metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31075, t.getFullName(), model.getName()));
                }
                HashSet<String> names = new HashSet<String>();
                for (Procedure p : schema.getProcedures().values()) {
                    boolean hasReturn = false;
                    names.clear();
                    int i = 0;
                    while (i < p.getParameters().size()) {
                        ProcedureParameter param = p.getParameters().get(i);
                        if (param.isVarArg() && param != p.getParameters().get(p.getParameters().size() - 1)) {
                            if (MetadataValidator.this.isTeiidOrGreater(TeiidServerVersion.Version.TEIID_8_10)) {
                                int j = i + 1;
                                while (j < p.getParameters().size()) {
                                    ProcedureParameter param1 = p.getParameters().get(j);
                                    if ((param1.getType() == ProcedureParameter.Type.In || param1.getType() == ProcedureParameter.Type.InOut) && (param1.isVarArg() || param1.getNullType() != BaseColumn.NullType.Nullable && param1.getDefaultValue() == null)) {
                                        metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31112, p.getFullName()));
                                    }
                                    ++j;
                                }
                            } else {
                                metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31112, p.getFullName()));
                            }
                        }
                        if (param.getType() == ProcedureParameter.Type.ReturnValue) {
                            if (hasReturn) {
                                metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31107, p.getFullName()));
                            }
                            hasReturn = true;
                        } else if (p.isFunction() && param.getType() != ProcedureParameter.Type.In && MetadataValidator.this.teiidVersion.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_11)) {
                            metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31165, p.getFullName(), param.getFullName()));
                        }
                        if (!names.add(param.getName())) {
                            metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31106, p.getFullName(), param.getFullName()));
                        }
                        ++i;
                    }
                    if (!p.isVirtual() && !model.isSource()) {
                        metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31077, p.getFullName(), model.getName()));
                    }
                    if (!p.isFunction() || !MetadataValidator.this.teiidVersion.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_11)) continue;
                    if (!hasReturn) {
                        metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31166, p.getFullName()));
                    }
                    if (!p.isVirtual() || p.getQueryPlan() != null) continue;
                    metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31167, p.getFullName()));
                }
                for (FunctionMethod func : schema.getFunctions().values()) {
                    for (FunctionParameter param : func.getInputParameters()) {
                        if (!param.isVarArg() || param == func.getInputParameters().get(func.getInputParameterCount() - 1)) continue;
                        metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31112, func.getFullName()));
                    }
                    if (!func.getPushdown().equals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN) || model.isSource()) continue;
                    metadataValidator.log(report, model, Messages.gs(Messages.TEIID.TEIID31078, func.getFullName(), model.getName()));
                }
            }
        }
    }
}

