/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.proc.wsdl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.teiid.designer.query.proc.wsdl.IWsdlAttributeInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlColumnInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlConstants;
import org.teiid.designer.query.proc.wsdl.IWsdlRequestInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlWrapperInfo;
import org.teiid.designer.query.proc.wsdl.model.IMessage;
import org.teiid.designer.query.proc.wsdl.model.IPart;
import org.teiid.designer.query.sql.ISQLConstants;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.proc.wsdl.AbstractWsdlHelper;

public class WsdlRequestProcedureHelper
extends AbstractWsdlHelper
implements IWsdlConstants,
ISQLConstants {
    private final IWsdlRequestInfo requestInfo;
    private final Properties properties;
    private static final String NSSTRING = "nsString";
    private static final String NS = "ns";
    private static final String NSPREFIX = "prefix";

    public WsdlRequestProcedureHelper(ITeiidServerVersion teiidVersion, IWsdlRequestInfo requestInfo, Properties properties) {
        super(teiidVersion);
        this.requestInfo = requestInfo;
        this.properties = properties;
    }

    private IWsdlWrapperInfo getWrapperProcedure() {
        return this.requestInfo.getWrapperProcedure();
    }

    private String getFullParameterName(String procedureName, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getWrapperProcedure().getViewModelName());
        builder.append('.').append(procedureName).append('.').append(this.convertSqlNameSegment(name));
        return builder.toString();
    }

    private String getPartElementName(IPart part) {
        String partElementName = null;
        partElementName = part.getTypeName();
        if (partElementName == null) {
            partElementName = part.getElementName();
        }
        return partElementName;
    }

    private void addAttributesForElement(StringBuffer sb, IWsdlColumnInfo columnInfo) {
        if (columnInfo.getAttributeInfoArray().length > 0) {
            sb.append(",").append("\n").append("\t").append("\t").append("\t").append("\t").append("XMLATTRIBUTES");
            sb.append("(");
            int index = 0;
            IWsdlAttributeInfo[] iWsdlAttributeInfoArray = columnInfo.getAttributeInfoArray();
            int n = iWsdlAttributeInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWsdlAttributeInfo attrInfo = iWsdlAttributeInfoArray[n2];
                if (index > 0) {
                    sb.append(",").append(" ");
                }
                sb.append(attrInfo.getSymbolName());
                if (!attrInfo.getSymbolName().equalsIgnoreCase(attrInfo.getAlias())) {
                    sb.append(" ").append("AS").append(" ");
                    sb.append(attrInfo.getAlias());
                }
                ++index;
                ++n2;
            }
            sb.append(")");
        }
    }

    private String getHeaderString() {
        StringBuilder headerString = new StringBuilder();
        if (this.requestInfo.isMessageServiceMode()) {
            headerString.append("XMLELEMENT").append("(").append("NAME").append(" ").append("\"").append("soap:Envelope").append("\"").append(",");
            headerString.append(" ").append("XMLNAMESPACES").append("(").append("'").append("http://schemas.xmlsoap.org/soap/envelope/").append("'").append(" ").append("AS").append(" ");
            headerString.append("soap");
            if (this.requestInfo.getNamespaceMap().size() > 0 || this.getWrapperProcedure().getNamespaceURI() != null && !this.getWrapperProcedure().getNamespaceURI().isEmpty()) {
                String prefix = (String)this.requestInfo.getReverseNSMap().get(this.getWrapperProcedure().getNamespaceURI());
                if (this.isDefaultNS(prefix)) {
                    headerString.append(",").append(" ").append("DEFAULT").append(" ").append("'").append(this.getWrapperProcedure().getNamespaceURI());
                    headerString.append("'");
                } else {
                    headerString.append(",").append(" ").append("'").append(this.getWrapperProcedure().getNamespaceURI()).append("'").append(" ").append("AS").append(" ");
                    headerString.append(prefix);
                }
                for (Map.Entry entry : this.requestInfo.getNamespaceMap().entrySet()) {
                    if (((String)entry.getValue()).equals(this.getWrapperProcedure().getNamespaceURI())) break;
                    prefix = (String)this.requestInfo.getReverseNSMap().get(entry.getValue());
                    if (this.isDefaultNS(prefix)) {
                        headerString.append(",").append(" ").append("DEFAULT").append(" ").append("'").append((String)entry.getValue());
                        continue;
                    }
                    headerString.append(",").append(" ").append("'").append((String)entry.getValue()).append("'").append(" ").append("AS").append(" ");
                    headerString.append(prefix);
                }
            }
            headerString.append(")").append(",").append(" ").append("XMLELEMENT").append("(").append("NAME").append(" ");
            headerString.append("\"").append("soap:Header").append("\"");
            IWsdlColumnInfo[] iWsdlColumnInfoArray = this.requestInfo.getHeaderColumnInfoList();
            int n = iWsdlColumnInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWsdlColumnInfo columnInfo = iWsdlColumnInfoArray[n2];
                headerString.append(",").append(" ").append("XMLELEMENT").append("(").append("NAME").append(" ").append(columnInfo.getSymbolName());
                headerString.append(",").append(" ").append(this.getFullParameterName(this.requestInfo.getProcedureName(), columnInfo.getSymbolName()));
                headerString.append(")");
                ++n2;
            }
            headerString.append(")").append(",").append(" ");
            headerString.append("XMLELEMENT").append("(").append("NAME").append(" ").append("\"").append("soap:Body").append("\"").append(",");
        }
        return headerString.toString();
    }

    private boolean isDefaultNS(String prefix) {
        return prefix != null && prefix.trim().length() == 0;
    }

    private String getPartElementNamespace(IPart part) {
        String partElementNamespace = null;
        partElementNamespace = part.getTypeNamespace();
        if (partElementNamespace == null) {
            partElementNamespace = part.getElementNamespace();
        }
        return partElementNamespace;
    }

    private Map<String, String> getNamespaceString(IPart[] parts) {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        String ns = null;
        String nsPrefix = null;
        if (this.getWrapperProcedure().getNamespaceURI() == null) {
            return nsMap;
        }
        if (parts != null && parts.length == 1) {
            ns = this.getPartElementNamespace(parts[0]);
        }
        if (ns == null) {
            ns = this.getWrapperProcedure().getNamespaceURI();
        }
        StringBuffer sb = new StringBuffer();
        nsPrefix = (String)this.requestInfo.getReverseNSMap().get(ns);
        nsMap.put(NS, ns);
        nsMap.put(NSPREFIX, nsPrefix);
        if (this.isDefaultNS(nsPrefix)) {
            sb.append("DEFAULT").append(" ").append("'").append(ns).append("'");
        } else {
            sb.append("XMLNAMESPACES").append("(");
            sb.append(" ").append("'").append(this.getWrapperProcedure().getNamespaceURI()).append("'").append(" ").append("AS").append(" ");
            sb.append(nsPrefix);
        }
        sb.append(")");
        nsMap.put(NSSTRING, sb.toString());
        return nsMap;
    }

    public String getSQLStatement() {
        int nColumns;
        Map<String, String> nsMap;
        String requestProcedureName = this.properties.getProperty("requestProcedureName");
        if (requestProcedureName == null) {
            requestProcedureName = this.requestInfo.getProcedureName();
        }
        String alias = "xml_out";
        StringBuffer sb = new StringBuffer();
        int i = 0;
        sb.append("BEGIN\n");
        sb.append("\t").append("SELECT").append("\n");
        String header = this.getHeaderString();
        if (header.length() > 0) {
            sb.append("\t").append("\t").append(header).append("\n");
        }
        sb.append("\t").append("\t").append("XMLELEMENT");
        sb.append("(");
        sb.append("NAME").append(" ");
        String elementName = null;
        IMessage message = null;
        IPart[] parts = null;
        if (!this.requestInfo.isMessageServiceMode() && (parts = (message = this.requestInfo.getOperation().getInputMessage()).getParts()).length > 0) {
            elementName = this.getPartElementName(parts[0]);
        }
        if (elementName == null) {
            elementName = this.requestInfo.getOperation().getName();
        }
        if ((nsMap = this.getNamespaceString(parts)) == null) {
            nsMap = new HashMap<String, String>();
        }
        String nsString = nsMap.get(NSSTRING);
        String nsPrefix = nsMap.get(NSPREFIX);
        if (nsPrefix != null && !this.isDefaultNS(nsPrefix)) {
            sb.append("\"" + nsPrefix + ":" + elementName + "\"").append(",").append(" ");
        } else {
            sb.append(this.convertSqlNameSegment(elementName)).append(",").append(" ");
        }
        if (!this.requestInfo.isMessageServiceMode() && nsString != null && !nsString.isEmpty()) {
            sb.append(nsString);
        }
        if ((nColumns = this.requestInfo.getBodyColumnInfoList().length) > 0 && !this.requestInfo.isMessageServiceMode()) {
            sb.append(",");
        }
        sb.append(" ").append("\n");
        IWsdlColumnInfo[] iWsdlColumnInfoArray = this.requestInfo.getBodyColumnInfoList();
        int n = iWsdlColumnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWsdlColumnInfo columnInfo = iWsdlColumnInfoArray[n2];
            String name = columnInfo.getSymbolName();
            String convertedName = this.convertSqlNameSegment(name);
            Object nsPrefixObject = this.requestInfo.getReverseNSMap().get(columnInfo.getNamespace());
            if (nsPrefixObject != null) {
                convertedName = "\"".concat((String)nsPrefixObject).concat(":").concat(convertedName).concat("\"");
            }
            sb.append("\t").append("\t").append("\t").append("XMLELEMENT");
            sb.append("(");
            sb.append("NAME").append(" ").append(convertedName);
            if (columnInfo.getNamespace() == null) {
                sb.append(",").append(" ").append("XMLNAMESPACES").append("(").append("NO DEFAULT").append(")");
            }
            if (columnInfo.getAttributeInfoArray().length == 0) {
                sb.append(",").append(" ").append(this.getFullParameterName(requestProcedureName, name));
            }
            this.addAttributesForElement(sb, columnInfo);
            sb.append(")");
            if (i < nColumns - 1) {
                sb.append(",").append(" ").append("\n");
            }
            ++i;
            ++n2;
        }
        sb.append(")");
        if (this.requestInfo.isMessageServiceMode()) {
            sb.append(")").append(")");
        }
        sb.append(" ").append("AS").append(" ").append(alias).append(";");
        sb.append("\nEND");
        return sb.toString();
    }
}

