/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.proc.wsdl;

import java.util.Map;
import java.util.Properties;
import org.teiid.designer.query.proc.wsdl.IWsdlColumnInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlConstants;
import org.teiid.designer.query.proc.wsdl.IWsdlResponseInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlWrapperInfo;
import org.teiid.designer.query.sql.ISQLConstants;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.proc.wsdl.AbstractWsdlHelper;

public class WsdlResponseProcedureHelper
extends AbstractWsdlHelper
implements IWsdlConstants,
ISQLConstants {
    private final IWsdlResponseInfo responseInfo;
    private final Properties properties;

    public WsdlResponseProcedureHelper(ITeiidServerVersion teiidVersion, IWsdlResponseInfo responseInfo, Properties properties) {
        super(teiidVersion);
        this.responseInfo = responseInfo;
        this.properties = properties;
    }

    private IWsdlWrapperInfo getWrapperProcedure() {
        return this.responseInfo.getWrapperProcedure();
    }

    private String getXmlTableString() {
        String responseProcedureName = this.properties.getProperty("responseProcedureName");
        if (responseProcedureName == null) {
            responseProcedureName = this.responseInfo.getProcedureName();
        }
        StringBuilder sb = new StringBuilder();
        String namespaceStr = this.getNamespaceString();
        if (namespaceStr != null) {
            sb.append(namespaceStr);
        }
        String xQueryExp = "/";
        String rootPath = this.responseInfo.getRootPath();
        if (rootPath != null && rootPath.length() > 0) {
            xQueryExp = rootPath;
        }
        sb.append("'").append(xQueryExp).append("'").append(" ");
        sb.append("PASSING").append(" ").append(this.convertSqlNameSegment(this.getResponseProcedureParameter(responseProcedureName))).append("\n");
        sb.append("\t").append("COLUMNS").append(" ").append("\n");
        int i = 0;
        IWsdlColumnInfo[] bodyColumnInfoList = this.responseInfo.getBodyColumnInfoList();
        int nColumns = bodyColumnInfoList.length;
        IWsdlColumnInfo[] iWsdlColumnInfoArray = bodyColumnInfoList;
        int n = bodyColumnInfoList.length;
        int n2 = 0;
        while (n2 < n) {
            IWsdlColumnInfo columnInfo = iWsdlColumnInfoArray[n2];
            if (columnInfo.getOrdinality()) {
                sb.append(columnInfo.getSymbolName()).append(" ").append("FOR ORDINALITY");
            } else {
                String relPath;
                sb.append("\t").append("\t").append(this.convertSqlNameSegment(columnInfo.getSymbolName())).append(" ").append(columnInfo.getDatatype());
                String defValue = columnInfo.getDefaultValue();
                if (defValue != null && defValue.length() > 0) {
                    sb.append(" ").append("DEFAULT").append(" ").append("'").append(defValue).append("'");
                }
                if ((relPath = columnInfo.getRelativePath()) != null && relPath.length() > 1) {
                    sb.append(" ").append("PATH").append(" ").append("'").append(relPath).append("'");
                }
            }
            if (i < nColumns - 1) {
                sb.append(",").append(" ").append("\n");
            }
            ++i;
            ++n2;
        }
        return sb.toString();
    }

    private String getNamespaceString() {
        Map namespaceMap = this.responseInfo.getNamespaceMap();
        String nsObject = this.responseInfo.getOperation().getBinding().getPort().getNamespaceURI();
        if (namespaceMap.isEmpty() && nsObject == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("XMLNAMESPACES").append("(");
        int i = 0;
        for (Map.Entry entry : namespaceMap.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equalsIgnoreCase("xsi")) continue;
            if (i > 0) {
                sb.append(",").append(" ");
            }
            sb.append("'").append((String)entry.getValue()).append("'").append(" ").append("AS").append(" ").append((String)entry.getKey());
            ++i;
        }
        sb.append(")").append(" ").append(",").append(" ");
        return sb.toString();
    }

    private String getResponseProcedureParameter(String procedureName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getWrapperProcedure().getViewModelName()).append(".").append(procedureName).append(".").append("xml_in").append(" ");
        return sb.toString();
    }

    public String getSQLStatement() {
        String alias = "t";
        StringBuffer sb = new StringBuffer();
        sb.append("BEGIN\n");
        sb.append("\t").append("SELECT").append(" ").append(alias).append(".").append("*").append(" ").append("FROM").append("\n");
        sb.append("\t").append("\t").append("XMLTABLE").append("(");
        sb.append(this.getXmlTableString());
        sb.append(")");
        sb.append(" ").append("AS").append(" ").append(alias).append(";");
        sb.append("\nEND");
        return sb.toString();
    }
}

