/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.StringValue;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.util.CommandContext;

@Since(value=TeiidServerVersion.Version.TEIID_8_10)
public class XMLTableNode {
    private static Map<Class<?>, BuiltInAtomicType> typeMapping = new HashMap();

    static {
        typeMapping.put(DataTypeManagerService.DefaultDataTypes.TIMESTAMP.getTypeClass(), BuiltInAtomicType.DATE_TIME);
        typeMapping.put(DataTypeManagerService.DefaultDataTypes.TIME.getTypeClass(), BuiltInAtomicType.TIME);
        typeMapping.put(DataTypeManagerService.DefaultDataTypes.DATE.getTypeClass(), BuiltInAtomicType.DATE);
        typeMapping.put(DataTypeManagerService.DefaultDataTypes.FLOAT.getTypeClass(), BuiltInAtomicType.FLOAT);
        typeMapping.put(DataTypeManagerService.DefaultDataTypes.DOUBLE.getTypeClass(), BuiltInAtomicType.DOUBLE);
        typeMapping.put(DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass(), BuiltInAtomicType.HEX_BINARY);
        typeMapping.put(DataTypeManagerService.DefaultDataTypes.VARBINARY.getTypeClass(), BuiltInAtomicType.HEX_BINARY);
    }

    public static Object getValue(AtomicValue value, CommandContext context) throws XPathException {
        CalendarValue cv;
        if (value instanceof CalendarValue && !(cv = (CalendarValue)value).hasTimezone()) {
            TimeZone tz = context.getServerTimeZone();
            int tzMin = tz.getRawOffset() / 60000;
            if (tz.getDSTSavings() > 0) {
                tzMin = tz.getOffset(cv.getCalendar().getTimeInMillis()) / 60000;
            }
            cv.setTimezoneInMinutes(tzMin);
            GregorianCalendar cal = cv.getCalendar();
            return new Timestamp(cal.getTime().getTime());
        }
        return SequenceTool.convertToJava((Item)value);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    public static Object getValue(Class<?> type, Item colItem, Configuration config, CommandContext context) throws Exception {
        Object value = colItem;
        if (value instanceof AtomicValue) {
            value = XMLTableNode.getValue((AtomicValue)colItem, context);
        } else if (value instanceof Item) {
            Item i = value;
            if (XMLSystemFunctions.isNull(i)) {
                return null;
            }
            BuiltInAtomicType bat = typeMapping.get(type);
            if (bat != null) {
                StringValue av = new StringValue(i.getStringValueCS());
                AtomicValue cr = Converter.convert((AtomicValue)av, (AtomicType)bat, (ConversionRules)config.getConversionRules());
                value = cr.asAtomic();
                if ((value = XMLTableNode.getValue((AtomicValue)value, context)) instanceof Item) {
                    value = value.getStringValue();
                }
            } else {
                value = i.getStringValue();
            }
        }
        return FunctionDescriptor.importValue(context.getTeiidVersion(), value, type);
    }
}

