/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.LanguageObject;

public abstract class CommandResolver {
    private final QueryResolver queryResolver;
    private DataTypeManagerService dataTypeManager;

    public CommandResolver(QueryResolver queryResolver) {
        this.queryResolver = queryResolver;
    }

    protected QueryResolver getQueryResolver() {
        return this.queryResolver;
    }

    protected ITeiidServerVersion getTeiidVersion() {
        return this.getQueryResolver().getTeiidVersion();
    }

    protected TeiidParser getTeiidParser() {
        return this.queryResolver.getQueryParser().getTeiidParser();
    }

    protected <T extends LanguageObject> T create(TeiidNodeFactory.ASTNodes type) {
        return this.getTeiidParser().createASTNode(type);
    }

    protected DataTypeManagerService getDataTypeManager() {
        if (this.dataTypeManager == null) {
            this.dataTypeManager = DataTypeManagerService.getInstance(this.getTeiidVersion());
        }
        return this.dataTypeManager;
    }

    public abstract void resolveCommand(Command var1, TempMetadataAdapter var2, boolean var3) throws Exception;
}

