/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.metadata.IStoredProcedureInfo;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public abstract class ProcedureContainerResolver
extends CommandResolver {
    public ProcedureContainerResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    public abstract void resolveProceduralCommand(Command var1, TempMetadataAdapter var2) throws Exception;

    public Command expandCommand(ProcedureContainer procCommand, IQueryMetadataInterface metadata) throws Exception {
        GroupSymbol group = procCommand.getGroup();
        Command subCommand = null;
        String plan = this.getPlan(metadata, procCommand);
        if (plan == null) {
            return null;
        }
        QueryParser parser = this.getQueryResolver().getQueryParser();
        try {
            subCommand = parser.parseProcedure(plan, !(procCommand instanceof StoredProcedure));
        }
        catch (Exception e) {
            throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30060, group, procCommand.getClass().getSimpleName()));
        }
        return subCommand;
    }

    protected abstract String getPlan(IQueryMetadataInterface var1, GroupSymbol var2) throws Exception;

    private static void addChanging(TeiidParser parser, TempMetadataStore discoveredMetadata, GroupContext externalGroups, List<ElementSymbol> elements) {
        ArrayList<ElementSymbol> changingElements = new ArrayList<ElementSymbol>(elements.size());
        int i = 0;
        while (i < elements.size()) {
            ElementSymbol virtualElmnt = elements.get(i);
            ElementSymbol changeElement = virtualElmnt.clone();
            changeElement.setType(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass());
            changingElements.add(changeElement);
            ++i;
        }
        ProcedureContainerResolver.addScalarGroup(parser, "CHANGING", discoveredMetadata, externalGroups, changingElements, false);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws Exception {
        ProcedureContainer procCommand = (ProcedureContainer)command;
        this.resolveGroup(metadata, procCommand);
        this.resolveProceduralCommand(procCommand, metadata);
    }

    private String getPlan(IQueryMetadataInterface metadata, ProcedureContainer procCommand) throws Exception {
        if (!procCommand.getGroup().isTempTable() && metadata.isVirtualGroup(procCommand.getGroup().getMetadataID())) {
            String plan = this.getPlan(metadata, procCommand.getGroup());
            if (plan == null && !metadata.isProcedure(procCommand.getGroup().getMetadataID())) {
                int type = procCommand.getType();
                this.getUpdateInfo(procCommand.getGroup(), metadata, type, true);
            }
            return plan;
        }
        return null;
    }

    public UpdateValidator.UpdateInfo getUpdateInfo(GroupSymbol group, IQueryMetadataInterface metadata, int type, boolean validate) throws Exception {
        String error;
        UpdateValidator.UpdateInfo info = this.getUpdateInfo(group, metadata);
        if (info == null) {
            return null;
        }
        if ((validate || group.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0)) && (error = ProcedureContainerResolver.validateUpdateInfo(group, type, info)) != null) {
            throw new QueryResolverException(error);
        }
        return info;
    }

    public static String validateUpdateInfo(GroupSymbol group, int type, UpdateValidator.UpdateInfo info) {
        String error = info.getDeleteValidationError();
        String name = "Delete";
        if (type == 3) {
            error = info.getUpdateValidationError();
            name = "Update";
        } else if (type == 2) {
            error = info.getInsertValidationError();
            name = "Insert";
        }
        if (error != null) {
            return Messages.gs(Messages.TEIID.TEIID30061, group, name, error);
        }
        return null;
    }

    public UpdateValidator.UpdateInfo getUpdateInfo(GroupSymbol group, IQueryMetadataInterface metadata) throws Exception {
        if (!this.getQueryResolver().isView(group, metadata)) {
            return null;
        }
        try {
            return this.getQueryResolver().resolveView(group, metadata.getVirtualPlan(group.getMetadataID()), "SELECT", metadata).getUpdateInfo();
        }
        catch (Exception e) {
            throw new QueryResolverException(e);
        }
    }

    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws Exception {
        GroupSymbol group = procCommand.getGroup();
        ResolverUtil.resolveGroup(group, metadata);
        if (!group.isTempTable()) {
            procCommand.setUpdateInfo(this.getUpdateInfo(group, metadata, procCommand.getType(), false));
        }
    }

    public static GroupSymbol addScalarGroup(TeiidParser teiidParser, String name, TempMetadataStore metadata, GroupContext externalGroups, List<? extends Expression> symbols) {
        return ProcedureContainerResolver.addScalarGroup(teiidParser, name, metadata, externalGroups, symbols, true);
    }

    public static GroupSymbol addScalarGroup(TeiidParser teiidParser, String name, TempMetadataStore metadata, GroupContext externalGroups, List<? extends Expression> symbols, boolean updatable) {
        boolean[] updateArray = new boolean[symbols.size()];
        if (updatable) {
            Arrays.fill(updateArray, true);
        }
        return ProcedureContainerResolver.addScalarGroup(teiidParser, name, metadata, externalGroups, symbols, updateArray);
    }

    public static GroupSymbol addScalarGroup(TeiidParser teiidParser, String name, TempMetadataStore metadata, GroupContext externalGroups, List<? extends Expression> symbols, boolean[] updatable) {
        GroupSymbol variables = (GroupSymbol)teiidParser.createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
        variables.setName(name);
        externalGroups.addGroup(variables);
        TempMetadataID tid = metadata.addTempGroup(name, symbols);
        tid.setMetadataType(TempMetadataID.Type.SCALAR);
        int i = 0;
        for (TempMetadataID cid : tid.getElements()) {
            cid.setMetadataType(TempMetadataID.Type.SCALAR);
            cid.setUpdatable(updatable[i++]);
        }
        variables.setMetadataID(tid);
        return variables;
    }

    public static void findChildCommandMetadata(QueryResolver queryResolver, Command currentCommand, GroupSymbol container, int type, IQueryMetadataInterface metadata, boolean inferProcedureResultSetColumns) throws Exception {
        TeiidParser parser = queryResolver.getQueryParser().getTeiidParser();
        TempMetadataStore childMetadata = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, childMetadata);
        GroupContext externalGroups = new GroupContext();
        if (currentCommand instanceof TriggerAction) {
            TriggerAction ta = (TriggerAction)currentCommand;
            ta.setView(container);
            List<ElementSymbol> viewElements = ResolverUtil.resolveElementsInGroup(ta.getView(), metadata);
            if (type == 3 || type == 2) {
                ProcedureContainerResolver.addChanging(parser, tma.getMetadataStore(), externalGroups, viewElements);
                ProcedureContainerResolver.addScalarGroup(parser, "NEW", tma.getMetadataStore(), externalGroups, viewElements, false);
            }
            if (type == 3 || type == 4) {
                ProcedureContainerResolver.addScalarGroup(parser, "OLD", tma.getMetadataStore(), externalGroups, viewElements, false);
            }
        } else if (currentCommand instanceof CreateUpdateProcedureCommand) {
            CreateUpdateProcedureCommand cupc = (CreateUpdateProcedureCommand)currentCommand;
            cupc.setVirtualGroup(container);
            if (type == 6) {
                IStoredProcedureInfo info = metadata.getStoredProcedureInfoForProcedure(container.getCanonicalName());
                String procName = info.getProcedureCallableName();
                ArrayList<ElementSymbol> tempElements = new ArrayList<ElementSymbol>(info.getParameters().size());
                boolean[] updatable = new boolean[info.getParameters().size()];
                int i = 0;
                for (ISPParameter param : info.getParameters()) {
                    if (param.getParameterType() == ISPParameter.ParameterInfo.RESULT_SET.index()) continue;
                    ElementSymbol symbol = (ElementSymbol)param.getParameterSymbol();
                    tempElements.add(symbol);
                    boolean bl = updatable[i++] = param.getParameterType() != ISPParameter.ParameterInfo.IN.index();
                }
                ProcedureContainerResolver.addScalarGroup(parser, procName, childMetadata, externalGroups, tempElements, updatable);
            } else if (type != 4) {
                ProcedureContainerResolver.createInputChangingMetadata(parser, childMetadata, tma, container, externalGroups);
            }
        } else if (currentCommand instanceof CreateProcedureCommand) {
            CreateProcedureCommand cupc = (CreateProcedureCommand)currentCommand;
            cupc.setVirtualGroup(container);
            if (type == 6) {
                IStoredProcedureInfo info = metadata.getStoredProcedureInfoForProcedure(container.getName());
                String procName = info.getProcedureCallableName();
                ArrayList<ElementSymbol> tempElements = new ArrayList<ElementSymbol>(info.getParameters().size());
                boolean[] updatable = new boolean[info.getParameters().size()];
                int i = 0;
                List rsColumns = Collections.emptyList();
                for (ISPParameter param : info.getParameters()) {
                    if (param.getParameterType() != ISPParameter.ParameterInfo.RESULT_SET.index()) {
                        ElementSymbol symbol = (ElementSymbol)param.getParameterSymbol();
                        tempElements.add(symbol);
                        boolean bl = updatable[i++] = param.getParameterType() != ISPParameter.ParameterInfo.IN.index();
                        if (param.getParameterType() != ISPParameter.ParameterInfo.RETURN_VALUE.index()) continue;
                        cupc.setReturnVariable(symbol);
                        continue;
                    }
                    rsColumns = param.getResultSetColumns();
                }
                if (inferProcedureResultSetColumns) {
                    rsColumns = null;
                }
                GroupSymbol gs = ProcedureContainerResolver.addScalarGroup(parser, procName, childMetadata, externalGroups, tempElements, updatable);
                if (cupc.getReturnVariable() != null) {
                    ResolverVisitor visitor = new ResolverVisitor(parser.getVersion());
                    visitor.resolveLanguageObject(cupc.getReturnVariable(), Arrays.asList(gs), metadata);
                }
                cupc.setResultSetColumns(rsColumns);
                cupc.setProjectedSymbols(rsColumns);
            } else {
                cupc.setUpdateType(type);
            }
        }
        queryResolver.setChildMetadata(currentCommand, childMetadata, externalGroups);
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private static void createInputChangingMetadata(TeiidParser teiidParser, TempMetadataStore discoveredMetadata, IQueryMetadataInterface metadata, GroupSymbol group, GroupContext externalGroups) throws Exception {
        List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, metadata);
        ArrayList<ElementSymbol> inputElments = new ArrayList<ElementSymbol>(elements.size());
        int i = 0;
        while (i < elements.size()) {
            ElementSymbol virtualElmnt = elements.get(i);
            ElementSymbol inputElement = virtualElmnt.clone();
            inputElments.add(inputElement);
            ++i;
        }
        ProcedureContainerResolver.addScalarGroup(teiidParser, "INPUT", discoveredMetadata, externalGroups, inputElments, false);
        ProcedureContainerResolver.addScalarGroup(teiidParser, "INPUTS", discoveredMetadata, externalGroups, inputElments, false);
        ProcedureContainerResolver.addChanging(teiidParser, discoveredMetadata, externalGroups, elements);
    }
}

