/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Alter;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.Command;
import org.teiid.runtime.client.Messages;

public class AlterResolver
extends CommandResolver {
    public AlterResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws Exception {
        Alter alter = (Alter)command;
        ResolverUtil.resolveGroup(alter.getTarget(), metadata);
        int type = 1;
        boolean viewTarget = true;
        if (alter instanceof AlterTrigger) {
            Table.TriggerEvent event = ((AlterTrigger)alter).getEvent();
            switch (event) {
                case DELETE: {
                    type = 4;
                    break;
                }
                case INSERT: {
                    type = 2;
                    break;
                }
                case UPDATE: {
                    type = 3;
                }
            }
        } else if (alter instanceof AlterProcedure) {
            type = 6;
            viewTarget = false;
        }
        if (viewTarget && !this.getQueryResolver().isView(alter.getTarget(), metadata)) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30116, alter.getTarget()));
        }
        if (alter.getDefinition() != null) {
            this.getQueryResolver().resolveCommand((Command)alter.getDefinition(), alter.getTarget(), type, metadata.getDesignTimeMetadata(), false);
        }
    }
}

