/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.runtime.client.Messages;

public class DynamicCommandResolver
extends CommandResolver {
    public DynamicCommandResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws Exception {
        GroupSymbol intoSymbol;
        ElementSymbol column;
        DynamicCommand dynamicCmd = (DynamicCommand)command;
        Iterator columns = dynamicCmd.getAsColumns().iterator();
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        boolean resolvedColumns = false;
        if (dynamicCmd.getIntoGroup() == null) {
            while (columns.hasNext()) {
                column = (ElementSymbol)columns.next();
                column.setMetadataID(new TempMetadataID(column.getShortName(), column.getType()));
            }
        } else if (dynamicCmd.getIntoGroup().isTempGroupSymbol()) {
            resolvedColumns = true;
            while (columns.hasNext()) {
                column = (ElementSymbol)columns.next();
                GroupSymbol gs = (GroupSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
                gs.setName(dynamicCmd.getIntoGroup().getName());
                column.setGroupSymbol(gs);
            }
        }
        ResolverVisitor visitor = new ResolverVisitor(this.getTeiidParser().getVersion());
        visitor.resolveLanguageObject(dynamicCmd, groups, dynamicCmd.getExternalGroupContexts(), metadata);
        String sqlType = this.getDataTypeManager().getDataTypeName(dynamicCmd.getSql().getType());
        String targetType = DataTypeManagerService.DefaultDataTypes.STRING.getId();
        if (!targetType.equals(sqlType) && !this.getDataTypeManager().isImplicitConversion(sqlType, targetType)) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30100, sqlType));
        }
        if (dynamicCmd.getUsing() != null && !dynamicCmd.getUsing().isEmpty()) {
            for (SetClause clause : dynamicCmd.getUsing().getClauses()) {
                ElementSymbol id = clause.getSymbol();
                GroupSymbol gs = (GroupSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
                gs.setName("DVARS");
                id.setGroupSymbol(gs);
                id.setType(clause.getValue().getType());
                id.setMetadataID(new TempMetadataID(id.getName(), id.getType()));
            }
        }
        if ((intoSymbol = dynamicCmd.getIntoGroup()) != null) {
            if (!intoSymbol.isImplicitTempGroupSymbol()) {
                ResolverUtil.resolveGroup(intoSymbol, metadata);
                if (!resolvedColumns && this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_12_4)) {
                    for (ElementSymbol column2 : dynamicCmd.getAsColumns()) {
                        column2.setGroupSymbol(dynamicCmd.getIntoGroup().clone());
                    }
                }
            } else {
                List symbols = dynamicCmd.getAsColumns();
                ResolverUtil.resolveImplicitTempGroup(metadata, intoSymbol, symbols);
            }
        }
    }
}

