/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.metadata.IStoredProcedureInfo;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class ExecResolver
extends ProcedureContainerResolver {
    public ExecResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    private void findCommand7Metadata(IQueryMetadataInterface metadata, StoredProcedure storedProcedureCommand, IStoredProcedureInfo storedProcedureInfo, Collection<SPParameter> oldParams, boolean namedParameters) throws Exception {
        Expression expr;
        HashMap<Object, Expression> inputExpressions = new HashMap<Object, Expression>();
        int adjustIndex = 0;
        for (SPParameter param : oldParams) {
            if (param.getExpression() == null) {
                if (param.getParameterType() != SPParameter.RESULT_SET) continue;
                --adjustIndex;
                continue;
            }
            if (namedParameters && param.getParameterType() != SPParameter.RETURN_VALUE) {
                if (inputExpressions.put(param.getName().toUpperCase(), param.getExpression()) == null) continue;
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30138, param.getName().toUpperCase()));
            }
            inputExpressions.put(param.getIndex() + adjustIndex, param.getExpression());
        }
        storedProcedureCommand.clearParameters();
        int origInputs = inputExpressions.size();
        List metadataParams = storedProcedureInfo.getParameters();
        ArrayList<SPParameter> clonedMetadataParams = new ArrayList<SPParameter>(metadataParams.size());
        int inputParams = 0;
        boolean hasReturnValue = false;
        for (SPParameter metadataParameter : metadataParams) {
            if (metadataParameter.getParameterType() == ISPParameter.ParameterInfo.IN.index() || metadataParameter.getParameterType() == ISPParameter.ParameterInfo.INOUT.index()) {
                ++inputParams;
            } else if (metadataParameter.getParameterType() != ISPParameter.ParameterInfo.OUT.index() && metadataParameter.getParameterType() == ISPParameter.ParameterInfo.RETURN_VALUE.index()) {
                hasReturnValue = true;
            }
            SPParameter clonedParam = metadataParameter.clone();
            clonedMetadataParams.add(clonedParam);
            storedProcedureCommand.setParameter(clonedParam);
        }
        if (storedProcedureCommand.isCalledWithReturn() && !hasReturnValue) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30139, storedProcedureCommand.getGroup()));
        }
        if (!namedParameters && inputParams > inputExpressions.size()) {
            throw new TeiidClientException(Messages.getString(Messages.ERR.ERR_015_008_0007, inputParams, origInputs, storedProcedureCommand.getGroup()));
        }
        int exprIndex = 1;
        HashSet<String> expected = new HashSet<String>();
        if (storedProcedureCommand.isCalledWithReturn() && hasReturnValue) {
            for (SPParameter param : clonedMetadataParams) {
                if (param.getParameterType() != SPParameter.RETURN_VALUE) continue;
                expr = (Expression)inputExpressions.remove(exprIndex++);
                param.setExpression(expr);
            }
        }
        for (SPParameter param : clonedMetadataParams) {
            if (param.getParameterType() == SPParameter.RESULT_SET || param.getParameterType() == SPParameter.RETURN_VALUE) continue;
            if (namedParameters) {
                String nameKey = param.getParameterSymbol().getShortCanonicalName();
                Expression expr2 = (Expression)inputExpressions.remove(nameKey);
                if (expr2 == null && param.getParameterType() != ISPParameter.ParameterInfo.OUT.index()) {
                    expr2 = ResolverUtil.getDefault(param.getParameterSymbol(), metadata);
                    param.setUsingDefault(true);
                    expected.add(nameKey);
                }
                param.setExpression(expr2);
                continue;
            }
            if (param.getParameterType() == SPParameter.OUT) continue;
            expr = (Expression)inputExpressions.remove(exprIndex++);
            param.setExpression(expr);
        }
        if (!inputExpressions.isEmpty()) {
            if (namedParameters) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30141, inputExpressions.keySet(), expected));
            }
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID31113, inputParams, origInputs, storedProcedureCommand.getGroup().toString()));
        }
    }

    private void findCommand8Metadata(IQueryMetadataInterface metadata, StoredProcedure storedProcedureCommand, IStoredProcedureInfo storedProcedureInfo, Collection<SPParameter> oldParams, boolean namedParameters) throws Exception {
        Expression expr;
        TreeMap<Integer, Expression> positionalExpressions = new TreeMap<Integer, Expression>();
        TreeMap<String, Expression> namedExpressions = new TreeMap<String, Expression>(String.CASE_INSENSITIVE_ORDER);
        int adjustIndex = 0;
        for (SPParameter param : oldParams) {
            if (param.getExpression() == null) {
                if (param.getParameterType() != SPParameter.RESULT_SET) continue;
                --adjustIndex;
                continue;
            }
            if (namedParameters && param.getParameterType() != SPParameter.RETURN_VALUE) {
                if (namedExpressions.put(param.getParameterSymbol().getShortName(), param.getExpression()) == null) continue;
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30138, param.getName()));
            }
            positionalExpressions.put(param.getIndex() + adjustIndex, param.getExpression());
        }
        storedProcedureCommand.clearParameters();
        int origInputs = positionalExpressions.size() + namedExpressions.size();
        List metadataParams = storedProcedureInfo.getParameters();
        ArrayList<SPParameter> clonedMetadataParams = new ArrayList<SPParameter>(metadataParams.size());
        int inputParams = 0;
        int optionalParams = 0;
        boolean hasReturnValue = false;
        boolean optional = false;
        boolean varargs = false;
        int i = 0;
        while (i < metadataParams.size()) {
            SPParameter metadataParameter = (SPParameter)metadataParams.get(i);
            if (metadataParameter.getParameterType() == ISPParameter.ParameterInfo.IN.index() || metadataParameter.getParameterType() == ISPParameter.ParameterInfo.INOUT.index()) {
                if (ResolverUtil.hasDefault(metadataParameter.getMetadataID(), metadata) || metadataParameter.isVarArg()) {
                    optional = true;
                    ++optionalParams;
                } else {
                    ++inputParams;
                    if (optional) {
                        optional = false;
                        inputParams += optionalParams;
                        optionalParams = 0;
                    }
                }
                if (metadataParameter.isVarArg()) {
                    varargs = true;
                }
            } else if (metadataParameter.getParameterType() != ISPParameter.ParameterInfo.OUT.index() && metadataParameter.getParameterType() == ISPParameter.ParameterInfo.RETURN_VALUE.index()) {
                hasReturnValue = true;
            }
            SPParameter clonedParam = metadataParameter.clone();
            clonedMetadataParams.add(clonedParam);
            storedProcedureCommand.setParameter(clonedParam);
            ++i;
        }
        if (storedProcedureCommand.isCalledWithReturn() && !hasReturnValue) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30139, storedProcedureCommand.getGroup()));
        }
        if (!namedParameters && inputParams > positionalExpressions.size()) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30140, inputParams, String.valueOf(inputParams + optionalParams) + (varargs ? "+" : ""), origInputs, storedProcedureCommand.getGroup()));
        }
        int exprIndex = 1;
        HashSet<String> expected = new HashSet<String>();
        if (storedProcedureCommand.isCalledWithReturn() && hasReturnValue) {
            for (SPParameter param : clonedMetadataParams) {
                if (param.getParameterType() != SPParameter.RETURN_VALUE) continue;
                expr = (Expression)positionalExpressions.remove(exprIndex++);
                param.setExpression(expr);
                break;
            }
        }
        for (SPParameter param : clonedMetadataParams) {
            if (param.getParameterType() == SPParameter.RESULT_SET || param.getParameterType() == SPParameter.RETURN_VALUE) continue;
            if (namedParameters) {
                String nameKey = param.getParameterSymbol().getShortName();
                Expression expr2 = (Expression)namedExpressions.remove(nameKey);
                if (expr2 == null && param.getParameterType() != ISPParameter.ParameterInfo.OUT.index()) {
                    param.setUsingDefault(true);
                    expected.add(nameKey);
                    if (!param.isVarArg()) {
                        expr2 = ResolverUtil.getDefault(param.getParameterSymbol(), metadata);
                    } else {
                        ArrayList<Expression> exprs = new ArrayList<Expression>(0);
                        Array array = (Array)this.create(TeiidNodeFactory.ASTNodes.ARRAY);
                        array.setExpressions(exprs);
                        array.setImplicit(true);
                        array.setType(param.getClassType());
                        expr2 = array;
                    }
                }
                param.setExpression(expr2);
                continue;
            }
            expr = (Expression)positionalExpressions.remove(exprIndex++);
            if (param.getParameterType() == SPParameter.OUT) {
                if (expr == null) continue;
                boolean isRef = expr instanceof Reference;
                if (!isRef || exprIndex <= inputParams + 1) {
                    positionalExpressions.put(--exprIndex, expr);
                    continue;
                }
                if (!isRef) continue;
                Reference ref = (Reference)expr;
                ref.setOptional(true);
                continue;
            }
            if (expr == null) {
                if (!param.isVarArg()) {
                    expr = ResolverUtil.getDefault(param.getParameterSymbol(), metadata);
                }
                param.setUsingDefault(true);
            }
            if (param.isVarArg()) {
                ArrayList<Expression> exprs = new ArrayList<Expression>(positionalExpressions.size() + 1);
                if (expr != null) {
                    exprs.add(expr);
                }
                exprs.addAll(positionalExpressions.values());
                positionalExpressions.clear();
                Array array = (Array)this.create(TeiidNodeFactory.ASTNodes.ARRAY);
                array.setExpressions(exprs);
                array.setImplicit(true);
                expr = array;
            }
            param.setExpression(expr);
        }
        if (!namedExpressions.isEmpty()) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30141, namedExpressions.keySet(), expected));
        }
        if (!positionalExpressions.isEmpty()) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID31113, positionalExpressions.size(), origInputs, storedProcedureCommand.getGroup().toString()));
        }
    }

    private void findCommandMetadata(Command command, TempMetadataStore discoveredMetadata, IQueryMetadataInterface metadata) throws Exception {
        IStoredProcedureInfo storedProcedureInfo;
        StoredProcedure storedProcedureCommand;
        block8: {
            storedProcedureCommand = (StoredProcedure)command;
            storedProcedureInfo = null;
            try {
                storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(storedProcedureCommand.getProcedureName());
            }
            catch (Exception e) {
                String[] parts = storedProcedureCommand.getProcedureName().split("\\.", 2);
                if (parts.length > 1 && parts[0].equalsIgnoreCase(metadata.getVirtualDatabaseName())) {
                    try {
                        storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(parts[1]);
                        storedProcedureCommand.setProcedureName(parts[1]);
                    }
                    catch (Exception exception) {}
                }
                if (storedProcedureInfo != null) break block8;
                throw e;
            }
        }
        storedProcedureCommand.setUpdateCount(storedProcedureInfo.getUpdateCount());
        storedProcedureCommand.setModelID(storedProcedureInfo.getModelID());
        storedProcedureCommand.setProcedureID(storedProcedureInfo.getProcedureID());
        storedProcedureCommand.setProcedureCallableName(storedProcedureInfo.getProcedureCallableName());
        Collection<SPParameter> oldParams = storedProcedureCommand.getParameters();
        boolean namedParameters = storedProcedureCommand.isDisplayNamedParameters();
        if (oldParams.size() == 0 || oldParams.size() == 1 && storedProcedureCommand.isCalledWithReturn()) {
            storedProcedureCommand.setDisplayNamedParameters(true);
            namedParameters = true;
        }
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0)) {
            this.findCommand7Metadata(metadata, storedProcedureCommand, storedProcedureInfo, oldParams, namedParameters);
        } else {
            this.findCommand8Metadata(metadata, storedProcedureCommand, storedProcedureInfo, oldParams, namedParameters);
        }
        String procName = storedProcedureCommand.getProcedureName();
        List tempElements = storedProcedureCommand.getProjectedSymbols();
        boolean isVirtual = storedProcedureInfo.getQueryPlan() != null;
        discoveredMetadata.addTempGroup(procName, tempElements, isVirtual);
        GroupSymbol procGroup = (GroupSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
        procGroup.setName(storedProcedureInfo.getProcedureCallableName());
        procGroup.setProcedure(true);
        TempMetadataID tid = discoveredMetadata.getTempGroupID(procName);
        tid.setOriginalMetadataID(storedProcedureCommand.getProcedureID());
        procGroup.setMetadataID(tid);
        storedProcedureCommand.setGroup(procGroup);
    }

    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata) throws Exception {
        this.findCommandMetadata(command, metadata.getMetadataStore(), metadata);
        StoredProcedure storedProcedureCommand = (StoredProcedure)command;
        GroupContext externalGroups = storedProcedureCommand.getExternalGroupContexts();
        for (SPParameter param : storedProcedureCommand.getParameters()) {
            Expression expr = param.getExpression();
            if (expr == null) continue;
            for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr)) {
                this.getQueryResolver().setChildMetadata((Command)container.getCommand(), command);
                this.getQueryResolver().resolveCommand((Command)container.getCommand(), metadata.getMetadata());
            }
            try {
                ResolverVisitor visitor = new ResolverVisitor(expr.getTeiidVersion());
                visitor.resolveLanguageObject(expr, null, externalGroups, metadata);
            }
            catch (Exception e) {
                if (this.checkForArray(param, expr)) continue;
                throw e;
            }
            Class<?> paramType = param.getClassType();
            ResolverUtil.setDesiredType(expr, paramType, storedProcedureCommand);
            Class<?> exprType = expr.getType();
            if (paramType == null || exprType == null) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30143, storedProcedureCommand.getProcedureName(), param.getName()));
            }
            String tgtType = this.getDataTypeManager().getDataTypeName(paramType);
            String srcType = this.getDataTypeManager().getDataTypeName(exprType);
            Expression result = null;
            if (param.getParameterType() == SPParameter.RETURN_VALUE || param.getParameterType() == SPParameter.OUT) {
                if (ResolverUtil.canImplicitlyConvert(this.getTeiidVersion(), tgtType, srcType)) continue;
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30144, param.getParameterSymbol(), tgtType, srcType));
            }
            try {
                result = ResolverUtil.convertExpression(expr, tgtType, metadata);
            }
            catch (Exception e) {
                throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30145, param.getParameterSymbol(), srcType, tgtType));
            }
            param.setExpression(result);
        }
    }

    private boolean checkForArray(SPParameter param, Expression expr) {
        Expression first;
        if (!param.isVarArg() || !(expr instanceof Array)) {
            return false;
        }
        Array array = (Array)expr;
        if (array.getExpressions().size() == 1 && (first = array.getExpressions().get(0)).getType() != null && first.getType() == array.getType()) {
            param.setExpression(first);
            return true;
        }
        return false;
    }

    @Override
    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws Exception {
    }

    @Override
    protected String getPlan(IQueryMetadataInterface metadata, GroupSymbol group) throws Exception {
        IStoredProcedureInfo storedProcedureInfo = metadata.getStoredProcedureInfoForProcedure(group.getName());
        QueryNode plan = (QueryNode)storedProcedureInfo.getQueryPlan();
        if (plan.getQuery() == null) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30146, group));
        }
        return plan.getQuery();
    }
}

