/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.ArgCheck;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.runtime.client.Messages;

public class InsertResolver
extends ProcedureContainerResolver
implements VariableResolver {
    public InsertResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata) throws Exception {
        boolean usingQuery;
        Insert insert = (Insert)command;
        if (insert.getValues() != null) {
            this.getQueryResolver().resolveSubqueries(command, metadata, null);
            this.resolveList(insert.getValues(), metadata, insert.getExternalGroupContexts(), null);
        }
        if (insert.getQueryExpression() != null) {
            this.getQueryResolver().setChildMetadata(insert.getQueryExpression(), command);
            this.getQueryResolver().resolveCommand(insert.getQueryExpression(), metadata.getMetadata(), false);
        }
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(insert.getGroup());
        List values = insert.getValues();
        boolean bl = usingQuery = insert.getQueryExpression() != null;
        if (usingQuery) {
            values = insert.getQueryExpression().getProjectedSymbols();
        }
        if (insert.getVariables().isEmpty()) {
            if (insert.getGroup().isResolved()) {
                List<ElementSymbol> variables = ResolverUtil.resolveElementsInGroup(insert.getGroup(), metadata);
                Iterator<ElementSymbol> i = variables.iterator();
                while (i.hasNext()) {
                    insert.addVariable(i.next().clone());
                }
            } else {
                int i = 0;
                while (i < values.size()) {
                    ElementSymbol es = (ElementSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
                    if (usingQuery) {
                        Expression ses = (Expression)values.get(i);
                        es.setName(Symbol.getShortName(ses));
                        es.setType(ses.getType());
                        insert.addVariable(es);
                    } else {
                        es.setName("expr" + i);
                        insert.addVariable(es);
                    }
                    ++i;
                }
            }
        } else if (insert.getGroup().isResolved()) {
            this.resolveVariables(metadata, insert, groups);
        }
        this.resolveTypes(insert, metadata, values, usingQuery);
        if (!insert.getGroup().isResolved()) {
            ResolverUtil.resolveImplicitTempGroup(metadata, insert.getGroup(), insert.getVariables());
            this.resolveVariables(metadata, insert, groups);
            this.resolveTypes(insert, metadata, values, usingQuery);
        }
        if (insert.getQueryExpression() != null && metadata.isVirtualGroup(insert.getGroup().getMetadataID())) {
            ArrayList<Reference> references = new ArrayList<Reference>(insert.getVariables().size());
            int i = 0;
            while (i < insert.getVariables().size()) {
                Reference ref = (Reference)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.REFERENCE);
                ref.setIndex(i);
                ref.setPositional(true);
                ref.setType(insert.getVariables().get(i).getType());
                references.add(ref);
                ++i;
            }
            insert.setValues(references);
        }
    }

    private void resolveVariables(TempMetadataAdapter metadata, Insert insert, Set<GroupSymbol> groups) throws Exception {
        try {
            this.resolveList(insert.getVariables(), metadata, null, groups);
        }
        catch (QueryResolverException e) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30126, insert.getGroup(), e.getUnresolvedSymbols()));
        }
    }

    private void resolveList(Collection<? extends Expression> elements, TempMetadataAdapter metadata, GroupContext externalGroups, Set<GroupSymbol> groups) throws QueryResolverException, Exception {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        ResolverVisitor visitor = new ResolverVisitor(elements.iterator().next().getTeiidVersion());
        for (Expression expression : elements) {
            visitor.resolveLanguageObject(expression, groups, externalGroups, metadata);
        }
    }

    public void resolveTypes(Insert insert, TempMetadataAdapter metadata, List values, boolean usingQuery) throws Exception {
        ArrayList<Expression> newValues = new ArrayList<Expression>(values.size());
        if (values.size() != insert.getVariables().size()) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30127, insert.getVariables().size(), values.size()));
        }
        Iterator valueIter = values.iterator();
        Iterator<ElementSymbol> varIter = insert.getVariables().iterator();
        while (valueIter.hasNext()) {
            Expression expression = (Expression)valueIter.next();
            ElementSymbol element = varIter.next();
            if (expression.getType() == null) {
                ResolverUtil.setDesiredType(SymbolMap.getExpression(expression), element.getType(), insert);
            }
            if (element.getType() != null && expression.getType() != null) {
                String elementTypeName = this.getDataTypeManager().getDataTypeName(element.getType());
                if (!usingQuery) {
                    newValues.add(ResolverUtil.convertExpression(expression, elementTypeName, metadata));
                    continue;
                }
                if (element.getType() == expression.getType() || this.getDataTypeManager().isImplicitConversion(this.getDataTypeManager().getDataTypeName(expression.getType()), this.getDataTypeManager().getDataTypeName(element.getType()))) continue;
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30128, expression, expression.getType().getName(), element, element.getType().getName()));
            }
            if (element.getType() == null && expression.getType() != null) {
                element.setType(expression.getType());
                newValues.add(expression);
                continue;
            }
            ArgCheck.isTrue(false, "Cannot determine element or expression type");
        }
        if (!usingQuery) {
            insert.setValues(newValues);
        }
    }

    @Override
    protected String getPlan(IQueryMetadataInterface metadata, GroupSymbol group) throws Exception {
        return metadata.getInsertPlan(group.getMetadataID());
    }

    @Override
    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws Exception {
        if (!procCommand.getGroup().isImplicitTempGroupSymbol() || metadata.getMetadataStore().getTempGroupID(procCommand.getGroup().getName()) != null) {
            super.resolveGroup(metadata, procCommand);
        }
    }

    @Override
    public Map<ElementSymbol, Expression> getVariableValues(Command command, boolean changingOnly, IQueryMetadataInterface metadata) throws Exception {
        Insert insert = (Insert)command;
        HashMap<ElementSymbol, Expression> result = new HashMap<ElementSymbol, Expression>();
        Iterator<ElementSymbol> varIter = insert.getVariables().iterator();
        Iterator<Expression> valIter = null;
        valIter = insert.getQueryExpression() != null ? insert.getQueryExpression().getProjectedSymbols().iterator() : insert.getValues().iterator();
        while (varIter.hasNext()) {
            ElementSymbol next = varIter.next();
            ElementSymbol varSymbol = next.clone();
            varSymbol.getGroupSymbol().setName("CHANGING");
            varSymbol.setType(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass());
            Constant constant = (Constant)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.CONSTANT);
            constant.setValue(Boolean.TRUE);
            if (changingOnly) continue;
            varSymbol = next.clone();
            varSymbol.getGroupSymbol().setName("NEW");
            result.put(varSymbol, valIter.next());
        }
        List<ElementSymbol> insertElmnts = ResolverUtil.resolveElementsInGroup(insert.getGroup(), metadata);
        insertElmnts.removeAll(insert.getVariables());
        for (ElementSymbol next : insertElmnts) {
            ElementSymbol varSymbol = next.clone();
            varSymbol.getGroupSymbol().setName("CHANGING");
            varSymbol.setType(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass());
            Constant constant = (Constant)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.CONSTANT);
            constant.setValue(Boolean.FALSE);
            result.put(varSymbol, constant);
            if (changingOnly) continue;
            varSymbol = next.clone();
            Expression value = ResolverUtil.getDefault(varSymbol, metadata);
            varSymbol.getGroupSymbol().setName("NEW");
            result.put(varSymbol, value);
        }
        return result;
    }
}

