/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.command.SimpleQueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.runtime.client.Messages;

public class SetQueryResolver
extends CommandResolver {
    public SetQueryResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws Exception {
        SetQuery setQuery = (SetQuery)command;
        SimpleQueryResolver simpleQueryResolver = new SimpleQueryResolver(this.getQueryResolver());
        simpleQueryResolver.resolveWith(metadata, setQuery);
        QueryCommand firstCommand = setQuery.getLeftQuery();
        QueryCommand rightCommand = setQuery.getRightQuery();
        this.getQueryResolver().setChildMetadata(firstCommand, setQuery);
        this.getQueryResolver().resolveCommand(firstCommand, metadata.getMetadata(), false);
        this.resolveSetQuery(metadata, resolveNullLiterals, setQuery, firstCommand, rightCommand);
    }

    public void resolveSetQuery(TempMetadataAdapter metadata, boolean resolveNullLiterals, SetQuery setQuery, QueryCommand firstCommand, QueryCommand rightCommand) throws Exception {
        List firstProject = firstCommand.getProjectedSymbols();
        ArrayList firstProjectTypes = new ArrayList();
        for (Expression symbol : firstProject) {
            firstProjectTypes.add(symbol.getType());
        }
        this.getQueryResolver().setChildMetadata(rightCommand, setQuery);
        this.getQueryResolver().resolveCommand(rightCommand, metadata.getMetadata(), false);
        if (firstProject.size() != rightCommand.getProjectedSymbols().size()) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30147, setQuery.getOperation()));
        }
        this.checkSymbolTypes(firstProjectTypes, rightCommand.getProjectedSymbols());
        if (resolveNullLiterals) {
            int i = 0;
            while (i < firstProjectTypes.size()) {
                Class clazz = (Class)firstProjectTypes.get(i);
                if (DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass().equals(clazz)) {
                    firstProjectTypes.set(i, DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass());
                }
                ++i;
            }
        }
        setQuery.setProjectedTypes(firstProjectTypes, metadata.getMetadata());
        if (setQuery.getOrderBy() != null) {
            ResolverUtil.resolveOrderBy(setQuery.getOrderBy(), setQuery, metadata);
        }
        this.setProjectedTypes(setQuery, firstProjectTypes, metadata.getMetadata());
        if (setQuery.getLimit() != null) {
            ResolverUtil.resolveLimit(setQuery.getLimit());
        }
        setQuery.setTemporaryMetadata(firstCommand.getTemporaryMetadata().clone());
    }

    private void setProjectedTypes(SetQuery setQuery, List<Class<?>> firstProjectTypes, IQueryMetadataInterface metadata) throws Exception {
        for (QueryCommand subCommand : setQuery.getQueryCommands()) {
            if (!(subCommand instanceof SetQuery)) continue;
            SetQuery child = (SetQuery)subCommand;
            List<Expression> projectedSymbols = child.getProjectedSymbols();
            if (child.getOrderBy() != null) {
                int j = 0;
                while (j < projectedSymbols.size()) {
                    Expression ses = projectedSymbols.get(j);
                    Class<?> targetType = firstProjectTypes.get(j);
                    if (ses.getType() != targetType && SetQueryResolver.orderByContainsVariable(child.getOrderBy(), ses, j)) {
                        DataTypeManagerService dataTypeManager = this.getDataTypeManager();
                        String sourceTypeName = dataTypeManager.getDataTypeName(ses.getType());
                        String targetTypeName = dataTypeManager.getDataTypeName(targetType);
                        throw new QueryResolverException(Messages.getString(Messages.QueryResolver.type_conversion, ses, sourceTypeName, targetTypeName));
                    }
                    ++j;
                }
            }
            child.setProjectedTypes(firstProjectTypes, metadata);
            this.setProjectedTypes(child, firstProjectTypes, metadata);
        }
    }

    public static boolean orderByContainsVariable(OrderBy orderBy, Expression ses, int position) {
        for (OrderByItem item : orderBy.getOrderByItems()) {
            if (item.getExpressionPosition() != position) continue;
            return true;
        }
        return false;
    }

    private void checkSymbolTypes(List firstProjectTypes, List projSymbols) {
        int j = 0;
        while (j < projSymbols.size()) {
            Expression projSymbol;
            Class<?> projType;
            Class firstProjType = (Class)firstProjectTypes.get(j);
            if (!firstProjType.equals(projType = (projSymbol = (Expression)projSymbols.get(j)).getType())) {
                DataTypeManagerService dataTypeManager = this.getDataTypeManager();
                String sourceType = dataTypeManager.getDataTypeName(firstProjType);
                String targetType = dataTypeManager.getDataTypeName(projType);
                String commonType = ResolverUtil.getCommonType(this.getTeiidVersion(), new String[]{sourceType, targetType});
                if (commonType == null) {
                    commonType = DataTypeManagerService.DefaultDataTypes.OBJECT.getId();
                }
                firstProjectTypes.set(j, dataTypeManager.getDataTypeClass(commonType));
            }
            ++j;
        }
    }
}

