/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.runtime.client.Messages;

public class TempTableResolver
extends CommandResolver {
    public TempTableResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws Exception {
        if (command.getType() == 11) {
            Create create = (Create)command;
            GroupSymbol group = create.getTable();
            if (group.getName().indexOf(".") != -1) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30117, group.getName()));
            }
            Collection exitsingGroups = metadata.getMetadata().getGroupsForPartialName(group.getName());
            if (!exitsingGroups.isEmpty()) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30118, group.getName()));
            }
            if (metadata.getMetadata().hasProcedure(group.getName())) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30118, group.getName()));
            }
            TempMetadataID id = metadata.getMetadataStore().getTempGroupID(group.getName());
            if (id != null && !metadata.isTemporaryTable(id)) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30118, group.getName()));
            }
            TempMetadataID tempTable = ResolverUtil.addTempTable(metadata, group, create.getColumnSymbols());
            ResolverUtil.resolveGroup(create.getTable(), metadata);
            HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
            groups.add(create.getTable());
            ResolverVisitor visitor = new ResolverVisitor(command.getTeiidVersion());
            visitor.resolveLanguageObject(command, groups, (IQueryMetadataInterface)metadata);
            TempTableResolver.addAdditionalMetadata(create, tempTable);
            tempTable.setOriginalMetadataID(create.getTableMetadata());
            if (create.getOn() != null) {
                Object mid = null;
                try {
                    mid = metadata.getModelID(create.getOn());
                }
                catch (Exception exception) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31134, create.getOn()));
                }
                if (mid != null && (metadata.isVirtualModel(mid) || !(mid instanceof Schema))) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31135, create.getOn()));
                }
                create.getTableMetadata().setParent((Schema)mid);
                tempTable.getTableData().setModel(mid);
            }
        } else if (command.getType() == 12) {
            ResolverUtil.resolveGroup(((Drop)command).getTable(), metadata);
        }
    }

    public static void addAdditionalMetadata(Create create, TempMetadataID tempTable) {
        ITeiidServerVersion teiidVersion = create.getTeiidVersion();
        if (!create.getPrimaryKey().isEmpty()) {
            ArrayList<TempMetadataID> primaryKey = new ArrayList<TempMetadataID>(create.getPrimaryKey().size());
            for (ElementSymbol symbol : create.getPrimaryKey()) {
                if (teiidVersion.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_10)) {
                    Object mid = symbol.getMetadataID();
                    if (mid instanceof TempMetadataID) {
                        primaryKey.add((TempMetadataID)mid);
                        continue;
                    }
                    if (!(mid instanceof Column)) continue;
                    primaryKey.add(tempTable.getElements().get(((Column)mid).getPosition() - 1));
                    continue;
                }
                primaryKey.add((TempMetadataID)symbol.getMetadataID());
            }
            tempTable.setPrimaryKey(primaryKey);
        }
        int i = 0;
        while (i < create.getColumns().size()) {
            Column column = create.getColumns().get(i);
            TempMetadataID tid = tempTable.getElements().get(i);
            if (column.isAutoIncremented()) {
                tid.setAutoIncrement(true);
            }
            if (column.getNullType() == BaseColumn.NullType.No_Nulls) {
                tid.setNotNull(true);
            }
            ++i;
        }
    }
}

