/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class UpdateResolver
extends ProcedureContainerResolver
implements VariableResolver {
    public UpdateResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata) throws Exception {
        Update update = (Update)command;
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(update.getGroup());
        ResolverVisitor visitor = new ResolverVisitor(command.getTeiidVersion());
        for (SetClause clause : update.getChangeList().getClauses()) {
            visitor.resolveLanguageObject(clause.getSymbol(), groups, null, metadata);
        }
        this.getQueryResolver().resolveSubqueries(command, metadata, groups);
        visitor.resolveLanguageObject(update, groups, update.getExternalGroupContexts(), metadata);
    }

    @Override
    protected String getPlan(IQueryMetadataInterface metadata, GroupSymbol group) throws Exception {
        return metadata.getUpdatePlan(group.getMetadataID());
    }

    @Override
    public Map<ElementSymbol, Expression> getVariableValues(Command command, boolean changingOnly, IQueryMetadataInterface metadata) throws Exception {
        Constant constant;
        HashMap<ElementSymbol, Expression> result = new HashMap<ElementSymbol, Expression>();
        Update update = (Update)command;
        LinkedHashMap<ElementSymbol, Expression> changing = update.getChangeList().getClauseMap();
        for (Map.Entry entry : changing.entrySet()) {
            ElementSymbol leftSymbol = ((ElementSymbol)entry.getKey()).clone();
            leftSymbol.getGroupSymbol().setName("CHANGING");
            leftSymbol.setType(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass());
            constant = (Constant)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.CONSTANT);
            constant.setValue(Boolean.TRUE);
            result.put(leftSymbol, constant);
            if (changingOnly) continue;
            leftSymbol = ((ElementSymbol)entry.getKey()).clone();
            leftSymbol.getGroupSymbol().setName("NEW");
            result.put(leftSymbol, (Expression)entry.getValue());
        }
        List<ElementSymbol> insertElmnts = ResolverUtil.resolveElementsInGroup(update.getGroup(), metadata);
        insertElmnts.removeAll(changing.keySet());
        Iterator defaultIter = insertElmnts.iterator();
        while (defaultIter.hasNext()) {
            ElementSymbol varSymbol = ((ElementSymbol)defaultIter.next()).clone();
            varSymbol.getGroupSymbol().setName("CHANGING");
            varSymbol.setType(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass());
            constant = (Constant)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.CONSTANT);
            constant.setValue(Boolean.FALSE);
            result.put(varSymbol, constant);
        }
        return result;
    }
}

