/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.util.StringUtil;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.runtime.client.Messages;

public class XMLQueryResolver
extends CommandResolver {
    public XMLQueryResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws Exception {
        this.resolveCommand((Query)command, null, metadata);
    }

    public void resolveCommand(Query query, GroupSymbol docGroup, TempMetadataAdapter metadata) throws Exception {
        ResolvingNode root;
        query.setIsXML(docGroup == null);
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroups((LanguageObject)query, true);
        GroupSymbol group = groups.iterator().next();
        boolean subQuery = true;
        if (docGroup == null) {
            docGroup = group;
            subQuery = false;
        }
        if (subQuery && group.getDefinition() != null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30129, group));
        }
        GroupContext externalGroups = query.getExternalGroupContexts();
        List<ElementSymbol> validElems = ResolverUtil.resolveElementsInGroup(docGroup, metadata);
        ResolvingNode selectRoot = root = new ResolvingNode();
        if (subQuery) {
            validElems = this.getElementsUnderNode(group.getMetadataID(), validElems, metadata);
        }
        root.addAll(validElems);
        if (subQuery) {
            MappingDocument doc = (MappingDocument)metadata.getMappingNode(docGroup.getMetadataID());
            String mc = group.getNonCorrelationName();
            LinkedList<ElementSymbol> selectElems = new LinkedList<ElementSymbol>();
            doc.acceptVisitor(new Navigator(true, new SubSelectVisitor(selectElems, root, mc)));
            selectRoot = new ResolvingNode();
            selectRoot.addAll(selectElems);
        }
        this.resolveXMLSelect(subQuery, query, group, selectRoot, metadata);
        root.addAll(this.collectTempElements(group, metadata));
        Criteria crit = query.getCriteria();
        OrderBy orderBy = query.getOrderBy();
        if (crit != null) {
            List<SubqueryContainer> commands = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(crit);
            if (!commands.isEmpty()) {
                TempMetadataAdapter tma = new TempMetadataAdapter(metadata, new TempMetadataStore());
                if (!subQuery) {
                    this.addPseudoSubqueryGroups(tma, group, docGroup);
                }
                for (SubqueryContainer subCommand : commands) {
                    this.getQueryResolver().setChildMetadata((Command)subCommand.getCommand(), query);
                    if (subCommand.getCommand() instanceof Query && this.getQueryResolver().isXMLQuery((Query)subCommand.getCommand(), tma)) {
                        this.resolveCommand((Query)subCommand.getCommand(), docGroup, tma);
                        continue;
                    }
                    this.getQueryResolver().resolveCommand((Command)subCommand.getCommand(), metadata.getMetadata());
                }
            }
            this.resolveXMLCriteria(crit, externalGroups, root, metadata);
            ResolverVisitor visitor = new ResolverVisitor(crit.getTeiidVersion());
            visitor.resolveLanguageObject(crit, (IQueryMetadataInterface)metadata);
        }
        if (orderBy != null) {
            this.resolveXMLOrderBy(orderBy, externalGroups, root, metadata);
        }
        if (query.getGroupBy() != null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30130, new Object[0]));
        }
        if (query.getHaving() != null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30131, new Object[0]));
        }
    }

    private void addPseudoSubqueryGroups(final TempMetadataAdapter metadata, GroupSymbol group, GroupSymbol docGroup) throws Exception {
        MappingDocument doc = (MappingDocument)metadata.getMappingNode(docGroup.getMetadataID());
        final String prefix = String.valueOf(group.getNonCorrelationName()) + ".";
        doc.acceptVisitor(new Navigator(true, new MappingVisitor(){

            @Override
            public void visit(MappingBaseNode baseNode) {
                if (baseNode.getSource() == null) {
                    return;
                }
                if (StringUtil.startsWithIgnoreCase(baseNode.getFullyQualifiedName(), prefix)) {
                    try {
                        GroupSymbol gs = (GroupSymbol)XMLQueryResolver.this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
                        gs.setName(baseNode.getFullyQualifiedName());
                        ResolverUtil.addTempGroup(metadata, gs, Collections.EMPTY_LIST, false).setMetadataType(TempMetadataID.Type.XML);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }));
    }

    void resolveXMLSelect(boolean subquery, Query query, GroupSymbol group, ResolvingNode validElements, IQueryMetadataInterface metadata) throws Exception {
        GroupContext externalGroups = null;
        Select select = query.getSelect();
        List<Expression> elements = select.getSymbols();
        int i = 0;
        while (i < elements.size()) {
            Expression ss = elements.get(i);
            if (ss instanceof ElementSymbol) {
                ElementSymbol es = (ElementSymbol)ss;
                String symbolName = es.getName();
                if (!subquery && (symbolName.equalsIgnoreCase("xml") || symbolName.equalsIgnoreCase(String.valueOf(group.getName()) + ".xml"))) {
                    if (elements.size() != 1) {
                        throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30133, new Object[0]));
                    }
                    select.clearSymbols();
                    MultipleElementSymbol all = (MultipleElementSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.MULTIPLE_ELEMENT_SYMBOL);
                    all.setElementSymbols(validElements.values());
                    select.addSymbol(all);
                    query.setSelect(select);
                    return;
                }
                this.resolveElement(es, validElements, externalGroups, metadata);
            } else if (ss instanceof MultipleElementSymbol) {
                MultipleElementSymbol all = (MultipleElementSymbol)ss;
                if (all.getGroup() == null || all.getGroup().getName().equalsIgnoreCase(group.getName())) {
                    all.setElementSymbols(validElements.values());
                    return;
                }
                ElementSymbol elementSymbol = (ElementSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
                elementSymbol.setName(all.getGroup().getName());
                this.resolveElement(elementSymbol, validElements, externalGroups, metadata);
                List<ElementSymbol> elementsInNode = this.getElementsUnderNode(elementSymbol.getMetadataID(), validElements.values(), metadata);
                all.setElementSymbols(elementsInNode);
            } else {
                if (ss instanceof ExpressionSymbol) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30134, new Object[0]));
                }
                if (ss instanceof AliasSymbol) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30135, new Object[0]));
                }
            }
            ++i;
        }
    }

    public Collection<ElementSymbol> collectTempElements(GroupSymbol group, IQueryMetadataInterface metadata) throws Exception {
        ArrayList<ElementSymbol> validElements = new ArrayList<ElementSymbol>();
        Collection tempGroups = metadata.getXMLTempGroups(group.getMetadataID());
        for (Object tempGroupID : tempGroups) {
            String name = metadata.getFullName(tempGroupID);
            GroupSymbol tempGroup = (GroupSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
            tempGroup.setName(name);
            tempGroup.setMetadataID(tempGroupID);
            validElements.addAll(ResolverUtil.resolveElementsInGroup(tempGroup, metadata));
        }
        return validElements;
    }

    public void resolveXMLCriteria(LanguageObject criteria, GroupContext externalGroups, ResolvingNode validElements, IQueryMetadataInterface metadata) throws Exception {
        Collection<ElementSymbol> critElems = ElementCollectorVisitor.getElements(criteria, false);
        for (ElementSymbol critElem : critElems) {
            if (critElem.isExternalReference()) continue;
            this.resolveElement(critElem, validElements, externalGroups, metadata);
        }
    }

    void resolveXMLOrderBy(OrderBy orderBy, GroupContext externalGroups, ResolvingNode validElements, IQueryMetadataInterface metadata) throws Exception {
        Collection<ElementSymbol> orderElems = ElementCollectorVisitor.getElements((LanguageObject)orderBy, false);
        for (ElementSymbol orderElem : orderElems) {
            this.resolveElement(orderElem, validElements, externalGroups, metadata);
        }
    }

    void resolveElement(ElementSymbol elem, ResolvingNode validElements, GroupContext externalGroups, IQueryMetadataInterface metadata) throws Exception {
        String partialName;
        String fullName = partialName = elem.getName();
        ResolvingNode current = validElements;
        String part = partialName;
        int i = 0;
        while (partialName != null) {
            int index = partialName.lastIndexOf(46);
            if (index < 0) {
                part = partialName;
                partialName = null;
            } else {
                part = partialName.substring(index + 1, partialName.length());
                partialName = partialName.substring(0, index);
            }
            current = current.children.get(part);
            if (current == null && (i != 0 || part.charAt(0) == '@' || (current = validElements.children.get(part = String.valueOf('@') + part)) == null)) {
                try {
                    ResolverVisitor visitor = new ResolverVisitor(elem.getTeiidVersion());
                    visitor.resolveLanguageObject(elem, Collections.EMPTY_LIST, externalGroups, metadata);
                    return;
                }
                catch (Exception exception) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30136, fullName));
                }
            }
            ++i;
        }
        List<ElementSymbol> partialMatches = current.values();
        if (partialMatches.size() != 1) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30137, fullName));
        }
        ElementSymbol exactMatch = partialMatches.get(0);
        String name = elem.getOutputName();
        elem.setShortName(exactMatch.getShortName());
        elem.setMetadataID(exactMatch.getMetadataID());
        elem.setType(exactMatch.getType());
        elem.setGroupSymbol(exactMatch.getGroupSymbol());
        if (metadata.useOutputName()) {
            elem.setOutputName(name);
        }
    }

    List<ElementSymbol> getElementsUnderNode(Object mid, Collection<ElementSymbol> validElements, IQueryMetadataInterface metadata) throws Exception {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        String nodeName = metadata.getFullName(mid);
        for (ElementSymbol validElement : validElements) {
            String qualifiedName = validElement.getName();
            if (!StringUtil.startsWithIgnoreCase(qualifiedName, nodeName) || qualifiedName.length() != nodeName.length() && qualifiedName.charAt(nodeName.length()) != '.') continue;
            elements.add(validElement);
        }
        return elements;
    }

    private final class ResolvingNode {
        ElementSymbol elementSymbol;
        TreeMap<String, ResolvingNode> children = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        private ResolvingNode() {
        }

        public void add(String name, ElementSymbol symbol) {
            if (name == null) {
                this.elementSymbol = symbol;
                return;
            }
            int index = name.lastIndexOf(46);
            String childName = name;
            if (index >= 0) {
                childName = name.substring(0, index);
                name = name.substring(index + 1, name.length());
            } else {
                childName = null;
            }
            ResolvingNode child = this.children.get(name);
            if (child == null) {
                child = new ResolvingNode();
                this.children.put(name, child);
            }
            child.add(childName, symbol);
        }

        public <T extends Collection<ElementSymbol>> T values(T values) {
            if (this.elementSymbol != null) {
                values.add((ElementSymbol)this.elementSymbol);
            }
            for (ResolvingNode node : this.children.values()) {
                node.values(values);
            }
            return values;
        }

        public ElementSymbol find(String name) {
            int index = name.lastIndexOf(46);
            String part = name;
            if (index > 0) {
                part = name.substring(index + 1, name.length());
                name = name.substring(0, index);
            } else {
                name = null;
            }
            ResolvingNode r = this.children.get(part);
            if (r == null) {
                return null;
            }
            if (name == null) {
                return r.elementSymbol;
            }
            return r.find(name);
        }

        public void addAll(Collection<ElementSymbol> elems) {
            for (ElementSymbol es : elems) {
                this.add(es.getName(), es);
            }
        }

        public List<ElementSymbol> values() {
            return this.values(new LinkedList());
        }
    }

    private final class SubSelectVisitor
    extends MappingVisitor {
        private final List<ElementSymbol> selectElems;
        private final ResolvingNode root;
        private final String mc;
        private String source;

        private SubSelectVisitor(List<ElementSymbol> selectElems, ResolvingNode root, String mc) {
            this.selectElems = selectElems;
            this.root = root;
            this.mc = mc;
        }

        @Override
        public void visit(MappingBaseNode baseNode) {
            if (baseNode.getSource() != null && baseNode.getFullyQualifiedName().equalsIgnoreCase(this.mc)) {
                this.source = baseNode.getSource();
            }
        }

        @Override
        public void visit(MappingElement element) {
            this.visit((MappingBaseNode)element);
            String nis = element.getNameInSource();
            this.getMappingClassColumn(nis, element.getFullyQualifiedName());
        }

        private void getMappingClassColumn(String nis, String fqn) {
            if (nis == null || this.source == null) {
                return;
            }
            String name = nis.substring(0, nis.lastIndexOf(46));
            if (this.source.equalsIgnoreCase(name)) {
                this.selectElems.add(this.root.find(fqn));
            }
        }

        @Override
        public void visit(MappingAttribute attribute) {
            this.getMappingClassColumn(attribute.getNameInSource(), attribute.getFullyQualifiedName());
        }
    }
}

