/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.StringUtil;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.query.sql.IResolverVisitor;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.GroupInfo;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.IsDistinctCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.proc.ExceptionExpression;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.XMLExists;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.symbol.v7.Aggregate7Symbol;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class ResolverVisitor
extends LanguageVisitor
implements IResolverVisitor<LanguageObject, GroupSymbol> {
    public static final String TEIID_PASS_THROUGH_TYPE = "teiid:pass-through-type";
    private static final String SYS_PREFIX = "SYS.";
    @Removed(value=TeiidServerVersion.Version.TEIID_8_5)
    private ThreadLocal<Boolean> determinePartialName = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Collection<GroupSymbol> groups;
    private GroupContext externalContext;
    protected IQueryMetadataInterface metadata;
    private Exception componentException;
    private Exception resolverException;
    private Map<Function, Exception> unresolvedFunctions;
    private boolean findShortName;
    private List<ElementSymbol> matches = new ArrayList<ElementSymbol>(2);
    private List<GroupSymbol> groupMatches = new ArrayList<GroupSymbol>(2);
    @Since(value=TeiidServerVersion.Version.TEIID_8_6)
    private boolean hasUserDefinedAggregate;

    public ResolverVisitor(ITeiidServerVersion teiidVersion) {
        super(teiidVersion);
    }

    public ResolverVisitor(ITeiidServerVersion teiidVersion, IQueryMetadataInterface metadata, Collection<GroupSymbol> internalGroups, GroupContext externalContext) {
        this(teiidVersion);
        this.groups = internalGroups;
        this.externalContext = externalContext;
        this.metadata = metadata;
        this.setFindShortName(metadata);
    }

    private void setFindShortName(IQueryMetadataInterface metadata) {
        this.findShortName = this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_5) ? metadata.findShortName() : this.determinePartialName.get().booleanValue();
    }

    public void setGroups(Collection<GroupSymbol> groups) {
        this.groups = groups;
    }

    @Override
    public void visit(ElementSymbol obj) {
        try {
            this.resolveElementSymbol(obj);
        }
        catch (Exception e) {
            this.handleException(this.handleUnresolvedElement(obj, e.getMessage()));
        }
    }

    private QueryResolverException handleUnresolvedElement(ElementSymbol symbol, String description) {
        UnresolvedSymbolDescription usd = new UnresolvedSymbolDescription(symbol.toString(), description);
        QueryResolverException e = new QueryResolverException(usd.getDescription());
        e.setUnresolvedSymbols(Arrays.asList(usd));
        return e;
    }

    private void resolveElementSymbol(ElementSymbol elementSymbol) throws Exception {
        if (elementSymbol.getMetadataID() != null) {
            return;
        }
        String groupContext = null;
        if (elementSymbol.getGroupSymbol() != null) {
            groupContext = elementSymbol.getGroupSymbol().getName();
        }
        String elementShortName = elementSymbol.getShortName();
        if (groupContext != null) {
            groupContext = elementSymbol.getGroupSymbol().getName();
            try {
                if (this.findShortName && this.internalResolveElementSymbol(elementSymbol, null, elementShortName, groupContext)) {
                    elementSymbol.setDisplayMode(IElementSymbol.DisplayMode.SHORT_OUTPUT_NAME);
                    return;
                }
            }
            catch (Exception exception) {}
        }
        this.internalResolveElementSymbol(elementSymbol, groupContext, elementShortName, null);
    }

    private boolean internalResolveElementSymbol(ElementSymbol elementSymbol, String groupContext, String shortCanonicalName, String expectedGroupContext) throws Exception {
        List<GroupSymbol> matchedGroups;
        boolean isExternal = false;
        boolean groupMatched = false;
        GroupContext root = null;
        if (this.groups != null || this.externalContext != null) {
            if (this.groups != null) {
                root = new GroupContext(this.externalContext, this.groups);
            }
            if (root == null) {
                isExternal = true;
                root = this.externalContext;
            }
        } else {
            try {
                matchedGroups = new LinkedList<GroupSymbol>();
                if (groupContext != null) {
                    Object groupID = this.metadata.getGroupID(groupContext);
                    GroupSymbol groupSymbol = (GroupSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
                    groupSymbol.setName(groupContext);
                    groupSymbol.setMetadataID(groupID);
                    ((LinkedList)matchedGroups).add(groupSymbol);
                }
                root = new GroupContext(null, matchedGroups);
            }
            catch (Exception exception) {}
        }
        this.matches.clear();
        this.groupMatches.clear();
        while (root != null) {
            matchedGroups = ResolverUtil.findMatchingGroups(groupContext, root.getGroups(), this.metadata);
            if (matchedGroups != null && !matchedGroups.isEmpty()) {
                groupMatched = true;
                this.resolveAgainstGroups(shortCanonicalName, matchedGroups);
                if (this.matches.size() > 1) {
                    throw this.handleUnresolvedElement(elementSymbol, Messages.gs(Messages.TEIID.TEIID31117, elementSymbol, this.groupMatches));
                }
                if (this.matches.size() == 1) break;
            }
            root = root.getParent();
            isExternal = true;
        }
        if (this.matches.isEmpty()) {
            if (groupMatched) {
                throw this.handleUnresolvedElement(elementSymbol, Messages.gs(Messages.TEIID.TEIID31118, elementSymbol));
            }
            throw this.handleUnresolvedElement(elementSymbol, Messages.gs(Messages.TEIID.TEIID31119, elementSymbol));
        }
        ElementSymbol resolvedSymbol = this.matches.get(0);
        GroupSymbol resolvedGroup = this.groupMatches.get(0);
        String oldName = elementSymbol.getOutputName();
        if (expectedGroupContext != null && !ResolverUtil.nameMatchesGroup(expectedGroupContext, resolvedGroup.getName())) {
            return false;
        }
        elementSymbol.setIsExternalReference(isExternal);
        elementSymbol.setType(resolvedSymbol.getType());
        elementSymbol.setMetadataID(resolvedSymbol.getMetadataID());
        elementSymbol.setGroupSymbol(resolvedGroup);
        elementSymbol.setShortName(resolvedSymbol.getShortName());
        if (this.metadata.useOutputName()) {
            elementSymbol.setOutputName(oldName);
        }
        return true;
    }

    private void resolveAgainstGroups(String elementShortName, Collection<GroupSymbol> matchedGroups) throws Exception {
        for (GroupSymbol group : matchedGroups) {
            GroupInfo groupInfo = ResolverUtil.getGroupInfo(group, this.metadata);
            ElementSymbol result = groupInfo.getSymbol(elementShortName);
            if (result == null) continue;
            this.matches.add(result);
            this.groupMatches.add(group);
        }
    }

    @Override
    public void visit(BetweenCriteria obj) {
        try {
            this.resolveBetweenCriteria(obj);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CompareCriteria obj) {
        try {
            this.resolveCompareCriteria(obj);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(MatchCriteria obj) {
        try {
            this.resolveMatchCriteria(obj);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SetCriteria obj) {
        try {
            this.resolveSetCriteria(obj);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        try {
            obj.setLeftExpression(ResolverUtil.resolveSubqueryPredicateCriteria(obj.getLeftExpression(), obj, this.metadata));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        try {
            obj.setExpression(ResolverUtil.resolveSubqueryPredicateCriteria((Expression)obj.getExpression(), obj, this.metadata));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(IsNullCriteria obj) {
        try {
            this.setDesiredType(obj.getExpression(), DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass(), obj);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(IsDistinctCriteria isDistinctCriteria) {
        try {
            ResolverUtil.resolveGroup(isDistinctCriteria.getLeftRowValue(), this.metadata);
            ResolverUtil.resolveGroup(isDistinctCriteria.getRightRowValue(), this.metadata);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(Function obj) {
        try {
            this.resolveFunction(obj, (FunctionLibrary)this.metadata.getFunctionLibrary());
            if (obj.isAggregate() && this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_6)) {
                this.hasUserDefinedAggregate = true;
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && (msg.contains(Messages.TEIID.TEIID30069.name()) || msg.contains(Messages.TEIID.TEIID30067.name()))) {
                if (this.unresolvedFunctions == null) {
                    this.unresolvedFunctions = new LinkedHashMap<Function, Exception>();
                }
                this.unresolvedFunctions.put(obj, e);
            }
            this.handleException(e);
        }
    }

    @Override
    public void visit(Array array) {
        try {
            if (array.getComponentType() != null) {
                String type = this.getDataTypeManager().getDataTypeName(array.getComponentType());
                int i = 0;
                while (i < array.getExpressions().size()) {
                    Expression expr = array.getExpressions().get(i);
                    this.setDesiredType(expr, array.getComponentType(), array);
                    if (array.getComponentType() != DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass()) {
                        array.getExpressions().set(i, ResolverUtil.convertExpression(expr, type, this.metadata));
                    }
                    ++i;
                }
            } else {
                Class<?> type = null;
                int i = 0;
                while (i < array.getExpressions().size()) {
                    Expression expr = array.getExpressions().get(i);
                    Class<?> baseType = expr.getType();
                    while (baseType != null && baseType.isArray()) {
                        baseType = baseType.getComponentType();
                    }
                    if (baseType != DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass()) {
                        if (type == null) {
                            type = expr.getType();
                        } else if (type != expr.getType()) {
                            type = DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass();
                        }
                    }
                    ++i;
                }
                if (type == null) {
                    type = DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass();
                }
                array.setComponentType(type);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CaseExpression obj) {
        try {
            this.resolveCaseExpression(obj);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        try {
            this.resolveSearchedCaseExpression(obj);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SetClause obj) {
        String type = this.getDataTypeManager().getDataTypeName(obj.getSymbol().getType());
        try {
            this.setDesiredType(obj.getValue(), obj.getSymbol().getType(), obj);
            obj.setValue(ResolverUtil.convertExpression(obj.getValue(), type, this.metadata));
        }
        catch (Exception e) {
            this.handleException(new QueryResolverException(e, Messages.getString(Messages.QueryResolver.setClauseResolvingError, obj.getValue(), obj.getSymbol(), type)));
        }
    }

    @Override
    public void visit(XMLSerialize obj) {
        try {
            obj.setExpression(ResolverUtil.convertExpression(obj.getExpression(), DataTypeManagerService.DefaultDataTypes.XML.getId(), this.metadata));
        }
        catch (Exception e) {
            this.handleException(new QueryResolverException(e, Messages.getString(Messages.QueryResolver.xmlSerializeResolvingError, obj)));
        }
    }

    @Override
    public void visit(XMLQuery obj) {
        try {
            ResolverUtil.setDesiredType(obj.getPassing(), obj);
            obj.compileXqueryExpression();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    public void visit(XMLExists obj) {
        this.visit(obj.getXmlQuery());
    }

    @Override
    public void visit(QueryString obj) {
        try {
            obj.setPath(ResolverUtil.convertExpression(obj.getPath(), DataTypeManagerService.DefaultDataTypes.STRING.getId(), this.metadata));
            for (DerivedColumn col : obj.getArgs()) {
                col.setExpression(ResolverUtil.convertExpression(col.getExpression(), DataTypeManagerService.DefaultDataTypes.STRING.getId(), this.metadata));
            }
        }
        catch (Exception e) {
            this.handleException(new QueryResolverException(e, Messages.getString(Messages.QueryResolver.xmlQueryResolvingError, obj)));
        }
    }

    @Override
    public void visit(ExpressionCriteria obj) {
        try {
            obj.setExpression(ResolverUtil.convertExpression(obj.getExpression(), DataTypeManagerService.DefaultDataTypes.BOOLEAN.getId(), this.metadata));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(ExceptionExpression obj) {
        try {
            if (obj.getErrorCode() != null) {
                obj.setErrorCode(ResolverUtil.convertExpression(obj.getErrorCode(), DataTypeManagerService.DefaultDataTypes.INTEGER.getId(), this.metadata));
            }
            obj.setMessage(ResolverUtil.convertExpression(obj.getMessage(), DataTypeManagerService.DefaultDataTypes.STRING.getId(), this.metadata));
            if (obj.getSqlState() != null) {
                obj.setSqlState(ResolverUtil.convertExpression(obj.getSqlState(), DataTypeManagerService.DefaultDataTypes.STRING.getId(), this.metadata));
            }
            ResolverVisitor.checkException(obj.getParent());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public static void checkException(Expression obj) throws QueryResolverException {
        if (obj == null || obj instanceof ExceptionExpression) {
            return;
        }
        if (obj instanceof ElementSymbol) {
            ElementSymbol es = (ElementSymbol)obj;
            if (!(es.getMetadataID() instanceof TempMetadataID)) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31120, obj));
            }
            TempMetadataID tid = (TempMetadataID)es.getMetadataID();
            if (tid.getType() != Exception.class) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31120, obj));
            }
        } else if (obj instanceof Constant) {
            Constant c = (Constant)obj;
            if (!(c.getValue() instanceof Exception)) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31120, obj));
            }
        } else {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31120, obj));
        }
    }

    @Override
    public void visit(AggregateSymbol obj) {
        if (obj.getCondition() != null) {
            try {
                obj.setCondition(ResolverUtil.convertExpression(obj.getCondition(), DataTypeManagerService.DefaultDataTypes.BOOLEAN.getId(), this.metadata));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (obj instanceof Aggregate7Symbol) {
            return;
        }
        switch (obj.getAggregateFunction()) {
            case USER_DEFINED: {
                this.visit((Function)((Object)obj));
                break;
            }
            case STRING_AGG: {
                try {
                    if (obj.getArgs().length != 2) {
                        throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31140, obj));
                    }
                    if (obj.getType() != null) break;
                    Expression arg = obj.getArg(0);
                    Expression arg1 = obj.getArg(1);
                    Class<?> type = null;
                    if (this.isBinary(arg)) {
                        this.setDesiredType(arg1, DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass(), obj);
                        if (this.isBinary(arg1)) {
                            type = DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass();
                        }
                    } else if (this.isCharacter(arg, false)) {
                        this.setDesiredType(arg1, DataTypeManagerService.DefaultDataTypes.CLOB.getTypeClass(), obj);
                        if (this.isCharacter(arg1, false)) {
                            type = DataTypeManagerService.DefaultDataTypes.CLOB.getTypeClass();
                        }
                    } else if (arg.getType() == null) {
                        if (this.isBinary(arg1)) {
                            this.setDesiredType(arg, DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass(), obj);
                            if (this.isBinary(arg)) {
                                type = DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass();
                            }
                        } else if (this.isCharacter(arg1, false)) {
                            this.setDesiredType(arg, DataTypeManagerService.DefaultDataTypes.CLOB.getTypeClass(), obj);
                            if (this.isCharacter(arg, false)) {
                                type = DataTypeManagerService.DefaultDataTypes.CLOB.getTypeClass();
                            }
                        }
                    }
                    if (type == null) {
                        throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31141, obj));
                    }
                    obj.setType(type);
                    break;
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
    }

    private boolean isCharacter(Expression arg, boolean includeChar) {
        Class<?> type = arg.getType();
        return ResolverVisitor.isCharacter(type, includeChar);
    }

    static boolean isCharacter(Class<?> type, boolean includeChar) {
        return type == DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass() || type == DataTypeManagerService.DefaultDataTypes.CLOB.getTypeClass() || includeChar && type == DataTypeManagerService.DefaultDataTypes.CHAR.getTypeClass();
    }

    private boolean isBinary(Expression arg) {
        return arg.getType() == DataTypeManagerService.DefaultDataTypes.VARBINARY.getTypeClass() || arg.getType() == DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass();
    }

    public Exception getComponentException() {
        return this.componentException;
    }

    public Exception getResolverException() {
        return this.resolverException;
    }

    void handleException(Exception e) {
        this.componentException = e;
        this.setAbort(true);
    }

    public void throwException(boolean includeUnresolvedFunctions) throws Exception {
        if (this.getComponentException() != null) {
            throw this.getComponentException();
        }
        if (this.getResolverException() != null) {
            throw this.getResolverException();
        }
        if (includeUnresolvedFunctions && this.unresolvedFunctions != null && !this.unresolvedFunctions.isEmpty()) {
            throw this.unresolvedFunctions.values().iterator().next();
        }
    }

    void resolveFunction(Function function, FunctionLibrary library) throws Exception {
        List<FunctionDescriptor> fds;
        if (function.getFunctionDescriptor() != null) {
            return;
        }
        boolean hasArgWithoutType = false;
        Expression[] args = function.getArgs();
        Class[] types = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            types[i] = args[i].getType();
            if (types[i] == null) {
                if (!(args[i] instanceof Reference)) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30067, args[i], function));
                }
                hasArgWithoutType = true;
            }
            ++i;
        }
        if (FunctionLibrary.isConvert(function) && hasArgWithoutType) {
            Constant constant = (Constant)function.getArg(1);
            Class<?> type = this.getDataTypeManager().getDataTypeClass((String)constant.getValue());
            this.setDesiredType(function.getArg(0), type, function);
            types[0] = type;
            hasArgWithoutType = false;
        }
        try {
            fds = this.findWithImplicitConversions(library, function, args, types, hasArgWithoutType);
            if (fds.isEmpty()) {
                if (!library.hasFunctionMethod(function.getName(), args.length)) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30068, function));
                }
                if (hasArgWithoutType) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30069, function));
                }
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30070, function));
            }
            if (fds.size() > 1) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31150, function));
            }
        }
        catch (Exception e) {
            if (e instanceof QueryResolverException) {
                throw e;
            }
            if (hasArgWithoutType) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30069, function));
            }
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31150, function));
        }
        FunctionDescriptor fd = fds.get(0);
        if (fd.getMethod().isVarArgs() && fd.getTypes().length == types.length && library.isVarArgArrayParam(fd.getMethod(), types, types.length - 1, fd.getTypes()[types.length - 1])) {
            fd = fd.clone();
            fd.setCalledWithVarArgArrayParam(true);
        }
        if (fd.isSystemFunction(IFunctionLibrary.FunctionName.CONVERT) || fd.isSystemFunction(IFunctionLibrary.FunctionName.CAST)) {
            String dataType = (String)((Constant)args[1]).getValue();
            Class<?> dataTypeClass = this.getDataTypeManager().getDataTypeClass(dataType);
            fd = library.findTypedConversionFunction(args[0].getType(), dataTypeClass);
            Class<?> srcTypeClass = args[0].getType();
            if (srcTypeClass != null && dataTypeClass != null && !srcTypeClass.equals(dataTypeClass) && !this.getDataTypeManager().isTransformable(srcTypeClass, dataTypeClass)) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30071, this.getDataTypeManager().getDataTypeName(srcTypeClass), dataType));
            }
        } else if (fd.isSystemFunction(IFunctionLibrary.FunctionName.LOOKUP)) {
            ResolverUtil.ResolvedLookup lookup = ResolverUtil.resolveLookup(function, this.metadata);
            fd = library.copyFunctionChangeReturnType(fd, lookup.getReturnElement().getType());
        } else if (fd.isSystemFunction(IFunctionLibrary.FunctionName.ARRAY_GET) && args[0].getType().isArray()) {
            if (args[0].getType() != null && args[0].getType().isArray()) {
                fd = library.copyFunctionChangeReturnType(fd, args[0].getType().getComponentType());
            } else {
                if (function.getType() != null) {
                    this.setDesiredType(args[0], function.getType(), function);
                }
                if (args[0].getType() != DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass()) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31145, this.getDataTypeManager().getDataTypeName(args[0].getType()), function));
                }
            }
        } else if (Boolean.valueOf(fd.getMethod().getProperty(TEIID_PASS_THROUGH_TYPE, false)).booleanValue()) {
            fd = library.copyFunctionChangeReturnType(fd, args[0].getType());
        }
        function.setFunctionDescriptor(fd);
        function.setType(fd.getReturnType());
        if ("SYS".equals(fd.getSchema()) && StringUtil.startsWithIgnoreCase(function.getName(), SYS_PREFIX)) {
            function.setName(function.getName().substring(SYS_PREFIX.length()));
        }
    }

    private List<FunctionDescriptor> findWithImplicitConversions(FunctionLibrary library, Function function, Expression[] args, Class<?>[] types, boolean hasArgWithoutType) throws Exception {
        FunctionLibrary.ConversionResult cr = null;
        try {
            cr = library.determineNecessaryConversions(function.getName(), function.getType(), args, types, hasArgWithoutType);
        }
        catch (Exception ex) {
            if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_9)) {
                return Collections.emptyList();
            }
            throw ex;
        }
        if (cr.method == null && this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_9)) {
            return Collections.emptyList();
        }
        Class<?>[] newSignature = types;
        if (cr.needsConverion) {
            FunctionDescriptor[] conversions = library.getConverts(cr.method, types);
            newSignature = new Class[conversions.length];
            int i = 0;
            while (i < conversions.length) {
                Class<?> newType = types[i];
                if (conversions[i] != null) {
                    newType = conversions[i].getReturnType();
                    this.setDesiredType(args[i], newType, function);
                    if (types[i] != null && newType != DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass()) {
                        if (args[i] instanceof Constant && newType == DataTypeManagerService.DefaultDataTypes.TIMESTAMP.getTypeClass()) {
                            args[i] = ResolverUtil.getProperlyTypedConstant(((Constant)args[i]).getValue(), newType, this.getTeiidParser());
                        } else {
                            function.insertConversion(i, conversions[i]);
                        }
                    }
                }
                newSignature[i] = newType;
                ++i;
            }
        }
        String name = cr.method != null && cr.method.getFullName() != null ? cr.method.getFullName() : function.getName();
        return library.findAllFunctions(name, newSignature);
    }

    void resolveBetweenCriteria(BetweenCriteria criteria) throws Exception {
        Expression exp = criteria.getExpression();
        Expression lower = criteria.getLowerExpression();
        Expression upper = criteria.getUpperExpression();
        this.setDesiredType(exp, lower.getType() == null ? upper.getType() : lower.getType(), criteria);
        this.setDesiredType(lower, exp.getType(), criteria);
        this.setDesiredType(upper, exp.getType(), criteria);
        if (exp.getType().equals(lower.getType()) && exp.getType().equals(upper.getType())) {
            return;
        }
        String expTypeName = this.getDataTypeManager().getDataTypeName(exp.getType());
        String lowerTypeName = this.getDataTypeManager().getDataTypeName(lower.getType());
        String upperTypeName = this.getDataTypeManager().getDataTypeName(upper.getType());
        String[] types = new String[]{lowerTypeName, upperTypeName};
        Class<?> type = null;
        String commonType = ResolverUtil.getCommonType(this.getTeiidVersion(), types);
        if (commonType != null) {
            type = this.getDataTypeManager().getDataTypeClass(commonType);
        }
        boolean exprChar = this.isCharacter(exp, true);
        if (exp.getType() != DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass()) {
            boolean success = true;
            if (!exprChar || this.metadata.widenComparisonToString() || this.isCharacter(lower, true)) {
                try {
                    criteria.setLowerExpression(ResolverUtil.convertExpression(lower, lowerTypeName, expTypeName, this.metadata));
                    lower = criteria.getLowerExpression();
                    lowerTypeName = this.getDataTypeManager().getDataTypeName(lower.getType());
                }
                catch (QueryResolverException e) {
                    if (lower instanceof Constant && this.isCharacter(lower, true) && !this.metadata.widenComparisonToString()) {
                        throw e;
                    }
                    if (type == null) {
                        type = lower.getType();
                    }
                    success = false;
                }
            } else {
                success = false;
            }
            if (!exprChar || this.metadata.widenComparisonToString() || this.isCharacter(upper, true)) {
                try {
                    criteria.setUpperExpression(ResolverUtil.convertExpression(upper, upperTypeName, expTypeName, this.metadata));
                    upper = criteria.getUpperExpression();
                    upperTypeName = this.getDataTypeManager().getDataTypeName(upper.getType());
                }
                catch (QueryResolverException e) {
                    if (lower instanceof Constant && this.isCharacter(lower, true) && !this.metadata.widenComparisonToString()) {
                        throw e;
                    }
                    if (type == null) {
                        type = upper.getType();
                    }
                    success = false;
                }
            } else {
                success = false;
            }
            if (success) {
                return;
            }
        }
        if (type == null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30072, expTypeName, lowerTypeName, criteria));
        }
        String typeName = this.getDataTypeManager().getDataTypeName(type);
        if (!ResolverVisitor.isCharacter(type, true) || this.metadata.widenComparisonToString() || exp.getType() == DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass()) {
            criteria.setExpression(ResolverUtil.convertExpression(exp, expTypeName, typeName, this.metadata));
        } else if (type != exp.getType()) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31172, criteria));
        }
        if (lower.getType() != type) {
            if (!this.metadata.widenComparisonToString() && exprChar ^ this.isCharacter(lower, true)) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31172, criteria));
            }
            criteria.setLowerExpression(ResolverUtil.convertExpression(lower, lowerTypeName, typeName, this.metadata));
        }
        if (upper.getType() != type) {
            if (!this.metadata.widenComparisonToString() && exprChar ^ this.isCharacter(lower, true)) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31172, criteria));
            }
            criteria.setUpperExpression(ResolverUtil.convertExpression(upper, upperTypeName, typeName, this.metadata));
        }
    }

    void resolveCompareCriteria(CompareCriteria ccrit) throws Exception {
        boolean rightChar;
        boolean leftChar;
        String rightTypeName;
        String leftTypeName;
        Expression rightExpression;
        IExpression leftExpression;
        block14: {
            block13: {
                leftExpression = ccrit.getLeftExpression();
                rightExpression = ccrit.getRightExpression();
                this.setDesiredType((Expression)leftExpression, rightExpression.getType(), ccrit);
                this.setDesiredType(rightExpression, leftExpression.getType(), ccrit);
                if (leftExpression.getType() == rightExpression.getType()) {
                    return;
                }
                leftTypeName = this.getDataTypeManager().getDataTypeName(leftExpression.getType());
                rightTypeName = this.getDataTypeManager().getDataTypeName(rightExpression.getType());
                if (leftExpression.getType() == DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass()) {
                    ccrit.setLeftExpression(ResolverUtil.convertExpression((Expression)leftExpression, leftTypeName, rightTypeName, this.metadata));
                    return;
                }
                if (rightExpression.getType() == DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass()) {
                    ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName, this.metadata));
                    return;
                }
                leftChar = this.isCharacter((Expression)leftExpression, true);
                rightChar = this.isCharacter(rightExpression, true);
                if (rightExpression instanceof Constant && !leftChar) {
                    try {
                        ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName, this.metadata));
                        return;
                    }
                    catch (Exception qre) {
                        if (!rightChar || this.metadata.widenComparisonToString()) break block13;
                        throw qre;
                    }
                }
            }
            if (leftExpression instanceof Constant && !rightChar) {
                try {
                    ccrit.setLeftExpression(ResolverUtil.convertExpression((Expression)leftExpression, leftTypeName, rightTypeName, this.metadata));
                    return;
                }
                catch (Exception qre) {
                    if (!leftChar || this.metadata.widenComparisonToString()) break block14;
                    throw qre;
                }
            }
        }
        if (rightChar ^ leftChar && !this.metadata.widenComparisonToString()) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31172, ccrit));
        }
        if (ResolverUtil.canImplicitlyConvert(this.getTeiidVersion(), leftTypeName, rightTypeName)) {
            ccrit.setLeftExpression(ResolverUtil.convertExpression((Expression)leftExpression, leftTypeName, rightTypeName, this.metadata));
            return;
        }
        if (ResolverUtil.canImplicitlyConvert(this.getTeiidVersion(), rightTypeName, leftTypeName)) {
            ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName, this.metadata));
            return;
        }
        String commonType = ResolverUtil.getCommonType(this.getTeiidVersion(), new String[]{leftTypeName, rightTypeName});
        if (commonType == null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30072, leftTypeName, rightTypeName, ccrit));
        }
        ccrit.setLeftExpression(ResolverUtil.convertExpression((Expression)leftExpression, leftTypeName, commonType, this.metadata));
        ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, commonType, this.metadata));
    }

    void resolveMatchCriteria(MatchCriteria mcrit) throws Exception {
        this.setDesiredType(mcrit.getLeftExpression(), mcrit.getRightExpression().getType(), mcrit);
        mcrit.setLeftExpression(this.resolveMatchCriteriaExpression(mcrit, mcrit.getLeftExpression()));
        this.setDesiredType(mcrit.getRightExpression(), mcrit.getLeftExpression().getType(), mcrit);
        mcrit.setRightExpression(this.resolveMatchCriteriaExpression(mcrit, mcrit.getRightExpression()));
    }

    Expression resolveMatchCriteriaExpression(MatchCriteria mcrit, Expression expr) throws Exception {
        String type = this.getDataTypeManager().getDataTypeName(expr.getType());
        Expression result = expr;
        if (type != null && !this.isCharacter(expr, false)) {
            if (ResolverUtil.canImplicitlyConvert(this.getTeiidVersion(), type, DataTypeManagerService.DefaultDataTypes.STRING.getId())) {
                result = ResolverUtil.convertExpression(expr, type, DataTypeManagerService.DefaultDataTypes.STRING.getId(), this.metadata);
            } else if (ResolverUtil.canImplicitlyConvert(this.getTeiidVersion(), type, DataTypeManagerService.DefaultDataTypes.CLOB.getId())) {
                result = ResolverUtil.convertExpression(expr, type, DataTypeManagerService.DefaultDataTypes.CLOB.getId(), this.metadata);
            } else {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30074, mcrit));
            }
        }
        return result;
    }

    void resolveSetCriteria(SetCriteria scrit) throws Exception {
        Class<?> exprType = scrit.getExpression().getType();
        if (exprType == null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30075, scrit.getExpression()));
        }
        boolean same = true;
        Iterator<Expression> valIter = scrit.getValues().iterator();
        String[] types = new String[scrit.getValues().size()];
        int i = 0;
        Class<?> type = null;
        while (valIter.hasNext()) {
            Expression value = valIter.next();
            if (value.getType() != exprType) {
                same = false;
            }
            types[i++] = this.getDataTypeManager().getDataTypeName(value.getType());
            type = value.getType();
        }
        if (same && type == exprType) {
            return;
        }
        if (!same) {
            String commonType = ResolverUtil.getCommonType(this.getTeiidVersion(), types);
            type = commonType != null ? this.getDataTypeManager().getDataTypeClass(commonType) : null;
        }
        String exprTypeName = this.getDataTypeManager().getDataTypeName(exprType);
        boolean attemptConvert = !ResolverVisitor.isCharacter(exprType, true) || this.metadata.widenComparisonToString();
        ArrayList<Expression> newVals = new ArrayList<Expression>(scrit.getValues().size());
        if (scrit.getExpression().getType() != DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass()) {
            for (Expression value : scrit.getValues()) {
                this.setDesiredType(value, exprType, scrit);
                if (value.getType() != exprType) {
                    String valTypeName = this.getDataTypeManager().getDataTypeName(value.getType());
                    if (!attemptConvert && !ResolverVisitor.isCharacter(value.getType(), true)) continue;
                    try {
                        newVals.add(ResolverUtil.convertExpression(value, valTypeName, exprTypeName, this.metadata));
                        continue;
                    }
                    catch (QueryResolverException e) {
                        if (value instanceof Constant && this.isCharacter(value, true) && !this.metadata.widenComparisonToString()) {
                            throw e;
                        }
                        if (type != null) break;
                        type = value.getType();
                        break;
                    }
                }
                newVals.add(value);
            }
            if (newVals.size() == scrit.getValues().size()) {
                scrit.setValues(newVals);
                return;
            }
        }
        if (type == null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30077, scrit));
        }
        String setTypeName = this.getDataTypeManager().getDataTypeName(type);
        if (!ResolverVisitor.isCharacter(type, true) || this.metadata.widenComparisonToString() || scrit.getExpression().getType() == DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass()) {
            scrit.setExpression(ResolverUtil.convertExpression((Expression)scrit.getExpression(), exprTypeName, setTypeName, this.metadata));
        } else if (type != scrit.getExpression().getType()) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31172, scrit));
        }
        boolean exprChar = this.isCharacter((Expression)scrit.getExpression(), true);
        newVals.clear();
        for (Expression value : scrit.getValues()) {
            if (value.getType() == null) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30075, value));
            }
            if (value.getType() != type) {
                if (!this.metadata.widenComparisonToString() && exprChar ^ this.isCharacter(value, true)) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31172, scrit));
                }
                value = ResolverUtil.convertExpression(value, setTypeName, this.metadata);
            }
            newVals.add(value);
        }
        scrit.setValues(newVals);
    }

    void resolveCaseExpression(CaseExpression obj) throws Exception {
        String whenTypeName;
        if (obj.getType() != null) {
            return;
        }
        int whenCount = obj.getWhenCount();
        Expression expr = obj.getExpression();
        Class<?> whenType = null;
        Class<?> thenType = null;
        int i = 0;
        while (i < whenCount) {
            if (whenType == null) {
                whenType = obj.getWhenExpression(i).getType();
            }
            if (thenType == null) {
                thenType = obj.getThenExpression(i).getType();
            }
            ++i;
        }
        Expression elseExpr = obj.getElseExpression();
        if (elseExpr != null && thenType == null) {
            thenType = elseExpr.getType();
        }
        ArrayList<String> whenTypeNames = new ArrayList<String>(whenCount + 1);
        ArrayList<String> thenTypeNames = new ArrayList<String>(whenCount + 1);
        this.setDesiredType(expr, whenType, obj);
        whenTypeNames.add(this.getDataTypeManager().getDataTypeName(expr.getType()));
        Expression when = null;
        Expression then = null;
        boolean whenNotChar = false;
        int i2 = 0;
        while (i2 < whenCount) {
            when = obj.getWhenExpression(i2);
            then = obj.getThenExpression(i2);
            this.setDesiredType(when, expr.getType(), obj);
            this.setDesiredType(then, thenType, obj);
            if (!whenTypeNames.contains(this.getDataTypeManager().getDataTypeName(when.getType()))) {
                whenTypeNames.add(this.getDataTypeManager().getDataTypeName(when.getType()));
            }
            if (!ResolverVisitor.isCharacter(when.getType(), true)) {
                whenNotChar = true;
            }
            if (!thenTypeNames.contains(this.getDataTypeManager().getDataTypeName(then.getType()))) {
                thenTypeNames.add(this.getDataTypeManager().getDataTypeName(then.getType()));
            }
            ++i2;
        }
        if (elseExpr != null) {
            this.setDesiredType(elseExpr, thenType, obj);
            if (!thenTypeNames.contains(this.getDataTypeManager().getDataTypeName(elseExpr.getType()))) {
                thenTypeNames.add(this.getDataTypeManager().getDataTypeName(elseExpr.getType()));
            }
        }
        if ((whenTypeName = ResolverUtil.getCommonType(this.getTeiidVersion(), whenTypeNames.toArray(new String[whenTypeNames.size()]))) == null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30079, "WHEN", obj));
        }
        if (!this.metadata.widenComparisonToString() && whenNotChar && ResolverVisitor.isCharacter(this.getDataTypeManager().getDataTypeClass(whenTypeName), true)) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31172, obj));
        }
        String thenTypeName = ResolverUtil.getCommonType(this.getTeiidVersion(), thenTypeNames.toArray(new String[thenTypeNames.size()]));
        if (thenTypeName == null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30079, "THEN/ELSE", obj));
        }
        obj.setExpression(ResolverUtil.convertExpression(obj.getExpression(), whenTypeName, this.metadata));
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        int i3 = 0;
        while (i3 < whenCount) {
            whens.add(ResolverUtil.convertExpression(obj.getWhenExpression(i3), whenTypeName, this.metadata));
            thens.add(ResolverUtil.convertExpression(obj.getThenExpression(i3), thenTypeName, this.metadata));
            ++i3;
        }
        obj.setWhen(whens, thens);
        if (elseExpr != null) {
            obj.setElseExpression(ResolverUtil.convertExpression(elseExpr, thenTypeName, this.metadata));
        }
        obj.setType(this.getDataTypeManager().getDataTypeClass(thenTypeName));
    }

    private void setDesiredType(Expression obj, Class<?> type, LanguageObject surrounding) throws Exception {
        ResolverUtil.setDesiredType(obj, type, surrounding);
        if (!(obj instanceof Function)) {
            return;
        }
        if (this.unresolvedFunctions != null) {
            Function f = (Function)obj;
            if (f.getFunctionDescriptor() != null) {
                return;
            }
            this.unresolvedFunctions.remove(obj);
            obj.acceptVisitor((ILanguageVisitor)this);
            Exception e = this.unresolvedFunctions.get(obj);
            if (e != null) {
                throw e;
            }
        }
    }

    void resolveSearchedCaseExpression(SearchedCaseExpression obj) throws Exception {
        String thenTypeName;
        if (obj.getType() != null) {
            return;
        }
        int whenCount = obj.getWhenCount();
        Class<?> thenType = null;
        int i = 0;
        while (i < whenCount) {
            if (thenType == null) {
                thenType = obj.getThenExpression(i).getType();
            }
            ++i;
        }
        Expression elseExpr = obj.getElseExpression();
        if (elseExpr != null && thenType == null) {
            thenType = elseExpr.getType();
        }
        ArrayList<String> thenTypeNames = new ArrayList<String>(whenCount + 1);
        Expression then = null;
        int i2 = 0;
        while (i2 < whenCount) {
            then = obj.getThenExpression(i2);
            this.setDesiredType(then, thenType, obj);
            thenTypeNames.add(this.getDataTypeManager().getDataTypeName(then.getType()));
            ++i2;
        }
        if (elseExpr != null) {
            this.setDesiredType(elseExpr, thenType, obj);
            thenTypeNames.add(this.getDataTypeManager().getDataTypeName(elseExpr.getType()));
        }
        if ((thenTypeName = ResolverUtil.getCommonType(this.getTeiidVersion(), thenTypeNames.toArray(new String[thenTypeNames.size()]))) == null) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30079, "THEN/ELSE", obj));
        }
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        int i3 = 0;
        while (i3 < whenCount) {
            thens.add(ResolverUtil.convertExpression(obj.getThenExpression(i3), thenTypeName, this.metadata));
            ++i3;
        }
        obj.setWhen(obj.getWhen(), thens);
        if (elseExpr != null) {
            obj.setElseExpression(ResolverUtil.convertExpression(elseExpr, thenTypeName, this.metadata));
        }
        obj.setType(this.getDataTypeManager().getDataTypeClass(thenTypeName));
    }

    public void resolveLanguageObject(LanguageObject obj, IQueryMetadataInterface metadata) throws Exception {
        this.resolveLanguageObject(obj, null, metadata);
    }

    public void resolveLanguageObject(LanguageObject obj, Collection<GroupSymbol> groups, IQueryMetadataInterface metadata) throws Exception {
        this.resolveLanguageObject(obj, groups, null, metadata);
    }

    public void resolveLanguageObject(LanguageObject obj, Collection<GroupSymbol> groups, GroupContext externalContext, IQueryMetadataInterface metadata) throws Exception {
        if (obj == null) {
            return;
        }
        ArgCheck.isTrue(obj.getTeiidVersion().compareTo(this.getTeiidVersion()), "version of visitor should match version of object");
        this.setGroups(groups);
        this.externalContext = externalContext;
        this.metadata = metadata;
        this.setFindShortName(metadata);
        PostOrderNavigator.doVisit(obj, this);
        this.throwException(true);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_6)
    public boolean hasUserDefinedAggregate() {
        return this.hasUserDefinedAggregate;
    }

    @Deprecated
    public void setProperty(String propertyName, Object value) {
    }
}

