/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;

public abstract class Command
extends SimpleNode
implements ICommand<Expression, LanguageVisitor> {
    private static List<Expression> updateCommandSymbol;
    private Option option;
    private CacheHint cacheHint;
    private SourceHint sourceHint;
    private boolean isResolved;
    private transient GroupContext externalGroups;
    private SymbolMap correlatedReferences;
    protected TempMetadataStore tempGroupIDs;

    public Command(TeiidParser p, int id) {
        super(p, id);
    }

    public Option getOption() {
        return this.option;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public SourceHint getSourceHint() {
        return this.sourceHint;
    }

    public boolean returnsResultSet() {
        return false;
    }

    public List<? extends Expression> getResultSetColumns() {
        if (this.returnsResultSet() || this.parser.getVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0)) {
            return this.getProjectedSymbols();
        }
        return Collections.emptyList();
    }

    public void setSourceHint(SourceHint sourceHint) {
        this.sourceHint = sourceHint;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setIsResolved(boolean isResolved) {
        this.isResolved = isResolved;
    }

    public List<Expression> getUpdateCommandSymbol() {
        if (updateCommandSymbol == null) {
            ElementSymbol symbol = (ElementSymbol)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
            symbol.setName("Count");
            symbol.setType(DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass());
            updateCommandSymbol = Arrays.asList(symbol);
        }
        return updateCommandSymbol;
    }

    public CacheHint getCacheHint() {
        return this.cacheHint;
    }

    public void setCacheHint(CacheHint cacheHint) {
        this.cacheHint = cacheHint;
    }

    protected void copyMetadataState(Command copy) {
        if (this.getExternalGroupContexts() != null) {
            copy.externalGroups = this.externalGroups.clone();
        }
        if (this.tempGroupIDs != null) {
            copy.setTemporaryMetadata(this.tempGroupIDs.clone());
        }
        copy.setIsResolved(this.isResolved());
        if (this.correlatedReferences != null) {
            copy.correlatedReferences = this.correlatedReferences.clone();
        }
        if (this.getOption() != null) {
            copy.setOption(this.getOption().clone());
        }
        copy.sourceHint = this.sourceHint;
    }

    public TempMetadataStore getTemporaryMetadata() {
        return this.tempGroupIDs;
    }

    public void setTemporaryMetadata(TempMetadataStore metadata) {
        this.tempGroupIDs = metadata;
    }

    public void addExternalGroupToContext(GroupSymbol group) {
        this.getExternalGroupContexts().addGroup(group);
    }

    public void setExternalGroupContexts(GroupContext root) {
        this.externalGroups = root == null ? null : root.clone();
    }

    public void pushNewResolvingContext(Collection<GroupSymbol> groups) {
        this.externalGroups = new GroupContext(this.externalGroups, new LinkedList<GroupSymbol>(groups));
    }

    public GroupContext getExternalGroupContexts() {
        if (this.externalGroups == null) {
            this.externalGroups = new GroupContext();
        }
        return this.externalGroups;
    }

    public List<GroupSymbol> getAllExternalGroups() {
        if (this.externalGroups == null) {
            return Collections.emptyList();
        }
        return this.externalGroups.getAllGroups();
    }

    protected void printCommandTree(StringBuffer str, int tabLevel) {
        int i = 0;
        while (i < tabLevel) {
            str.append("\t");
            ++i;
        }
        str.append(this.toString());
        str.append("\n");
        ++tabLevel;
        for (Command subCommand : CommandCollectorVisitor.getCommands(this)) {
            subCommand.printCommandTree(str, tabLevel);
        }
    }

    public String printCommandTree() {
        StringBuffer str = new StringBuffer();
        this.printCommandTree(str, 0);
        return str.toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isResolved ? 1231 : 1237);
        result = 31 * result + (this.option == null ? 0 : this.option.hashCode());
        result = 31 * result + (this.sourceHint == null ? 0 : this.sourceHint.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Command other = (Command)obj;
        if (this.isResolved != other.isResolved) {
            return false;
        }
        if (this.option == null ? other.option != null : !this.option.equals(other.option)) {
            return false;
        }
        return !(this.sourceHint == null ? other.sourceHint != null : !this.sourceHint.equals(other.sourceHint));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public abstract Command clone();
}

