/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.teiid.designer.query.sql.IToken;
import org.teiid.designer.query.sql.lang.IComment;
import org.teiid.query.parser.AbstractToken;
import org.teiid.runtime.client.admin.StringConstants;

public class Comment
implements IComment,
StringConstants {
    private String text = "";
    private int line = -1;
    private int column = -1;
    private int offset = -1;
    private boolean isMultiLine = true;
    private List<? extends IToken> preTokens = null;

    public Comment() {
    }

    public Comment(String text, int offset) {
        this.text = text;
        this.offset = offset;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public List<? extends IToken> getPreTokens() {
        if (this.preTokens == null) {
            return Collections.emptyList();
        }
        return this.preTokens;
    }

    public void setPreTokens(List<? extends AbstractToken> preTokens) {
        this.preTokens = new LinkedList<AbstractToken>(preTokens);
    }

    public boolean isMultiLine() {
        return this.isMultiLine;
    }

    public void setMultiLine(boolean isMultiLine) {
        this.isMultiLine = isMultiLine;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.isMultiLine ? 1231 : 1237);
        result = 31 * result + this.line;
        result = 31 * result + this.offset;
        result = 31 * result + (this.preTokens == null ? 0 : this.preTokens.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Comment other = (Comment)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.isMultiLine != other.isMultiLine) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.preTokens == null ? other.preTokens != null : !this.preTokens.equals(other.preTokens)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        StringBuffer txt = new StringBuffer("Comment [text=" + this.text + ", line=" + this.line + ", column=" + this.column + ", offset=" + this.offset + ", isMultiLine=" + this.isMultiLine);
        txt.append(", preTokens=");
        if (this.preTokens == null || this.preTokens.isEmpty()) {
            txt.append("[]");
        } else {
            Iterator<? extends IToken> iterator = this.preTokens.iterator();
            while (iterator.hasNext()) {
                IToken token = iterator.next();
                txt.append(token.getText());
                txt.append(" ").append("@").append(" ");
                txt.append(token.getOffset());
                if (!iterator.hasNext()) continue;
                txt.append(",").append(" ");
            }
        }
        txt.append("]");
        return txt.toString();
    }
}

