/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.sql.lang.ICreate;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.Table;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class Create
extends Command
implements TargetedCommand,
ICreate<Expression, LanguageVisitor> {
    private GroupSymbol table;
    private List<ElementSymbol> primaryKey = new ArrayList<ElementSymbol>();
    private List<Column> columns = new ArrayList<Column>();
    private List<ElementSymbol> columnSymbols;
    private Table tableMetadata;
    private String on;
    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    private CommitAction commitAction;

    public Create(TeiidParser p, int id) {
        super(p, id);
    }

    public GroupSymbol getTable() {
        return this.table;
    }

    @Override
    public GroupSymbol getGroup() {
        return this.table;
    }

    public void setTable(GroupSymbol table) {
        this.table = table;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<ElementSymbol> getPrimaryKey() {
        return this.primaryKey;
    }

    public List<ElementSymbol> getColumnSymbols() {
        if (this.columnSymbols == null) {
            this.columnSymbols = new ArrayList<ElementSymbol>(this.columns.size());
            for (Column column : this.columns) {
                ElementSymbol es = (ElementSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
                es.setName(column.getName());
                es.setType(this.getTeiidParser().getDataTypeService().getDataTypeClass(column.getRuntimeType()));
                es.setGroupSymbol(this.table);
                this.columnSymbols.add(es);
            }
        }
        return this.columnSymbols;
    }

    public int getType() {
        return 11;
    }

    public List getProjectedSymbols() {
        return this.getUpdateCommandSymbol();
    }

    public boolean areResultsCachable() {
        return false;
    }

    public void setElementSymbolsAsColumns(List<ElementSymbol> columns) {
        this.columns.clear();
        for (ElementSymbol elementSymbol : columns) {
            Column c = new Column(this.getTeiidVersion());
            if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5)) {
                c.setName(elementSymbol.getShortName());
            } else {
                c.setName(elementSymbol.getName());
            }
            c.setRuntimeType(this.getTeiidParser().getDataTypeService().getDataTypeName(elementSymbol.getType()));
            c.setNullType(BaseColumn.NullType.Nullable);
            this.columns.add(c);
        }
    }

    public String getOn() {
        return this.on;
    }

    public void setOn(String on) {
        this.on = on;
    }

    public Table getTableMetadata() {
        return this.tableMetadata;
    }

    public void setTableMetadata(Table tableMetadata) {
        if (tableMetadata != null) {
            this.columns = tableMetadata.getColumns();
            this.table = (GroupSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
            this.table.setName(tableMetadata.getName());
        }
        this.tableMetadata = tableMetadata;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.columnSymbols == null ? 0 : this.columnSymbols.hashCode());
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.on == null ? 0 : this.on.hashCode());
        result = 31 * result + (this.primaryKey == null ? 0 : this.primaryKey.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + (this.tableMetadata == null ? 0 : this.tableMetadata.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Create other = (Create)obj;
        if (this.columnSymbols == null ? other.columnSymbols != null : !this.columnSymbols.equals(other.columnSymbols)) {
            return false;
        }
        if (this.columns == null) {
            if (other.columns != null) {
                return false;
            }
        } else {
            if (other.columns.size() != this.columns.size()) {
                return false;
            }
            int i = 0;
            while (i < this.columns.size()) {
                Column c = this.columns.get(i);
                Column o = other.columns.get(i);
                DataTypeManagerService dataTypeManager = this.getTeiidParser().getDataTypeService();
                if (!c.getName().equalsIgnoreCase(o.getName()) || dataTypeManager.getDataTypeClass(c.getRuntimeType().toLowerCase()) != dataTypeManager.getDataTypeClass(o.getRuntimeType().toLowerCase()) || c.isAutoIncremented() != o.isAutoIncremented() || c.getNullType() != o.getNullType()) {
                    return false;
                }
                ++i;
            }
        }
        if (this.on == null ? other.on != null : !this.on.equals(other.on)) {
            return false;
        }
        if (this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey)) {
            return false;
        }
        if (this.table == null ? other.table != null : !this.table.equals(other.table)) {
            return false;
        }
        if (this.tableMetadata == null ? other.tableMetadata != null : !this.tableMetadata.equals(other.tableMetadata)) {
            return false;
        }
        return !this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_10) || !(this.commitAction == null ? other.commitAction != null : !this.commitAction.equals((Object)other.commitAction));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Create clone() {
        Create clone = new Create(this.parser, this.id);
        if (this.getTable() != null) {
            clone.setTable(this.getTable().clone());
        }
        clone.columns = new ArrayList<Column>(this.columns.size());
        for (Column column : this.columns) {
            Column copyColumn = new Column(this.getTeiidVersion());
            copyColumn.setName(column.getName());
            copyColumn.setRuntimeType(column.getRuntimeType());
            copyColumn.setAutoIncremented(column.isAutoIncremented());
            copyColumn.setNullType(column.getNullType());
            clone.columns.add(copyColumn);
        }
        clone.primaryKey = this.cloneList(this.primaryKey);
        this.copyMetadataState(clone);
        clone.setTableMetadata(this.tableMetadata);
        if (this.getOn() != null) {
            clone.setOn(this.getOn());
        }
        clone.commitAction = this.commitAction;
        return clone;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    public CommitAction getCommitAction() {
        return this.commitAction;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    public void setCommitAction(CommitAction commitAction) {
        this.commitAction = commitAction;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_10)
    public static enum CommitAction {
        PRESERVE_ROWS;

    }
}

