/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.teiid.designer.annotation.AnnotationUtils;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;

public interface CriteriaOperator {

    public static enum Operator {
        EQ("="),
        NE("<>", "!="),
        LT("<"),
        GT(">"),
        LE("<="),
        GE(">="),
        LIKE("like"),
        IN("in"),
        IS_NULL("is null", "is"),
        BETWEEN("between"),
        NO_TYPE("");

        private Collection<String> symbols = new ArrayList<String>();

        private Operator(String ... symbols) {
            this.symbols.addAll(Arrays.asList(symbols));
        }

        public String toString() {
            String symbol = this.symbols.iterator().next();
            if (symbol == null || symbol.length() == 0) {
                return "??";
            }
            return symbol;
        }

        public int getIndex() {
            return this.ordinal() + 1;
        }

        public Collection<String> getSymbols() {
            return this.symbols;
        }

        public boolean isLessThan(Operator other) {
            return this.getIndex() < other.getIndex();
        }

        public boolean isGreaterThan(Operator other) {
            return this.getIndex() > other.getIndex();
        }

        public static Operator findOperator(int index) {
            Operator[] operatorArray = Operator.values();
            int n = operatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operator op = operatorArray[n2];
                if (op.getIndex() == index) {
                    return op;
                }
                ++n2;
            }
            throw new IllegalStateException();
        }

        public static Operator getOperator(ITeiidServerVersion version, String symbol) {
            Operator[] operatorArray = Operator.values();
            int n = operatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operator operator = operatorArray[n2];
                boolean foundSymbol = false;
                for (String opSymbol : operator.getSymbols()) {
                    if (!opSymbol.equalsIgnoreCase(symbol)) continue;
                    foundSymbol = true;
                    break;
                }
                if (foundSymbol && AnnotationUtils.isApplicable((Enum)operator, (ITeiidServerVersion)version)) {
                    return operator;
                }
                ++n2;
            }
            throw new UnsupportedOperationException("Symbol '" + symbol + "' has no operator in version " + version);
        }
    }
}

