/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.designer.query.sql.lang.IDynamicCommand;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class DynamicCommand
extends Command
implements IDynamicCommand<Expression, LanguageVisitor> {
    private Expression sql;
    private List<ElementSymbol> asColumns;
    private GroupSymbol intoGroup;
    private int updatingModelCount;
    private SetClauseList using;
    private boolean asClauseSet;

    public DynamicCommand(TeiidParser p, int id) {
        super(p, id);
    }

    public int getType() {
        return 10;
    }

    public List getAsColumns() {
        if (this.asColumns == null) {
            return Collections.EMPTY_LIST;
        }
        return this.asColumns;
    }

    public void setAsColumns(List columns) {
        this.asColumns = columns;
    }

    public GroupSymbol getIntoGroup() {
        return this.intoGroup;
    }

    public void setIntoGroup(GroupSymbol intoGroup) {
        this.intoGroup = intoGroup;
    }

    public Expression getSql() {
        return this.sql;
    }

    public void setSql(Expression sql) {
        this.sql = sql;
    }

    public SetClauseList getUsing() {
        return this.using;
    }

    public void setUsing(SetClauseList using) {
        this.using = using;
    }

    public boolean isAsClauseSet() {
        return this.asClauseSet;
    }

    public void setAsClauseSet(boolean asClauseSet) {
        this.asClauseSet = asClauseSet;
    }

    public int getUpdatingModelCount() {
        return this.updatingModelCount;
    }

    public void setUpdatingModelCount(int count) {
        if (count < 0) {
            count = 0;
        } else if (count > 2) {
            count = 2;
        }
        this.updatingModelCount = count;
    }

    @Override
    public boolean returnsResultSet() {
        return this.intoGroup == null;
    }

    public List<Expression> getProjectedSymbols() {
        if (this.intoGroup != null) {
            return this.getUpdateCommandSymbol();
        }
        if (this.asColumns != null) {
            ArrayList<Expression> ps = new ArrayList<Expression>();
            for (ElementSymbol es : this.asColumns) {
                ps.add(es);
            }
            return ps;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.asClauseSet ? 1231 : 1237);
        result = 31 * result + (this.asColumns == null ? 0 : this.asColumns.hashCode());
        result = 31 * result + (this.intoGroup == null ? 0 : this.intoGroup.hashCode());
        result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
        result = 31 * result + this.updatingModelCount;
        result = 31 * result + (this.using == null ? 0 : this.using.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicCommand other = (DynamicCommand)obj;
        if (this.asClauseSet != other.asClauseSet) {
            return false;
        }
        if (this.asColumns == null ? other.asColumns != null : !this.asColumns.equals(other.asColumns)) {
            return false;
        }
        if (this.intoGroup == null ? other.intoGroup != null : !this.intoGroup.equals(other.intoGroup)) {
            return false;
        }
        if (this.sql == null ? other.sql != null : !this.sql.equals(other.sql)) {
            return false;
        }
        if (this.updatingModelCount != other.updatingModelCount) {
            return false;
        }
        return !(this.using == null ? other.using != null : !this.using.equals(other.using));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public DynamicCommand clone() {
        DynamicCommand clone = new DynamicCommand(this.parser, this.id);
        if (this.getAsColumns() != null && !this.getAsColumns().isEmpty()) {
            clone.setAsColumns(this.cloneList(this.getAsColumns()));
        }
        if (this.getIntoGroup() != null) {
            clone.setIntoGroup(this.getIntoGroup().clone());
        }
        if (this.getSql() != null) {
            clone.setSql(this.getSql().clone());
        }
        if (this.getUsing() != null) {
            clone.setUsing(this.getUsing().clone());
        }
        clone.setAsClauseSet(this.isAsClauseSet());
        clone.setUpdatingModelCount(this.getUpdatingModelCount());
        if (this.getSourceHint() != null) {
            clone.setSourceHint(this.getSourceHint());
        }
        if (this.getOption() != null) {
            clone.setOption(this.getOption().clone());
        }
        this.copyMetadataState(clone);
        return clone;
    }
}

