/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.sql.lang.IGroupBy;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.symbol.Expression;

public class GroupBy
extends SimpleNode
implements IGroupBy<Expression, LanguageVisitor> {
    private List<Expression> symbols = new ArrayList<Expression>();
    @Since(value=TeiidServerVersion.Version.TEIID_8_5)
    private boolean rollup;

    public GroupBy(TeiidParser p, int id) {
        super(p, id);
    }

    public List<Expression> getSymbols() {
        return this.symbols;
    }

    public void addSymbol(Expression symbol) {
        if (symbol != null) {
            this.symbols.add(symbol);
        }
    }

    public int getCount() {
        return this.symbols.size();
    }

    public void setSymbols(List<Expression> symbols) {
        this.symbols = symbols;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.symbols == null ? 0 : this.symbols.hashCode());
        result = 31 * result + (this.rollup ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupBy other = (GroupBy)obj;
        if (this.symbols == null ? other.symbols != null : !this.symbols.equals(other.symbols)) {
            return false;
        }
        return this.rollup == other.rollup;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public GroupBy clone() {
        GroupBy clone = new GroupBy(this.parser, this.id);
        if (this.getSymbols() != null) {
            clone.setSymbols(this.cloneList(this.getSymbols()));
        }
        clone.setRollup(this.isRollup());
        return clone;
    }

    public boolean isRollup() {
        if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5)) {
            return this.rollup;
        }
        return false;
    }

    public void setRollup(boolean rollup) {
        if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5)) {
            this.rollup = rollup;
        }
    }
}

