/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.teiid.designer.query.sql.lang.IGroupContext;
import org.teiid.query.sql.symbol.GroupSymbol;

public class GroupContext
implements Cloneable,
IGroupContext {
    private Collection<GroupSymbol> groups;
    private GroupContext parent;

    public GroupContext() {
        this(null, null);
    }

    public GroupContext(GroupContext parent, Collection<GroupSymbol> groups) {
        this.parent = parent;
        this.groups = groups == null ? new LinkedList<GroupSymbol>() : groups;
    }

    public Collection<GroupSymbol> getGroups() {
        return this.groups;
    }

    public void addGroup(GroupSymbol symbol) {
        this.groups.add(symbol);
    }

    public GroupContext getParent() {
        return this.parent;
    }

    public List<GroupSymbol> getAllGroups() {
        LinkedList<GroupSymbol> result = new LinkedList<GroupSymbol>();
        GroupContext root = this;
        while (root != null) {
            result.addAll(root.getGroups());
            root = root.getParent();
        }
        return result;
    }

    public GroupContext clone() {
        return new GroupContext(this.parent, new LinkedList<GroupSymbol>(this.groups));
    }

    public String toString() {
        String result = this.groups.toString();
        if (this.parent != null) {
            result = String.valueOf(result) + "\n" + this.parent.toString();
        }
        return result;
    }
}

