/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.designer.query.sql.lang.IJoinPredicate;
import org.teiid.designer.query.sql.lang.IJoinType;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.GroupSymbol;

public class JoinPredicate
extends FromClause
implements IJoinPredicate<FromClause, LanguageVisitor> {
    private FromClause leftClause;
    private FromClause rightClause;
    private JoinType joinType;
    private List<Criteria> joinCriteria;

    public JoinPredicate(TeiidParser p, int id) {
        super(p, id);
        this.joinType = (JoinType)p.createASTNode(TeiidNodeFactory.ASTNodes.JOIN_TYPE);
        this.joinType.setKind(IJoinType.Types.JOIN_INNER);
    }

    public void setLeftClause(FromClause predicate) {
        this.leftClause = predicate;
    }

    public FromClause getLeftClause() {
        return this.leftClause;
    }

    public void setRightClause(FromClause predicate) {
        this.rightClause = predicate;
    }

    public FromClause getRightClause() {
        return this.rightClause;
    }

    public void setJoinType(JoinType type) {
        this.joinType = type;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinCriteria(List<Criteria> criteria) {
        ArrayList<Criteria> newCriteria = new ArrayList<Criteria>();
        for (Criteria criterium : criteria) {
            newCriteria.addAll(Criteria.separateCriteriaByAnd(criterium));
        }
        this.joinCriteria = newCriteria;
    }

    public List getJoinCriteria() {
        return this.joinCriteria;
    }

    @Override
    public void collectGroups(Collection<GroupSymbol> groups) {
        if (this.leftClause != null) {
            this.leftClause.collectGroups(groups);
        }
        if (this.rightClause != null) {
            this.rightClause.collectGroups(groups);
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.joinCriteria == null ? 0 : this.joinCriteria.hashCode());
        result = 31 * result + (this.joinType == null ? 0 : this.joinType.hashCode());
        result = 31 * result + (this.leftClause == null ? 0 : this.leftClause.hashCode());
        result = 31 * result + (this.rightClause == null ? 0 : this.rightClause.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinPredicate other = (JoinPredicate)obj;
        if (this.joinCriteria == null ? other.joinCriteria != null : !this.joinCriteria.equals(other.joinCriteria)) {
            return false;
        }
        if (this.joinType == null ? other.joinType != null : !this.joinType.equals(other.joinType)) {
            return false;
        }
        if (this.leftClause == null ? other.leftClause != null : !this.leftClause.equals(other.leftClause)) {
            return false;
        }
        return !(this.rightClause == null ? other.rightClause != null : !this.rightClause.equals(other.rightClause));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public JoinPredicate clone() {
        JoinPredicate clone = new JoinPredicate(this.parser, this.id);
        if (this.getLeftClause() != null) {
            clone.setLeftClause(this.getLeftClause().clone());
        }
        if (this.getRightClause() != null) {
            clone.setRightClause(this.getRightClause().clone());
        }
        if (this.getJoinType() != null) {
            clone.setJoinType(this.getJoinType().clone());
        }
        if (this.getJoinCriteria() != null) {
            clone.setJoinCriteria(this.cloneList(this.getJoinCriteria()));
        }
        clone.setOptional(this.isOptional());
        clone.setMakeInd(this.isMakeInd());
        clone.setMakeInd(this.getMakeInd());
        clone.setNoUnnest(this.isNoUnnest());
        clone.setMakeDep(this.isMakeDep());
        clone.setMakeNotDep(this.isMakeNotDep());
        clone.setPreserve(this.isPreserve());
        return clone;
    }
}

