/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.teiid.core.util.LRUCache;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.designer.query.sql.lang.IMatchCriteria;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class MatchCriteria
extends Criteria
implements PredicateCriteria,
IMatchCriteria<Expression, LanguageVisitor> {
    public static final char NULL_ESCAPE_CHAR = '\u0000';
    private static final char DEFAULT_ESCAPE_CHAR = (char)(PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.backslashDefaultMatchEscape", false) ? 92 : 0);
    private Expression leftExpression;
    private Expression rightExpression;
    private boolean negated;
    private char escapeChar = DEFAULT_ESCAPE_CHAR;
    private IMatchCriteria.MatchMode mode = IMatchCriteria.MatchMode.LIKE;
    private static final LRUCache<List<?>, Pattern> patternCache = new LRUCache(100);

    public MatchCriteria(TeiidParser p, int id) {
        super(p, id);
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negationFlag) {
        this.negated = negationFlag;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public IMatchCriteria.MatchMode getMode() {
        return this.mode;
    }

    public void setMode(IMatchCriteria.MatchMode mode) {
        this.mode = mode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.escapeChar;
        result = 31 * result + (this.leftExpression == null ? 0 : this.leftExpression.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.negated ? 1231 : 1237);
        result = 31 * result + (this.rightExpression == null ? 0 : this.rightExpression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatchCriteria other = (MatchCriteria)obj;
        if (this.escapeChar != other.escapeChar) {
            return false;
        }
        if (this.leftExpression == null ? other.leftExpression != null : !this.leftExpression.equals(other.leftExpression)) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.negated != other.negated) {
            return false;
        }
        return !(this.rightExpression == null ? other.rightExpression != null : !this.rightExpression.equals(other.rightExpression));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public MatchCriteria clone() {
        MatchCriteria clone = new MatchCriteria(this.parser, this.id);
        if (this.getRightExpression() != null) {
            clone.setRightExpression(this.getRightExpression().clone());
        }
        if (this.getLeftExpression() != null) {
            clone.setLeftExpression(this.getLeftExpression().clone());
        }
        if (this.getMode() != null) {
            clone.setMode(this.getMode());
        }
        clone.setNegated(this.isNegated());
        clone.setEscapeChar(this.getEscapeChar());
        return clone;
    }

    public static Pattern getPattern(String newPattern, String originalPattern, int flags) throws Exception {
        List<Serializable> key = Arrays.asList(newPattern, flags);
        Pattern p = (Pattern)patternCache.get(key);
        if (p == null) {
            try {
                p = Pattern.compile(newPattern, 32);
                patternCache.put(key, p);
            }
            catch (PatternSyntaxException e) {
                throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30448, originalPattern, e.getMessage()));
            }
        }
        return p;
    }

    public static class PatternTranslator {
        private char[] reserved;
        private char newEscape;
        private char[] toReplace;
        private String[] replacements;
        private int flags;
        private final LRUCache<List<?>, Pattern> cache = new LRUCache(100);

        public PatternTranslator(char[] toReplace, String[] replacements, char[] reserved, char newEscape, int flags) {
            this.reserved = reserved;
            this.newEscape = newEscape;
            this.toReplace = toReplace;
            this.replacements = replacements;
            this.flags = flags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Pattern translate(String pattern, char escape) throws Exception {
            List<Serializable> key = Arrays.asList(pattern, Character.valueOf(escape));
            Pattern result = null;
            LRUCache<List<?>, Pattern> lRUCache = this.cache;
            synchronized (lRUCache) {
                result = (Pattern)this.cache.get(key);
            }
            if (result == null) {
                String newPattern = this.getPatternString(pattern, escape);
                result = MatchCriteria.getPattern(newPattern, pattern, this.flags);
                LRUCache<List<?>, Pattern> lRUCache2 = this.cache;
                synchronized (lRUCache2) {
                    this.cache.put(key, result);
                }
            }
            return result;
        }

        public String getPatternString(String pattern, char escape) throws Exception {
            int startChar = 0;
            StringBuffer newPattern = new StringBuffer(pattern.length());
            if (pattern.length() > 0 && pattern.charAt(0) == '%') {
                startChar = 1;
            } else {
                newPattern.append('^');
            }
            boolean escaped = false;
            boolean endsWithMatchAny = false;
            int i = startChar;
            while (i < pattern.length()) {
                char character = pattern.charAt(i);
                if (character == escape && character != '\u0000') {
                    if (escaped) {
                        this.appendCharacter(newPattern, character);
                        escaped = false;
                    } else {
                        escaped = true;
                    }
                } else {
                    int index = Arrays.binarySearch(this.toReplace, character);
                    if (index >= 0) {
                        if (escaped) {
                            this.appendCharacter(newPattern, character);
                            escaped = false;
                        } else if (character == '%' && i == pattern.length() - 1) {
                            endsWithMatchAny = true;
                        } else {
                            newPattern.append(this.replacements[index]);
                        }
                    } else {
                        if (escaped) {
                            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30449, pattern, new Character(escape)));
                        }
                        this.appendCharacter(newPattern, character);
                    }
                }
                ++i;
            }
            if (escaped) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30449, pattern, new Character(escape)));
            }
            if (!endsWithMatchAny) {
                newPattern.append('$');
            }
            return newPattern.toString();
        }

        private void appendCharacter(StringBuffer newPattern, char character) {
            if (Arrays.binarySearch(this.reserved, character) >= 0) {
                newPattern.append(this.newEscape);
            }
            newPattern.append(character);
        }
    }
}

