/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.annotation.Updated;
import org.teiid.designer.query.sql.lang.IOption;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Option
extends SimpleNode
implements IOption<LanguageVisitor> {
    public static final String MAKEDEP = "MAKEDEP";
    public static final String MAKENOTDEP = "MAKENOTDEP";
    public static final String OPTIONAL = "optional";
    private List<String> makeDependentGroups;
    @Since(value=TeiidServerVersion.Version.TEIID_8_12_4)
    private List<String> makeIndependentGroups;
    @Since(value=TeiidServerVersion.Version.TEIID_8_5)
    private List<MakeDep> makeDependentOptions;
    @Since(value=TeiidServerVersion.Version.TEIID_8_12_4)
    private List<MakeDep> makeIndependentOptions;
    private List<String> makeNotDependentGroups;
    private List<String> noCacheGroups;
    private boolean noCache;

    public Option(TeiidParser p, int id) {
        super(p, id);
    }

    public void addDependentGroup(String group) {
        this.addDependentGroup(group, new MakeDep(this.getTeiidVersion()));
    }

    public void addDependentGroup(String group, MakeDep makedep) {
        if (makedep == null) {
            return;
        }
        if (this.makeDependentGroups == null) {
            this.makeDependentGroups = new ArrayList<String>();
            this.makeDependentOptions = new ArrayList<MakeDep>();
        }
        this.makeDependentGroups.add(group);
        this.makeDependentOptions.add(makedep);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_12_4)
    public void addIndependentGroup(String group, MakeDep makedep) {
        if (this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_12_4)) {
            return;
        }
        if (makedep == null) {
            return;
        }
        if (this.makeIndependentGroups == null) {
            this.makeIndependentGroups = new ArrayList<String>();
            this.makeIndependentOptions = new ArrayList<MakeDep>();
        }
        this.makeIndependentGroups.add(group);
        this.makeIndependentOptions.add(makedep);
    }

    public List<String> getDependentGroups() {
        return this.makeDependentGroups;
    }

    public List<MakeDep> getMakeDepOptions() {
        return this.makeDependentOptions;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_12_4)
    public List<MakeDep> getMakeIndependentOptions() {
        if (this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_12_4)) {
            return Collections.emptyList();
        }
        return this.makeIndependentOptions;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_12_4)
    public List<String> getMakeIndependentGroups() {
        if (this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_12_4)) {
            return Collections.emptyList();
        }
        return this.makeIndependentGroups;
    }

    public void addNotDependentGroup(String group) {
        if (this.makeNotDependentGroups == null) {
            this.makeNotDependentGroups = new ArrayList<String>();
        }
        this.makeNotDependentGroups.add(group);
    }

    public List<String> getNotDependentGroups() {
        return this.makeNotDependentGroups;
    }

    public void addNoCacheGroup(String group) {
        if (this.noCacheGroups == null) {
            this.noCacheGroups = new ArrayList<String>();
        }
        this.noCacheGroups.add(group);
    }

    public List<String> getNoCacheGroups() {
        return this.noCacheGroups;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.makeDependentGroups == null ? 0 : this.makeDependentGroups.hashCode());
        result = 31 * result + (this.makeDependentOptions == null ? 0 : this.makeDependentOptions.hashCode());
        if (!this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_12_4)) {
            result = 31 * result + (this.makeIndependentGroups == null ? 0 : this.makeIndependentGroups.hashCode());
            result = 31 * result + (this.makeIndependentOptions == null ? 0 : this.makeIndependentOptions.hashCode());
        }
        result = 31 * result + (this.makeNotDependentGroups == null ? 0 : this.makeNotDependentGroups.hashCode());
        result = 31 * result + (this.noCache ? 1231 : 1237);
        result = 31 * result + (this.noCacheGroups == null ? 0 : this.noCacheGroups.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        if (this.makeDependentGroups == null ? other.makeDependentGroups != null : !this.makeDependentGroups.equals(other.makeDependentGroups)) {
            return false;
        }
        if (this.makeDependentOptions == null ? other.makeDependentOptions != null : !this.makeDependentOptions.equals(other.makeDependentOptions)) {
            return false;
        }
        if (!this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_12_4)) {
            if (this.makeIndependentGroups == null ? other.makeIndependentGroups != null : !this.makeIndependentGroups.equals(other.makeIndependentGroups)) {
                return false;
            }
            if (this.makeIndependentOptions == null ? other.makeIndependentOptions != null : !this.makeIndependentOptions.equals(other.makeIndependentOptions)) {
                return false;
            }
        }
        if (this.makeNotDependentGroups == null ? other.makeNotDependentGroups != null : !this.makeNotDependentGroups.equals(other.makeNotDependentGroups)) {
            return false;
        }
        if (this.noCache != other.noCache) {
            return false;
        }
        return !(this.noCacheGroups == null ? other.noCacheGroups != null : !this.noCacheGroups.equals(other.noCacheGroups));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Option clone() {
        Option clone = new Option(this.parser, this.id);
        clone.setNoCache(this.isNoCache());
        if (this.makeDependentGroups != null) {
            clone.makeDependentGroups = new ArrayList<String>(this.makeDependentGroups);
            clone.makeDependentOptions = new ArrayList<MakeDep>(this.makeDependentOptions);
        }
        if (this.makeIndependentGroups != null) {
            clone.makeIndependentGroups = new ArrayList<String>(this.makeIndependentGroups);
            clone.makeIndependentOptions = new ArrayList<MakeDep>(this.makeIndependentOptions);
        }
        if (this.getNotDependentGroups() != null) {
            clone.makeNotDependentGroups = new ArrayList<String>(this.getNotDependentGroups());
        }
        if (this.getNoCacheGroups() != null) {
            clone.noCacheGroups = new ArrayList<String>(this.getNoCacheGroups());
        }
        return clone;
    }

    public static class MakeDep {
        private Integer max;
        @Updated(version={TeiidServerVersion.Version.TEIID_8_12_4})
        private Boolean join;
        private ITeiidServerVersion teiidVersion;

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.join == null ? 0 : this.join.hashCode());
            result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MakeDep other = (MakeDep)obj;
            if (this.join == null ? other.join != null : !this.join.equals(other.join)) {
                return false;
            }
            return !(this.max == null ? other.max != null : !this.max.equals(other.max));
        }

        public MakeDep(ITeiidServerVersion teiidVersion) {
            this.teiidVersion = teiidVersion;
        }

        public String toString() {
            return new SQLStringVisitor(this.teiidVersion).appendMakeDepOptions(this).getSQLString();
        }

        public Integer getMax() {
            return this.max;
        }

        public void setMax(Integer max) {
            this.max = max;
        }

        @Updated(version={TeiidServerVersion.Version.TEIID_8_12_4})
        public boolean isJoin() {
            if (this.join == null) {
                return false;
            }
            return this.join;
        }

        @Since(value=TeiidServerVersion.Version.TEIID_8_12_4)
        public Boolean getJoin() {
            return this.join;
        }

        @Updated(version={TeiidServerVersion.Version.TEIID_8_12_4})
        public void setJoin(Boolean join) {
            this.join = join;
        }

        @Updated(version={TeiidServerVersion.Version.TEIID_8_12_4})
        public boolean isSimple() {
            return this.max == null && this.join == null;
        }
    }
}

