/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.query.sql.lang.IOrderBy;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.runtime.client.Messages;

public class OrderBy
extends SimpleNode
implements IOrderBy<Expression, OrderByItem, LanguageVisitor> {
    private List<OrderByItem> orderByItems = new ArrayList<OrderByItem>();

    public OrderBy(TeiidParser p, int id) {
        super(p, id);
    }

    public List<OrderByItem> getOrderByItems() {
        return this.orderByItems;
    }

    public Expression getVariable(int index) {
        return this.orderByItems.get(index).getSymbol();
    }

    public void addVariable(Expression element) {
        this.addVariable(element, true);
    }

    public void addVariable(Expression element, boolean type) {
        if (element == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0021, new Object[0]));
        }
        OrderByItem orderByItem = (OrderByItem)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.ORDER_BY_ITEM);
        orderByItem.setSymbol(element);
        orderByItem.setAscending(type);
        this.orderByItems.add(orderByItem);
    }

    public int getVariableCount() {
        return this.orderByItems.size();
    }

    public int getExpressionPosition(int orderIndex) {
        return this.orderByItems.get(orderIndex).getExpressionPosition();
    }

    public void setExpressionPosition(int orderIndex, int selectIndex) {
        this.orderByItems.get(orderIndex).setExpressionPosition(selectIndex);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.orderByItems == null ? 0 : this.orderByItems.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return !(this.orderByItems == null ? other.orderByItems != null : !this.orderByItems.equals(other.orderByItems));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public OrderBy clone() {
        OrderBy clone = new OrderBy(this.parser, this.id);
        clone.getOrderByItems().addAll(this.cloneList(this.orderByItems));
        return clone;
    }
}

