/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;

public class Query
extends QueryCommand
implements IQuery<Select, From, Into, Criteria, GroupBy, OrderBy, Query, Expression, LanguageVisitor> {
    private Select select;
    private From from;
    private Criteria criteria;
    private GroupBy groupBy;
    private Criteria having;
    private boolean isXML;
    private Into into;
    private List<Expression> selectList;
    @Since(value=TeiidServerVersion.Version.TEIID_8_6)
    private boolean isRowConstructor;

    public Query(TeiidParser p, int id) {
        super(p, id);
    }

    public int getType() {
        return 1;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public From getFrom() {
        return this.from;
    }

    public void setFrom(From from) {
        this.from = from;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public Criteria getHaving() {
        return this.having;
    }

    public void setHaving(Criteria having) {
        this.having = having;
    }

    public boolean isXML() {
        return this.isXML;
    }

    public void setXML(boolean isXML) {
        this.isXML = isXML;
    }

    public Into getInto() {
        return this.into;
    }

    public void setInto(Into into) {
        this.into = into;
    }

    public List<Expression> getSelectList() {
        return this.selectList;
    }

    public void setSelectList(List<Expression> selectList) {
        this.selectList = selectList;
    }

    @Override
    public boolean returnsResultSet() {
        return this.into == null;
    }

    public boolean getIsXML() {
        return this.isXML;
    }

    public void setIsXML(boolean isXML) {
        this.isXML = isXML;
    }

    public boolean isRowConstructor() {
        if (this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_0)) {
            return false;
        }
        return this.isRowConstructor;
    }

    public void setRowConstructor(boolean isRowConstructor) {
        if (this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_0)) {
            return;
        }
        this.isRowConstructor = isRowConstructor;
    }

    public List<Expression> getProjectedSymbols() {
        if (!this.getIsXML()) {
            if (this.getSelect() != null) {
                if (this.getInto() != null) {
                    return this.getUpdateCommandSymbol();
                }
                return this.getSelect().getProjectedSymbols();
            }
            return Collections.emptyList();
        }
        if (this.selectList == null) {
            this.selectList = new ArrayList<Expression>(1);
            ElementSymbol xmlElement = (ElementSymbol)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
            xmlElement.setName("xml");
            xmlElement.setType(DataTypeManagerService.DefaultDataTypes.XML.getTypeClass());
            this.selectList.add(xmlElement);
        }
        return this.selectList;
    }

    public Query getProjectedQuery() {
        return this;
    }

    public boolean hasAggregates() {
        return this.getGroupBy() != null || this.getHaving() != null || !AggregateSymbolCollectorVisitor.getAggregates(this.getSelect(), false).isEmpty();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.criteria == null ? 0 : this.criteria.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.groupBy == null ? 0 : this.groupBy.hashCode());
        result = 31 * result + (this.having == null ? 0 : this.having.hashCode());
        result = 31 * result + (this.into == null ? 0 : this.into.hashCode());
        result = 31 * result + (this.isXML ? 1231 : 1237);
        result = 31 * result + (this.select == null ? 0 : this.select.hashCode());
        result = 31 * result + (this.selectList == null ? 0 : this.selectList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        if (this.criteria == null ? other.criteria != null : !this.criteria.equals(other.criteria)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.groupBy == null ? other.groupBy != null : !this.groupBy.equals(other.groupBy)) {
            return false;
        }
        if (this.having == null ? other.having != null : !this.having.equals(other.having)) {
            return false;
        }
        if (this.into == null ? other.into != null : !this.into.equals(other.into)) {
            return false;
        }
        if (this.isXML != other.isXML) {
            return false;
        }
        if (this.select == null ? other.select != null : !this.select.equals(other.select)) {
            return false;
        }
        return !(this.selectList == null ? other.selectList != null : !this.selectList.equals(other.selectList));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Query clone() {
        Query clone = new Query(this.parser, this.id);
        if (this.getCriteria() != null) {
            clone.setCriteria(this.getCriteria().clone());
        }
        if (this.getSelect() != null) {
            clone.setSelect(this.getSelect().clone());
        }
        if (this.getFrom() != null) {
            clone.setFrom(this.getFrom().clone());
        }
        if (this.getGroupBy() != null) {
            clone.setGroupBy(this.getGroupBy().clone());
        }
        if (this.getHaving() != null) {
            clone.setHaving(this.getHaving().clone());
        }
        clone.setXML(this.isXML());
        if (this.getInto() != null) {
            clone.setInto(this.getInto().clone());
        }
        if (this.getSelectList() != null) {
            clone.setSelectList(this.cloneList(this.getSelectList()));
        }
        if (this.getOrderBy() != null) {
            clone.setOrderBy(this.getOrderBy().clone());
        }
        if (this.getLimit() != null) {
            clone.setLimit(this.getLimit().clone());
        }
        if (this.getWith() != null) {
            clone.setWith(this.cloneList(this.getWith()));
        }
        if (this.getSourceHint() != null) {
            clone.setSourceHint(this.getSourceHint());
        }
        if (this.getOption() != null) {
            clone.setOption(this.getOption().clone());
        }
        clone.setRowConstructor(this.isRowConstructor());
        this.copyMetadataState(clone);
        return clone;
    }
}

